# 画面設計書 50-税グループ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける「税グループ一覧」画面の設計仕様を定義する。

### 本画面の処理概要

税グループ一覧画面は、システムに登録された税グループ（Tax Group）マスタを一覧表示し、税グループの管理・検索を行うための画面である。

**業務上の目的・背景**：税グループは、複数の税をまとめて管理するための仕組みである。請求書や帳票で税を表示する際のグルーピング、小計表示のタイミング（preceding_subtotal）の制御などに使用される。国や会社ごとに異なる税グループを定義することで、多国籍企業や複雑な税制にも対応できる。

**画面へのアクセス方法**：会計モジュールの設定メニューから「税グループ」を選択してアクセスする。TaxGroupResourceはshouldRegisterNavigation = falseのため、直接ナビゲーションには登録されていない。

**主要な操作・処理内容**：
1. 税グループレコードの一覧表示（テーブル形式）
2. グループ化機能（名前、会社、国、作成者など）
3. 税グループの新規作成画面への遷移
4. 個別税グループの詳細・編集画面への遷移
5. 税グループレコードの削除（外部キー制約考慮）
6. 一括削除操作

**画面遷移**：本画面から税グループ作成画面、税グループ詳細画面、税グループ編集画面へ遷移可能。

**権限による表示制御**：会社（company_id）によるデータフィルタリングが適用される。削除操作は外部キー制約によりエラーとなる可能性がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-021 | 税グループ一覧 | 主機能 | 税グループデータの一覧表示・検索 |
| FN-ACC-022 | 税グループ作成 | 遷移先機能 | 新規税グループ作成画面への遷移 |
| FN-ACC-023 | 税グループ編集 | 遷移先機能 | 税グループ編集画面への遷移 |
| FN-ACC-024 | 税グループ詳細 | 遷移先機能 | 税グループ詳細画面への遷移 |

## 画面種別

一覧（List）

## URL/ルーティング

```
/tax-groups
```

## 画面構成

1. **ヘッダーアクションエリア**
   - 新規作成ボタン（CreateAction + heroicon-o-plus-circle）

2. **テーブルエリア**
   - ソート可能なカラム
   - グループ化機能

3. **アクションエリア**
   - 行アクション（表示・編集・削除）
   - 一括アクション（一括削除）

## 入出力項目

該当なし（一覧表示画面のため直接入力項目なし）

## 表示項目

| No | 項目名 | 物理名 | データ型 | 表示形式 | ソート | トグル | 説明 |
|----|--------|--------|----------|----------|--------|--------|------|
| 1 | 会社 | company.name | string | テキスト | ○ | 表示 | 所属会社 |
| 2 | 国 | country.name | string | テキスト | ○ | 表示 | 適用国 |
| 3 | 作成者 | createdBy.name | string | テキスト | ○ | 表示 | 作成ユーザー |
| 4 | 名前 | name | string | テキスト | 検索○ | 表示 | 税グループ名 |
| 5 | 先行小計 | preceding_subtotal | string | テキスト | 検索○ | 表示 | 小計表示ラベル |
| 6 | 作成日時 | created_at | datetime | 日時 | ○ | 非表示 | 作成日時 |
| 7 | 更新日時 | updated_at | datetime | 日時 | ○ | 非表示 | 更新日時 |

## イベント仕様

### 1-新規作成ボタン押下

税グループ作成画面（CreateTaxGroup）へ遷移する。URLは `/tax-groups/create`。

### 2-行クリック（表示）

選択した税グループの詳細画面（ViewTaxGroup）へ遷移する。URLは `/tax-groups/{record}`。

### 3-編集アクション押下

選択した税グループの編集画面（EditTaxGroup）へ遷移する。URLは `/tax-groups/{record}/edit`。

### 4-削除アクション押下

確認ダイアログを表示後、税グループレコードを削除する。外部キー制約違反の場合はエラー通知を表示する。

### 5-一括削除押下

選択した複数の税グループレコードを一括削除する。外部キー制約違反の場合は処理を中断しエラー通知を表示する。

### 6-グループ化選択

選択されたグループ化条件でテーブルデータをグルーピング表示する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | accounts_tax_groups | SELECT | 税グループデータの取得 |
| 削除アクション押下 | accounts_tax_groups | DELETE | 税グループレコードの削除 |
| 一括削除押下 | accounts_tax_groups | DELETE | 複数税グループレコードの削除 |

### テーブル別更新項目詳細

#### accounts_tax_groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | company_id等によるフィルタ | 一覧取得 |
| DELETE | - | id IN (選択されたID) | 外部キー制約あり |

## メッセージ仕様

| No | 種別 | メッセージID | メッセージ内容 |
|----|------|-------------|--------------|
| 1 | 成功 | delete.notification.success.title | 削除成功タイトル |
| 2 | 成功 | delete.notification.success.body | 削除成功メッセージ本文 |
| 3 | エラー | delete.notification.error.title | 削除失敗タイトル |
| 4 | エラー | delete.notification.error.body | 削除失敗メッセージ（外部キー制約） |
| 5 | 成功 | bulk-delete.notification.success.title | 一括削除成功タイトル |
| 6 | 成功 | bulk-delete.notification.success.body | 一括削除成功メッセージ |
| 7 | エラー | bulk-delete.notification.error.title | 一括削除失敗タイトル |
| 8 | エラー | bulk-delete.notification.error.body | 一括削除失敗メッセージ |

## 例外処理

| No | 例外条件 | 処理内容 |
|----|----------|----------|
| 1 | データ取得エラー | エラーメッセージを表示 |
| 2 | 削除時の外部キー制約違反 | QueryException をキャッチしエラー通知を表示 |
| 3 | 一括削除時の外部キー制約違反 | QueryException をキャッチしエラー通知を表示、処理中断 |

## 備考

- TaxGroupはTaxモデルから参照されており、税に紐づいている税グループは削除不可
- SortableTrait によりsortカラムでの並び替えが可能
- 削除操作は try-catch で QueryException をキャッチし、外部キー制約違反時に適切なエラー表示を行う
- 一括削除でaction内で明示的にsuccess()を呼び出している
- created_at, updated_at はデフォルトで非表示（toggleable(isToggledHiddenByDefault: true)）
- グループ化は6種類（name, company.name, country.name, createdBy.name, created_at, updated_at）をサポート
