# 画面設計書 51-税グループ作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける税グループ作成画面の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：税グループ作成画面は、会計モジュールにおいて税金を論理的にグループ化するための新規税グループを作成する機能を提供します。税グループは複数の税率を統合管理し、請求書や会計処理において一貫した税計算を実現するために必要です。国別・会社別に異なる税グループを定義することで、複数国でのビジネス展開やマルチカンパニー運用に対応できます。

**画面へのアクセス方法**：会計モジュールの設定メニューから「税グループ一覧」画面にアクセスし、ヘッダーの「新規作成」ボタンをクリックすることで本画面に遷移します。URLパターンは `/admin/accounts/tax-groups/create` となります。

**主要な操作・処理内容**：
1. 税グループ名の入力（必須）
2. 会社の選択（ドロップダウンから選択）
3. 国の選択（ドロップダウンから選択）
4. 先行小計ラベルの入力（任意）
5. 保存ボタンによるデータ登録

**画面遷移**：税グループ一覧画面から遷移し、作成完了後は作成した税グループの詳細画面（ViewTaxGroup）に自動遷移します。

**権限による表示制御**：会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-022 | 税金グループ管理 | 主機能 | 新規税グループの作成 |

## 画面種別

登録画面

## URL/ルーティング

- パス: `/admin/accounts/tax-groups/create`
- ルート定義: `TaxGroupResource::route('/create')`

## 画面構成

- セクション（フォームコンテナ）
  - 会社選択フィールド
  - 国選択フィールド
  - 税グループ名入力フィールド
  - 先行小計ラベル入力フィールド
- 保存ボタン（フッター）
- キャンセルボタン（フッター）

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|----------|------|--------|-----------|------|
| 会社 | company_id | integer | - | - | 入力 | 所属会社をドロップダウンから選択 |
| 国 | country_id | integer | - | - | 入力 | 適用国をドロップダウンから選択 |
| 税グループ名 | name | string | 必須 | 255 | 入力 | 税グループの名称 |
| 先行小計ラベル | preceding_subtotal | string | - | 255 | 入力 | 請求書上での小計表示ラベル |

## 表示項目

本画面は登録画面のため、表示項目は入力項目と同一です。

## イベント仕様

### 1-保存ボタン押下

保存ボタン押下時、入力されたフォームデータをバリデーション後、`accounts_tax_groups`テーブルにINSERT処理を実行します。処理成功時は成功通知を表示し、作成された税グループの詳細画面（ViewTaxGroup）にリダイレクトします。

### 2-キャンセルボタン押下

キャンセルボタン押下時、入力内容を破棄し税グループ一覧画面に戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_tax_groups | INSERT | 新規税グループレコードを作成 |

### テーブル別更新項目詳細

#### accounts_tax_groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | company_id | フォーム入力値 | 会社ID |
| INSERT | country_id | フォーム入力値 | 国ID |
| INSERT | name | フォーム入力値 | 税グループ名（必須） |
| INSERT | preceding_subtotal | フォーム入力値 | 先行小計ラベル |
| INSERT | creator_id | ログインユーザーID | 作成者ID（自動設定） |
| INSERT | sort | 自動採番 | ソート順（SortableTrait） |
| INSERT | created_at | 現在日時 | 作成日時 |
| INSERT | updated_at | 現在日時 | 更新日時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 税グループが正常に作成されました | 保存処理成功時 |
| MSG-002 | エラー | 税グループ名は必須です | 税グループ名未入力時 |
| MSG-003 | エラー | 税グループ名は255文字以内で入力してください | 最大長超過時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| バリデーションエラー | 必須項目未入力 | エラーメッセージを表示し、フォームを再表示 |
| データベースエラー | DB接続障害等 | システムエラーメッセージを表示 |

## 備考

- 税グループはFilament ResourceのCreateRecordページを継承して実装されています
- ソート順は`Spatie\EloquentSortable`パッケージにより自動管理されます
- 作成者IDは自動的にログインユーザーが設定されます
