# 画面設計書 52-税グループ編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける税グループ編集画面の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：税グループ編集画面は、既存の税グループ情報を修正するための機能を提供します。税制改正や組織変更に伴い、税グループの名称、所属会社、適用国、小計ラベルなどを更新する必要がある場合に使用します。正確な税計算と会計処理を維持するために、税グループ情報を最新の状態に保つことが重要です。

**画面へのアクセス方法**：税グループ一覧画面から対象レコードの編集アクション、または税グループ詳細画面のヘッダーにある「編集」ボタンをクリックすることで本画面に遷移します。URLパターンは `/admin/accounts/tax-groups/{record}/edit` となります。

**主要な操作・処理内容**：
1. 既存データの表示・確認
2. 税グループ名の修正
3. 会社の変更
4. 国の変更
5. 先行小計ラベルの修正
6. 保存ボタンによるデータ更新
7. 削除ボタンによるレコード削除

**画面遷移**：税グループ一覧画面または詳細画面から遷移します。保存完了後は詳細画面（ViewTaxGroup）に自動遷移します。削除時は一覧画面に遷移します。

**権限による表示制御**：会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセス可能です。削除アクションは削除権限を持つユーザーにのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-022 | 税金グループ管理 | 主機能 | 税グループの編集・削除 |

## 画面種別

編集画面

## URL/ルーティング

- パス: `/admin/accounts/tax-groups/{record}/edit`
- ルート定義: `TaxGroupResource::route('/{record}/edit')`

## 画面構成

- ヘッダーアクション
  - 表示ボタン（ViewAction）
  - 削除ボタン（DeleteAction）
- セクション（フォームコンテナ）
  - 会社選択フィールド
  - 国選択フィールド
  - 税グループ名入力フィールド
  - 先行小計ラベル入力フィールド
- 保存ボタン（フッター）
- キャンセルボタン（フッター）

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|----------|------|--------|-----------|------|
| 会社 | company_id | integer | - | - | 入力 | 所属会社をドロップダウンから選択 |
| 国 | country_id | integer | - | - | 入力 | 適用国をドロップダウンから選択 |
| 税グループ名 | name | string | 必須 | 255 | 入力 | 税グループの名称 |
| 先行小計ラベル | preceding_subtotal | string | - | 255 | 入力 | 請求書上での小計表示ラベル |

## 表示項目

編集画面のため、入力項目に既存データが初期表示されます。

## イベント仕様

### 1-保存ボタン押下

保存ボタン押下時、入力されたフォームデータをバリデーション後、`accounts_tax_groups`テーブルの該当レコードをUPDATE処理します。処理成功時は成功通知を表示し、詳細画面（ViewTaxGroup）にリダイレクトします。

### 2-削除ボタン押下

削除ボタン押下時、確認ダイアログを表示後、`accounts_tax_groups`テーブルから該当レコードを削除します。関連データが存在する場合は外部キー制約により削除に失敗し、エラー通知を表示します。

### 3-表示ボタン押下

表示ボタン押下時、該当税グループの詳細画面（ViewTaxGroup）に遷移します。

### 4-キャンセルボタン押下

キャンセルボタン押下時、変更内容を破棄し遷移元画面に戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_tax_groups | UPDATE | 税グループレコードを更新 |
| 削除ボタン押下 | accounts_tax_groups | DELETE | 税グループレコードを削除 |

### テーブル別更新項目詳細

#### accounts_tax_groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | company_id | フォーム入力値 | 会社ID |
| UPDATE | country_id | フォーム入力値 | 国ID |
| UPDATE | name | フォーム入力値 | 税グループ名（必須） |
| UPDATE | preceding_subtotal | フォーム入力値 | 先行小計ラベル |
| UPDATE | updated_at | 現在日時 | 更新日時 |
| DELETE | - | WHERE id = {record} | レコード削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 税グループが正常に更新されました | 保存処理成功時 |
| MSG-002 | 成功 | 税グループが正常に削除されました | 削除処理成功時 |
| MSG-003 | エラー | 税グループ名は必須です | 税グループ名未入力時 |
| MSG-004 | エラー | この税グループは使用中のため削除できません | 外部キー制約違反時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| バリデーションエラー | 必須項目未入力 | エラーメッセージを表示し、フォームを再表示 |
| QueryException | 外部キー制約違反 | エラー通知を表示し、削除処理を中止 |
| レコード未存在 | 対象レコードが存在しない | 404エラー画面を表示 |

## 備考

- 税グループはFilament ResourceのEditRecordページを継承して実装されています
- 削除時は`try-catch`で`QueryException`をキャッチし、関連データ存在時のエラーハンドリングを行っています
- ヘッダーにViewActionとDeleteActionが配置されています
