# 画面設計書 53-税グループ詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける税グループ詳細画面の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：税グループ詳細画面は、登録済みの税グループ情報を参照するための読み取り専用画面です。税グループの設定内容を確認し、必要に応じて編集画面への遷移や削除操作を行う起点となります。会計処理や請求書発行時に適用される税グループの詳細を確認することで、正確な税計算の検証が可能です。

**画面へのアクセス方法**：税グループ一覧画面から対象レコードの表示アクション、または新規作成・編集完了後のリダイレクト先として本画面に遷移します。URLパターンは `/admin/accounts/tax-groups/{record}` となります。

**主要な操作・処理内容**：
1. 税グループ情報の詳細表示
2. 編集ボタンによる編集画面への遷移
3. 削除ボタンによるレコード削除

**画面遷移**：税グループ一覧画面、作成画面、編集画面から遷移します。編集ボタン押下時は編集画面に遷移し、削除時は一覧画面に遷移します。

**権限による表示制御**：会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセス可能です。編集・削除アクションは対応する権限を持つユーザーにのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-022 | 税金グループ管理 | 主機能 | 税グループの詳細表示・削除 |

## 画面種別

詳細画面

## URL/ルーティング

- パス: `/admin/accounts/tax-groups/{record}`
- ルート定義: `TaxGroupResource::route('/{record}')`

## 画面構成

- ヘッダーアクション
  - 編集ボタン（EditAction）
  - 削除ボタン（DeleteAction）
- 情報表示セクション
  - 会社名表示
  - 国名表示
  - 税グループ名表示
  - 先行小計ラベル表示

## 入出力項目

本画面は読み取り専用のため、入力項目はありません。

## 表示項目

| 項目名 | 項目ID | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 会社 | company.name | string | heroicon-o-building-office-2 | 所属会社名 |
| 国 | country.name | string | heroicon-o-globe-alt | 適用国名 |
| 税グループ名 | name | string | heroicon-o-tag | 税グループの名称 |
| 先行小計ラベル | preceding_subtotal | string | heroicon-o-rectangle-group | 請求書上での小計表示ラベル |

## イベント仕様

### 1-編集ボタン押下

編集ボタン押下時、該当税グループの編集画面（EditTaxGroup）に遷移します。

### 2-削除ボタン押下

削除ボタン押下時、確認ダイアログを表示後、`accounts_tax_groups`テーブルから該当レコードを削除します。関連データが存在する場合は外部キー制約により削除に失敗し、エラー通知を表示します。処理成功時は成功通知を表示し、一覧画面に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | accounts_tax_groups | SELECT | 税グループレコードを取得 |
| 削除ボタン押下 | accounts_tax_groups | DELETE | 税グループレコードを削除 |

### テーブル別更新項目詳細

#### accounts_tax_groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | WHERE id = {record} | レコード取得 |
| DELETE | - | WHERE id = {record} | レコード削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 税グループが正常に削除されました | 削除処理成功時 |
| MSG-002 | エラー | この税グループは使用中のため削除できません | 外部キー制約違反時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| QueryException | 外部キー制約違反 | エラー通知を表示し、削除処理を中止 |
| レコード未存在 | 対象レコードが存在しない | 404エラー画面を表示 |

## 備考

- 税グループはFilament ResourceのViewRecordページを継承して実装されています
- 表示項目は`infolist`メソッドで定義されたInfolist形式で表示されます
- 各表示項目にはアイコンが設定されており、値が空の場合は「-」がプレースホルダーとして表示されます
- 削除時は`try-catch`で`QueryException`をキャッチし、関連データ存在時のエラーハンドリングを行っています
