# 画面設計書 54-投稿一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおけるブログ投稿一覧画面（管理者用）の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：投稿一覧画面は、ブログモジュールにおいて管理者がすべてのブログ記事を一元管理するための画面です。企業ブログやお知らせ記事の作成・編集・公開管理を効率的に行うことで、コンテンツマーケティングや情報発信を支援します。プリセットビュー機能により、自分の投稿やアーカイブ済み投稿を素早くフィルタリングできます。

**画面へのアクセス方法**：管理画面のナビゲーションメニューから「ブログ」を選択し、「投稿」をクリックすることで本画面に遷移します。URLパターンは `/admin/website/posts` となります。

**主要な操作・処理内容**：
1. 投稿一覧の表示・検索・フィルタリング
2. カテゴリ・著者・作成日でのグループ化
3. 新規投稿の作成（ヘッダーボタン）
4. 既存投稿の表示・編集・削除
5. 投稿の復元（ソフトデリート済み）
6. 一括削除・一括復元操作
7. プリセットビューによる表示切替（自分の投稿/アーカイブ）

**画面遷移**：ナビゲーションメニューから遷移します。新規作成ボタンで作成画面、各行のアクションで詳細・編集画面に遷移します。

**権限による表示制御**：ブログモジュールへのアクセス権限を持つ管理者ユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-BLOG-001 | ブログ投稿一覧 | 主機能 | 投稿データの一覧表示と検索 |
| FN-BLOG-002 | ブログ投稿作成 | 遷移先機能 | 新規投稿の作成 |
| FN-BLOG-003 | ブログ投稿編集 | 遷移先機能 | 既存投稿の編集 |
| FN-BLOG-004 | ブログ投稿表示 | 遷移先機能 | 投稿詳細の表示 |

## 画面種別

一覧画面

## URL/ルーティング

- パス: `/admin/website/posts`
- ルート定義: `PostResource::route('/')`

## 画面構成

- ヘッダーアクション
  - 新規作成ボタン（CreateAction）
- プリセットビュータブ
  - 自分の投稿（My Posts）
  - アーカイブ（Archived）
- テーブル
  - カラム一覧
  - フィルター
  - グループ化
  - 行アクション
  - 一括アクション

## 入出力項目

本画面は一覧画面のため、フィルター条件が入力項目となります。

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 公開済みフィルター | is_published | boolean | 公開状態でフィルタ |
| 著者フィルター | author_id | integer | 著者でフィルタ |
| 作成者フィルター | creator_id | integer | 作成者でフィルタ |
| カテゴリフィルター | category_id | integer | カテゴリでフィルタ |
| タグフィルター | tags | array | タグでフィルタ |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 検索 | 初期表示 | 説明 |
|--------|--------|----------|--------|------|----------|------|
| タイトル | title | string | 可 | 可 | 表示 | 投稿タイトル |
| スラッグ | slug | string | 可 | - | 表示 | URLスラッグ |
| 著者 | author.name | string | 可 | - | 表示 | 投稿者名 |
| カテゴリ | category.name | string | 可 | - | 非表示 | カテゴリ名 |
| 作成者 | creator.name | string | 可 | - | 非表示 | 作成者名 |
| 公開状態 | is_published | boolean | 可 | - | 表示 | 公開/非公開アイコン |
| 更新日時 | updated_at | datetime | 可 | - | 非表示 | 最終更新日時 |
| 作成日時 | created_at | datetime | 可 | - | 表示 | 作成日時 |

## イベント仕様

### 1-新規作成ボタン押下

新規作成ボタン押下時、投稿作成画面（CreatePost）に遷移します。

### 2-表示アクション押下

表示アクション押下時、該当投稿の詳細画面（ViewPost）に遷移します。削除済み投稿では非表示となります。

### 3-編集アクション押下

編集アクション押下時、該当投稿の編集画面（EditPost）に遷移します。削除済み投稿では非表示となります。

### 4-削除アクション押下

削除アクション押下時、確認ダイアログを表示後、該当投稿をソフトデリートします。

### 5-復元アクション押下

復元アクション押下時、ソフトデリート済みの投稿を復元します。

### 6-完全削除アクション押下

完全削除アクション押下時、確認ダイアログを表示後、該当投稿を完全に削除します。

### 7-一括削除押下

選択した複数投稿を一括でソフトデリートします。

### 8-一括復元押下

選択した複数のソフトデリート済み投稿を一括で復元します。

### 9-一括完全削除押下

選択した複数投稿を一括で完全削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | blogs_posts | SELECT | 投稿レコードを取得 |
| 削除アクション | blogs_posts | UPDATE | deleted_atを設定（ソフトデリート） |
| 復元アクション | blogs_posts | UPDATE | deleted_atをnullに設定 |
| 完全削除アクション | blogs_posts | DELETE | レコードを完全削除 |

### テーブル別更新項目詳細

#### blogs_posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | 条件に応じたWHERE句 | フィルター・検索条件適用 |
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |
| UPDATE（復元） | deleted_at | null | 復元 |
| DELETE | - | WHERE id = {record} | 完全削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 投稿が正常に削除されました | 削除処理成功時 |
| MSG-002 | 成功 | 投稿が正常に復元されました | 復元処理成功時 |
| MSG-003 | 成功 | 投稿が完全に削除されました | 完全削除処理成功時 |
| MSG-004 | 成功 | 選択した投稿を削除しました | 一括削除成功時 |
| MSG-005 | 成功 | 選択した投稿を復元しました | 一括復元成功時 |
| MSG-006 | 成功 | 選択した投稿を完全に削除しました | 一括完全削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| 権限エラー | アクセス権限なし | 403エラー画面を表示 |
| データ未存在 | 対象レコードが存在しない | エラー通知を表示 |

## 備考

- 投稿一覧はFilament ResourceのListRecordsページを継承して実装されています
- `HasTableViews`トレイトを使用してプリセットビュー機能を実装しています
- 「自分の投稿」ビューは`author_id`が現在のユーザーIDと一致するレコードをフィルタリングします
- 「アーカイブ」ビューは`onlyTrashed()`でソフトデリート済みレコードのみを表示します
- カラムの並び替えが可能（reorderableColumns）
- カラムの表示/非表示切替が可能（columnManager）
