# 画面設計書 55-投稿作成

## 概要

本ドキュメントは、Aureus ERPシステムにおけるブログ投稿作成画面の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：投稿作成画面は、ブログモジュールにおいて新規のブログ記事を作成するための機能を提供します。企業ブログ、製品情報、お知らせなどのコンテンツを作成し、SEO情報を設定して公開することで、効果的な情報発信とコンテンツマーケティングを実現します。リッチエディタを使用した本文作成、画像アップロード、SEOメタ情報の設定が可能です。

**画面へのアクセス方法**：投稿一覧画面のヘッダーにある「新規作成」ボタンをクリックすることで本画面に遷移します。URLパターンは `/admin/website/posts/create` となります。

**主要な操作・処理内容**：
1. タイトルの入力（必須、入力時にスラッグを自動生成）
2. サブタイトルの入力（任意）
3. 本文の入力（リッチエディタ、必須）
4. バナー画像のアップロード（任意）
5. カテゴリの選択（必須）
6. タグの選択・作成（任意、複数選択可能）
7. SEO情報の入力（メタタイトル、メタキーワード、メタ説明）
8. 保存ボタンによるデータ登録

**画面遷移**：投稿一覧画面から遷移し、作成完了後は作成した投稿の詳細画面（ViewPost）に自動遷移します。

**権限による表示制御**：ブログモジュールへのアクセス権限を持つ管理者ユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-BLOG-002 | ブログ投稿作成 | 主機能 | 新規ブログ投稿の作成 |

## 画面種別

登録画面

## URL/ルーティング

- パス: `/admin/website/posts/create`
- ルート定義: `PostResource::route('/create')`

## 画面構成

- メインコンテンツエリア（2カラム幅）
  - 一般情報セクション
    - タイトル入力フィールド
    - スラッグ表示フィールド（自動生成、読み取り専用）
    - サブタイトル入力フィールド
    - 本文リッチエディタ
    - バナー画像アップロード
  - SEOセクション
    - メタタイトル入力フィールド
    - メタキーワード入力フィールド
    - メタ説明入力フィールド
- サイドバーエリア（1カラム幅）
  - 設定セクション
    - カテゴリ選択
    - タグ選択（複数選択、新規作成可能）
- 保存ボタン（フッター）
- キャンセルボタン（フッター）

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|----------|------|--------|-----------|------|
| タイトル | title | string | 必須 | 255 | 入力 | 投稿タイトル |
| スラッグ | slug | string | 必須 | 255 | 出力 | URLスラッグ（自動生成） |
| サブタイトル | sub_title | string | - | - | 入力 | サブタイトル |
| 本文 | content | text | 必須 | - | 入力 | 投稿本文（リッチテキスト） |
| バナー画像 | image | file | - | - | 入力 | アイキャッチ画像 |
| カテゴリ | category_id | integer | 必須 | - | 入力 | カテゴリを選択 |
| タグ | tags | array | - | - | 入力 | タグを複数選択 |
| メタタイトル | meta_title | string | - | 255 | 入力 | SEO用タイトル |
| メタキーワード | meta_keywords | string | - | 255 | 入力 | SEO用キーワード |
| メタ説明 | meta_description | text | - | - | 入力 | SEO用説明文 |

## 表示項目

本画面は登録画面のため、表示項目は入力項目と同一です。

## イベント仕様

### 1-タイトル入力時

タイトル入力時（フォーカスアウト時）、入力されたタイトルからスラッグを自動生成し、スラッグフィールドに設定します。スラッグはStr::slug()関数で生成されます。

### 2-保存ボタン押下

保存ボタン押下時、入力されたフォームデータをバリデーション後、以下の処理を実行します：
1. `creator_id`と`author_id`にログインユーザーIDを自動設定
2. `blogs_posts`テーブルにINSERT処理
3. 選択されたタグを`blogs_post_tags`中間テーブルにINSERT

処理成功時は成功通知を表示し、作成された投稿の詳細画面（ViewPost）にリダイレクトします。

### 3-タグ新規作成

タグ選択フィールドで新規タグを作成する場合、タグ名と色を入力するフォームが表示され、`blogs_tags`テーブルに新規レコードが作成されます。

### 4-キャンセルボタン押下

キャンセルボタン押下時、入力内容を破棄し投稿一覧画面に戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | blogs_posts | INSERT | 新規投稿レコードを作成 |
| 保存ボタン押下 | blogs_post_tags | INSERT | 投稿とタグの関連を作成 |
| タグ新規作成 | blogs_tags | INSERT | 新規タグレコードを作成 |

### テーブル別更新項目詳細

#### blogs_posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title | フォーム入力値 | タイトル（必須） |
| INSERT | sub_title | フォーム入力値 | サブタイトル |
| INSERT | content | フォーム入力値 | 本文（必須） |
| INSERT | slug | 自動生成（タイトルから） | URLスラッグ（一意） |
| INSERT | image | アップロードファイルパス | バナー画像 |
| INSERT | category_id | フォーム入力値 | カテゴリID（必須） |
| INSERT | meta_title | フォーム入力値 | メタタイトル |
| INSERT | meta_keywords | フォーム入力値 | メタキーワード |
| INSERT | meta_description | フォーム入力値 | メタ説明 |
| INSERT | creator_id | ログインユーザーID | 作成者ID（自動設定） |
| INSERT | author_id | ログインユーザーID | 著者ID（自動設定） |
| INSERT | is_published | false | 公開状態（初期値：非公開） |
| INSERT | created_at | 現在日時 | 作成日時 |
| INSERT | updated_at | 現在日時 | 更新日時 |

#### blogs_post_tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | post_id | 作成された投稿ID | 投稿ID |
| INSERT | tag_id | 選択されたタグID | タグID |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 投稿が正常に作成されました | 保存処理成功時 |
| MSG-002 | エラー | タイトルは必須です | タイトル未入力時 |
| MSG-003 | エラー | 本文は必須です | 本文未入力時 |
| MSG-004 | エラー | カテゴリを選択してください | カテゴリ未選択時 |
| MSG-005 | エラー | このスラッグは既に使用されています | スラッグ重複時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| バリデーションエラー | 必須項目未入力 | エラーメッセージを表示し、フォームを再表示 |
| ユニーク制約違反 | スラッグ重複 | エラーメッセージを表示し、フォームを再表示 |
| ファイルアップロードエラー | 画像アップロード失敗 | エラーメッセージを表示 |

## 備考

- 投稿作成はFilament ResourceのCreateRecordページを継承して実装されています
- タイトル入力時にスラッグが自動生成されます（`afterStateUpdated`で実装）
- 作成者ID（creator_id）と著者ID（author_id）は`mutateFormDataBeforeCreate`で自動設定されます
- 3カラムレイアウト（メインコンテンツ2カラム、サイドバー1カラム）
- カテゴリ選択では削除済みカテゴリも表示されますが、選択不可となっています
- タグは既存のものを選択するか、新規作成フォームから追加可能です
