# 画面設計書 56-投稿編集

## 概要

本ドキュメントは、Aureus ERPシステムにおけるブログ投稿編集画面の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：投稿編集画面は、既存のブログ記事を修正・更新するための機能を提供します。記事の内容更新、誤字脱字の修正、SEO情報の最適化、公開状態の変更（公開/下書き）など、コンテンツのライフサイクル管理に必要な操作を行えます。最終編集者の追跡により、編集履歴の管理も可能です。

**画面へのアクセス方法**：投稿一覧画面から対象レコードの編集アクション、または投稿詳細画面のサブナビゲーションから「編集」をクリックすることで本画面に遷移します。URLパターンは `/admin/website/posts/{record}/edit` となります。

**主要な操作・処理内容**：
1. 既存データの表示・確認
2. タイトル・サブタイトル・本文の修正
3. バナー画像の変更
4. カテゴリ・タグの変更
5. SEO情報の修正
6. 保存ボタンによるデータ更新
7. 公開ボタンによる記事公開
8. 下書きボタンによる非公開化
9. 削除ボタンによるレコード削除

**画面遷移**：投稿一覧画面または詳細画面から遷移します。保存完了後は詳細画面（ViewPost）に自動遷移します。削除時は一覧画面に遷移します。

**権限による表示制御**：ブログモジュールへのアクセス権限を持つ管理者ユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-BLOG-003 | ブログ投稿編集 | 主機能 | 既存ブログ投稿の編集 |

## 画面種別

編集画面

## URL/ルーティング

- パス: `/admin/website/posts/{record}/edit`
- ルート定義: `PostResource::route('/{record}/edit')`

## 画面構成

- サブナビゲーション（Top位置）
  - 詳細タブ（ViewPost）
  - 編集タブ（EditPost）※現在地
- ヘッダーアクション
  - 公開ボタン（未公開時のみ表示）
  - 下書きボタン（公開時のみ表示）
  - 削除ボタン（DeleteAction）
- メインコンテンツエリア（2カラム幅）
  - 一般情報セクション
    - タイトル入力フィールド
    - スラッグ表示フィールド（読み取り専用）
    - サブタイトル入力フィールド
    - 本文リッチエディタ
    - バナー画像アップロード
  - SEOセクション
    - メタタイトル入力フィールド
    - メタキーワード入力フィールド
    - メタ説明入力フィールド
- サイドバーエリア（1カラム幅）
  - 設定セクション
    - カテゴリ選択
    - タグ選択
- 保存ボタン（フッター）
- キャンセルボタン（フッター）

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|----------|------|--------|-----------|------|
| タイトル | title | string | 必須 | 255 | 入力 | 投稿タイトル |
| スラッグ | slug | string | 必須 | 255 | 出力 | URLスラッグ（読み取り専用） |
| サブタイトル | sub_title | string | - | - | 入力 | サブタイトル |
| 本文 | content | text | 必須 | - | 入力 | 投稿本文（リッチテキスト） |
| バナー画像 | image | file | - | - | 入力 | アイキャッチ画像 |
| カテゴリ | category_id | integer | 必須 | - | 入力 | カテゴリを選択 |
| タグ | tags | array | - | - | 入力 | タグを複数選択 |
| メタタイトル | meta_title | string | - | 255 | 入力 | SEO用タイトル |
| メタキーワード | meta_keywords | string | - | 255 | 入力 | SEO用キーワード |
| メタ説明 | meta_description | text | - | - | 入力 | SEO用説明文 |

## 表示項目

編集画面のため、入力項目に既存データが初期表示されます。

## イベント仕様

### 1-保存ボタン押下

保存ボタン押下時、入力されたフォームデータをバリデーション後、以下の処理を実行します：
1. `last_editor_id`にログインユーザーIDを自動設定
2. `blogs_posts`テーブルの該当レコードをUPDATE
3. タグの関連を更新（`blogs_post_tags`テーブル）

処理成功時は成功通知を表示し、詳細画面（ViewPost）にリダイレクトします。

### 2-公開ボタン押下

公開ボタン押下時、以下の更新を実行します：
- `is_published`をtrueに設定
- `published_at`を現在日時に設定
- `last_editor_id`にログインユーザーIDを設定

処理成功時は公開成功通知を表示します。未公開（`is_published`がfalse）の場合のみボタンが表示されます。

### 3-下書きボタン押下

下書きボタン押下時、`is_published`をfalseに設定します。処理成功時は下書き保存成功通知を表示します。公開中（`is_published`がtrue）の場合のみボタンが表示されます。

### 4-削除ボタン押下

削除ボタン押下時、確認ダイアログを表示後、該当投稿をソフトデリートします。

### 5-キャンセルボタン押下

キャンセルボタン押下時、変更内容を破棄し遷移元画面に戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | blogs_posts | UPDATE | 投稿レコードを更新 |
| 保存ボタン押下 | blogs_post_tags | DELETE/INSERT | タグ関連を再設定 |
| 公開ボタン押下 | blogs_posts | UPDATE | 公開状態を更新 |
| 下書きボタン押下 | blogs_posts | UPDATE | 非公開に変更 |
| 削除ボタン押下 | blogs_posts | UPDATE | deleted_atを設定（ソフトデリート） |

### テーブル別更新項目詳細

#### blogs_posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（保存） | title | フォーム入力値 | タイトル |
| UPDATE（保存） | sub_title | フォーム入力値 | サブタイトル |
| UPDATE（保存） | content | フォーム入力値 | 本文 |
| UPDATE（保存） | image | アップロードファイルパス | バナー画像 |
| UPDATE（保存） | category_id | フォーム入力値 | カテゴリID |
| UPDATE（保存） | meta_title | フォーム入力値 | メタタイトル |
| UPDATE（保存） | meta_keywords | フォーム入力値 | メタキーワード |
| UPDATE（保存） | meta_description | フォーム入力値 | メタ説明 |
| UPDATE（保存） | last_editor_id | ログインユーザーID | 最終編集者ID |
| UPDATE（保存） | updated_at | 現在日時 | 更新日時 |
| UPDATE（公開） | is_published | true | 公開状態 |
| UPDATE（公開） | published_at | 現在日時 | 公開日時 |
| UPDATE（公開） | last_editor_id | ログインユーザーID | 最終編集者ID |
| UPDATE（下書き） | is_published | false | 公開状態 |
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 投稿が正常に更新されました | 保存処理成功時 |
| MSG-002 | 成功 | 投稿を公開しました | 公開処理成功時 |
| MSG-003 | 成功 | 投稿を下書きに変更しました | 下書き処理成功時 |
| MSG-004 | 成功 | 投稿が正常に削除されました | 削除処理成功時 |
| MSG-005 | エラー | タイトルは必須です | タイトル未入力時 |
| MSG-006 | エラー | 本文は必須です | 本文未入力時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| バリデーションエラー | 必須項目未入力 | エラーメッセージを表示し、フォームを再表示 |
| レコード未存在 | 対象レコードが存在しない | 404エラー画面を表示 |

## 備考

- 投稿編集はFilament ResourceのEditRecordページを継承して実装されています
- 最終編集者ID（last_editor_id）は`mutateFormDataBeforeSave`で自動設定されます
- サブナビゲーション（SubNavigationPosition::Top）により、View/Edit間の遷移が容易です
- 公開/下書きボタンは`is_published`の状態に応じて表示/非表示が切り替わります（`visible`メソッド）
- スラッグは編集時にも読み取り専用です（一度設定されたURLは変更不可）
