# 画面設計書 57-投稿詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおけるブログ投稿詳細画面（管理者用）の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：投稿詳細画面は、登録済みのブログ記事の内容を詳細に確認するための読み取り専用画面です。記事のプレビュー、メタ情報の確認、公開状態のチェックなど、コンテンツ管理の確認作業に使用します。編集画面への遷移や削除操作の起点としても機能します。

**画面へのアクセス方法**：投稿一覧画面から対象レコードの表示アクション、または新規作成・編集完了後のリダイレクト先として本画面に遷移します。URLパターンは `/admin/website/posts/{record}` となります。

**主要な操作・処理内容**：
1. 投稿情報の詳細表示（タイトル、本文、画像、SEO情報）
2. レコード情報の確認（著者、作成者、公開日時、作成日時、更新日時）
3. カテゴリ・タグの確認
4. 削除ボタンによるレコード削除

**画面遷移**：投稿一覧画面、作成画面、編集画面から遷移します。サブナビゲーションから編集画面に遷移可能です。削除時は一覧画面に遷移します。

**権限による表示制御**：ブログモジュールへのアクセス権限を持つ管理者ユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-BLOG-004 | ブログ投稿表示 | 主機能 | ブログ投稿詳細の表示 |

## 画面種別

詳細画面

## URL/ルーティング

- パス: `/admin/website/posts/{record}`
- ルート定義: `PostResource::route('/{record}')`

## 画面構成

- サブナビゲーション（Top位置）
  - 詳細タブ（ViewPost）※現在地
  - 編集タブ（EditPost）
- ヘッダーアクション
  - 削除ボタン（DeleteAction）
- メインコンテンツエリア（2カラム幅）
  - 一般情報セクション
    - タイトル表示
    - 本文表示（マークダウン形式）
    - バナー画像表示
  - SEOセクション
    - メタタイトル表示
    - メタキーワード表示
    - メタ説明表示
- サイドバーエリア（1カラム幅）
  - レコード情報セクション
    - 著者表示
    - 作成者表示
    - 公開日時表示
    - 作成日時表示
    - 更新日時表示
  - 設定セクション
    - 公開状態表示（アイコン）
    - カテゴリ表示（バッジ）
    - タグ表示（バッジ）

## 入出力項目

本画面は読み取り専用のため、入力項目はありません。

## 表示項目

| 項目名 | 項目ID | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| タイトル | title | string | - | 投稿タイトル（大きいフォント、太字） |
| 本文 | content | text | - | 投稿本文（マークダウン形式） |
| バナー画像 | image | file | - | アイキャッチ画像 |
| メタタイトル | meta_title | string | heroicon-o-document-text | SEO用タイトル |
| メタキーワード | meta_keywords | string | heroicon-o-hashtag | SEO用キーワード |
| メタ説明 | meta_description | text | - | SEO用説明文（マークダウン形式） |
| 著者 | author.name | string | heroicon-m-user | 投稿者名 |
| 作成者 | creator.name | string | heroicon-m-user | 作成者名 |
| 公開日時 | published_at | datetime | heroicon-m-calendar-days | 公開日時 |
| 作成日時 | created_at | datetime | heroicon-m-calendar | 作成日時 |
| 更新日時 | updated_at | datetime | heroicon-m-calendar-days | 最終更新日時 |
| 公開状態 | is_published | boolean | - | 公開/非公開（アイコン表示） |
| カテゴリ | category.name | string | heroicon-o-rectangle-stack | カテゴリ名（バッジ、warning色） |
| タグ | tags.name | array | heroicon-o-tag | タグ名一覧（バッジ） |

## イベント仕様

### 1-削除ボタン押下

削除ボタン押下時、確認ダイアログを表示後、該当投稿をソフトデリートします。処理成功時は成功通知を表示し、一覧画面に遷移します。

### 2-編集タブクリック

サブナビゲーションの編集タブクリック時、該当投稿の編集画面（EditPost）に遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | blogs_posts | SELECT | 投稿レコードを取得 |
| 削除ボタン押下 | blogs_posts | UPDATE | deleted_atを設定（ソフトデリート） |

### テーブル別更新項目詳細

#### blogs_posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | WHERE id = {record} | レコード取得 |
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | 投稿が正常に削除されました | 削除処理成功時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| レコード未存在 | 対象レコードが存在しない | 404エラー画面を表示 |

## 備考

- 投稿詳細はFilament ResourceのViewRecordページを継承して実装されています
- `infolist`メソッドで定義されたInfolist形式で表示されます
- 3カラムレイアウト（メインコンテンツ2カラム、サイドバー1カラム）
- サブナビゲーション（SubNavigationPosition::Top）により、View/Edit間の遷移が容易です
- タイトルはLargeサイズ、Bold weightで表示されます
- 本文とメタ説明はmarkdown形式でレンダリングされます
- 空値はプレースホルダー「-」が表示されます
- カテゴリはwarning色のバッジで表示されます
