# 画面設計書 58-タグ管理

## 概要

本ドキュメントは、Aureus ERPシステムにおけるブログタグ管理画面の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：タグ管理画面は、ブログモジュールにおいて記事に付与するタグを一元管理するための画面です。タグはブログ記事のカテゴリ横断的な分類や検索キーワードとして機能し、読者がコンテンツを見つけやすくするために重要です。タグに色を設定することで視覚的な識別も可能です。単一画面でのCRUD操作（作成・読取・更新・削除）が可能なManageRecordsパターンを採用しています。

**画面へのアクセス方法**：管理画面のナビゲーションメニューから「設定」クラスターを開き、「ブログ」グループ内の「タグ」をクリックすることで本画面に遷移します。URLパターンは `/admin/configurations/blogs/tags` となります。

**主要な操作・処理内容**：
1. タグ一覧の表示・検索・ソート
2. 新規タグの作成（モーダルダイアログ）
3. 既存タグの編集（インラインまたはモーダル）
4. タグの削除（ソフトデリート）
5. タグの復元（ソフトデリート済み）
6. タグの完全削除
7. 一括削除・一括復元・一括完全削除
8. タブ切替（すべて/アーカイブ）

**画面遷移**：設定メニューから遷移します。単一ページ内ですべての操作が完結します。

**権限による表示制御**：ブログモジュールへのアクセス権限を持つ管理者ユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-BLOG-006 | ブログタグ管理 | 主機能 | ブログタグの作成・編集・削除 |

## 画面種別

管理画面（ManageRecords）

## URL/ルーティング

- パス: `/admin/configurations/blogs/tags`
- ルート定義: `TagResource::route('/')`

## 画面構成

- ヘッダーアクション
  - 新規作成ボタン（CreateAction）
- タブ
  - すべて（件数バッジ表示）
  - アーカイブ（件数バッジ表示）
- テーブル
  - タグ名カラム
  - 色カラム（カラー表示）
  - 行アクション
  - 一括アクション

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|----------|------|--------|-----------|------|
| タグ名 | name | string | 必須 | 255 | 入力 | タグの名称（一意） |
| 色 | color | string | - | - | 入力 | タグの表示色（16進数カラーコード） |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 検索 | 説明 |
|--------|--------|----------|--------|------|------|
| タグ名 | name | string | 可 | 可 | タグの名称 |
| 色 | color | color | - | - | タグの表示色（カラーコラム） |

## イベント仕様

### 1-新規作成ボタン押下

新規作成ボタン押下時、モーダルダイアログを表示します。タグ名と色を入力し、保存すると`blogs_tags`テーブルにINSERT処理を実行します。`creator_id`は自動的にログインユーザーIDが設定されます。

### 2-編集アクション押下

編集アクション押下時（削除済み以外）、モーダルダイアログを表示します。タグ情報を編集し、保存すると該当レコードをUPDATE処理します。

### 3-削除アクション押下

削除アクション押下時、確認ダイアログを表示後、該当タグをソフトデリートします。

### 4-復元アクション押下

復元アクション押下時（削除済みのみ）、ソフトデリート済みのタグを復元します。

### 5-完全削除アクション押下

完全削除アクション押下時（削除済みのみ）、確認ダイアログを表示後、該当タグを完全に削除します。

### 6-一括削除押下

選択した複数タグを一括でソフトデリートします。

### 7-一括復元押下

選択した複数のソフトデリート済みタグを一括で復元します。

### 8-一括完全削除押下

選択した複数タグを一括で完全削除します。

### 9-タブ切替

「すべて」タブ：すべての有効なタグを表示
「アーカイブ」タブ：ソフトデリート済みのタグのみを表示（onlyTrashed）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | blogs_tags | INSERT | 新規タグレコードを作成 |
| 編集 | blogs_tags | UPDATE | タグレコードを更新 |
| 削除 | blogs_tags | UPDATE | deleted_atを設定（ソフトデリート） |
| 復元 | blogs_tags | UPDATE | deleted_atをnullに設定 |
| 完全削除 | blogs_tags | DELETE | レコードを完全削除 |

### テーブル別更新項目詳細

#### blogs_tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | タグ名（必須、一意） |
| INSERT | color | フォーム入力値 | 色（16進数） |
| INSERT | creator_id | ログインユーザーID | 作成者ID（自動設定） |
| INSERT | sort | 自動採番 | ソート順（SortableTrait） |
| INSERT | created_at | 現在日時 | 作成日時 |
| INSERT | updated_at | 現在日時 | 更新日時 |
| UPDATE | name | フォーム入力値 | タグ名 |
| UPDATE | color | フォーム入力値 | 色 |
| UPDATE | updated_at | 現在日時 | 更新日時 |
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |
| UPDATE（復元） | deleted_at | null | 復元 |
| DELETE | - | WHERE id = {record} | 完全削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | タグが正常に作成されました | 作成処理成功時 |
| MSG-002 | 成功 | タグが正常に更新されました | 編集処理成功時 |
| MSG-003 | 成功 | タグが正常に削除されました | 削除処理成功時 |
| MSG-004 | 成功 | タグが正常に復元されました | 復元処理成功時 |
| MSG-005 | 成功 | タグが完全に削除されました | 完全削除処理成功時 |
| MSG-006 | エラー | タグ名は必須です | タグ名未入力時 |
| MSG-007 | エラー | このタグ名は既に使用されています | タグ名重複時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| バリデーションエラー | 必須項目未入力 | エラーメッセージを表示 |
| ユニーク制約違反 | タグ名重複 | エラーメッセージを表示 |
| 権限エラー | アクセス権限なし | 403エラー画面を表示 |

## 備考

- タグ管理はFilament ResourceのManageRecordsページを継承して実装されています
- 単一画面でCRUD操作が完結する管理画面パターンです
- タブ機能で「すべて」と「アーカイブ」を切り替えることができます
- 各タブには該当レコード数がバッジ表示されます
- ソフトデリートをサポート（SoftDeletesトレイト使用）
- ソート順は`Spatie\EloquentSortable`パッケージにより自動管理されます
- 作成者IDは自動的にログインユーザーが設定されます（mutateDataUsing）
- 色はColorPicker（hexColor）で入力し、ColorColumnで表示されます
- Configurationsクラスターに属しています
