# 画面設計書 59-カテゴリ管理

## 概要

本ドキュメントは、Aureus ERPシステムにおけるブログカテゴリ管理画面の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：カテゴリ管理画面は、ブログモジュールにおいて記事を分類するためのカテゴリを一元管理する画面です。カテゴリはブログ記事の主要な分類軸として機能し、読者がコンテンツをトピック別に閲覧できるようにします。カテゴリ名とサブタイトル、URLスラッグを設定でき、SEOにも寄与します。単一画面でのCRUD操作（作成・読取・更新・削除）が可能なManageRecordsパターンを採用しています。

**画面へのアクセス方法**：管理画面のナビゲーションメニューから「設定」クラスターを開き、「ブログ」グループ内の「カテゴリ」をクリックすることで本画面に遷移します。URLパターンは `/admin/configurations/blogs/categories` となります。

**主要な操作・処理内容**：
1. カテゴリ一覧の表示・検索・ソート
2. 新規カテゴリの作成（モーダルダイアログ）
3. 既存カテゴリの編集（インラインまたはモーダル）
4. カテゴリの削除（ソフトデリート）
5. カテゴリの復元（ソフトデリート済み）
6. カテゴリの完全削除
7. 一括削除・一括復元・一括完全削除
8. タブ切替（すべて/アーカイブ）

**画面遷移**：設定メニューから遷移します。単一ページ内ですべての操作が完結します。

**権限による表示制御**：ブログモジュールへのアクセス権限を持つ管理者ユーザーのみがこの画面にアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-BLOG-005 | ブログカテゴリ管理 | 主機能 | ブログカテゴリの作成・編集・削除 |

## 画面種別

管理画面（ManageRecords）

## URL/ルーティング

- パス: `/admin/configurations/blogs/categories`
- ルート定義: `CategoryResource::route('/')`

## 画面構成

- ヘッダーアクション
  - 新規作成ボタン（CreateAction）
- タブ
  - すべて（件数バッジ表示）
  - アーカイブ（件数バッジ表示）
- テーブル
  - カテゴリ名カラム
  - 作成日時カラム
  - 行アクション
  - 一括アクション

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力/出力 | 説明 |
|--------|--------|----------|------|--------|-----------|------|
| カテゴリ名 | name | string | 必須 | 255 | 入力 | カテゴリの名称 |
| スラッグ | slug | string | 必須 | 255 | 出力 | URLスラッグ（自動生成） |
| サブタイトル | sub_title | string | - | 255 | 入力 | カテゴリのサブタイトル |

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 検索 | 説明 |
|--------|--------|----------|--------|------|------|
| カテゴリ名 | name | string | 可 | 可 | カテゴリの名称 |
| 作成日時 | created_at | datetime | 可 | - | 作成日時 |

## イベント仕様

### 1-新規作成ボタン押下

新規作成ボタン押下時、モーダルダイアログを表示します。カテゴリ名（入力時にスラッグを自動生成）とサブタイトルを入力し、保存すると`blogs_categories`テーブルにINSERT処理を実行します。`creator_id`は自動的にログインユーザーIDが設定されます。作成後は画面をリフレッシュします。

### 2-カテゴリ名入力時

カテゴリ名入力時（フォーカスアウト時）、入力された名前からスラッグを自動生成し、スラッグフィールドに設定します。スラッグはStr::slug()関数で生成されます。

### 3-編集アクション押下

編集アクション押下時（削除済み以外）、モーダルダイアログを表示します。カテゴリ情報を編集し、保存すると該当レコードをUPDATE処理します。

### 4-削除アクション押下

削除アクション押下時、確認ダイアログを表示後、該当カテゴリをソフトデリートします。

### 5-復元アクション押下

復元アクション押下時（削除済みのみ）、ソフトデリート済みのカテゴリを復元します。

### 6-完全削除アクション押下

完全削除アクション押下時（削除済みのみ）、確認ダイアログを表示後、該当カテゴリを完全に削除します。関連する投稿が存在する場合はエラーとなります。

### 7-一括削除押下

選択した複数カテゴリを一括でソフトデリートします。

### 8-一括復元押下

選択した複数のソフトデリート済みカテゴリを一括で復元します。

### 9-一括完全削除押下

選択した複数カテゴリを一括で完全削除します。関連する投稿が存在する場合はエラーとなります。

### 10-タブ切替

「すべて」タブ：すべての有効なカテゴリを表示
「アーカイブ」タブ：ソフトデリート済みのカテゴリのみを表示（onlyTrashed）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | blogs_categories | INSERT | 新規カテゴリレコードを作成 |
| 編集 | blogs_categories | UPDATE | カテゴリレコードを更新 |
| 削除 | blogs_categories | UPDATE | deleted_atを設定（ソフトデリート） |
| 復元 | blogs_categories | UPDATE | deleted_atをnullに設定 |
| 完全削除 | blogs_categories | DELETE | レコードを完全削除 |

### テーブル別更新項目詳細

#### blogs_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | カテゴリ名（必須） |
| INSERT | slug | 自動生成（名前から） | URLスラッグ（一意） |
| INSERT | sub_title | フォーム入力値 | サブタイトル |
| INSERT | creator_id | ログインユーザーID | 作成者ID（自動設定） |
| INSERT | created_at | 現在日時 | 作成日時 |
| INSERT | updated_at | 現在日時 | 更新日時 |
| UPDATE | name | フォーム入力値 | カテゴリ名 |
| UPDATE | sub_title | フォーム入力値 | サブタイトル |
| UPDATE | updated_at | 現在日時 | 更新日時 |
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |
| UPDATE（復元） | deleted_at | null | 復元 |
| DELETE | - | WHERE id = {record} | 完全削除 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|---------------|---------------|----------|
| MSG-001 | 成功 | カテゴリが正常に作成されました | 作成処理成功時 |
| MSG-002 | 成功 | カテゴリが正常に更新されました | 編集処理成功時 |
| MSG-003 | 成功 | カテゴリが正常に削除されました | 削除処理成功時 |
| MSG-004 | 成功 | カテゴリが正常に復元されました | 復元処理成功時 |
| MSG-005 | 成功 | カテゴリが完全に削除されました | 完全削除処理成功時 |
| MSG-006 | エラー | カテゴリ名は必須です | カテゴリ名未入力時 |
| MSG-007 | エラー | このスラッグは既に使用されています | スラッグ重複時 |
| MSG-008 | エラー | このカテゴリは使用中のため削除できません | 外部キー制約違反時 |

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| バリデーションエラー | 必須項目未入力 | エラーメッセージを表示 |
| ユニーク制約違反 | スラッグ重複 | エラーメッセージを表示 |
| QueryException | 外部キー制約違反 | エラー通知を表示し、削除処理を中止 |

## 備考

- カテゴリ管理はFilament ResourceのManageRecordsページを継承して実装されています
- 単一画面でCRUD操作が完結する管理画面パターンです
- タブ機能で「すべて」と「アーカイブ」を切り替えることができます
- 各タブには該当レコード数がバッジ表示されます
- ソフトデリートをサポート（SoftDeletesトレイト使用）
- 作成者IDは自動的にログインユーザーが設定されます（mutateDataUsing）
- スラッグはカテゴリ名入力時に自動生成されます（afterStateUpdated）
- スラッグは一意制約があります
- 完全削除時は`try-catch`で`QueryException`をキャッチし、関連投稿存在時のエラーハンドリングを行っています
- Configurationsクラスターに属しています
