# 画面設計書 6-銀行口座一覧

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける銀行口座一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、企業が管理する銀行口座情報を一覧形式で管理するための画面です。銀行口座の登録、編集、削除、復元といった操作を提供し、パートナー（取引先）と銀行口座の紐付け管理を行います。

**業務上の目的・背景**：企業間取引において、正確な銀行口座情報の管理は支払処理や入金確認の基盤となります。本画面により、取引先の銀行口座情報を一元管理し、支払業務の効率化と正確性の向上を実現します。また、送金可否フラグにより、実際に送金可能な口座を明確に区別できます。

**画面へのアクセス方法**：会計モジュールの設定メニューから「銀行口座」を選択してアクセスします。

**主要な操作・処理内容**：
1. 銀行口座一覧の表示（口座番号、銀行名、口座名義人等）
2. グループ化・フィルタ機能による一覧の絞り込み
3. 新規銀行口座の作成（モーダル）
4. 既存銀行口座の編集（モーダル）
5. 銀行口座の削除（ソフトデリート）
6. 削除済み銀行口座の復元
7. 銀行口座の完全削除（強制削除）
8. 一括操作（一括削除、一括復元、一括強制削除）

**画面遷移**：
- 本画面から遷移可能：モーダルでの作成・編集（画面遷移なし）
- 本画面への遷移元：会計モジュール設定メニュー

**権限による表示制御**：会計モジュールへのアクセス権限を持つユーザーのみ表示可能です。編集・削除・強制削除操作は対応する権限を持つユーザーに限定されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-024 | 銀行口座管理 | 主機能 | 銀行口座の作成/編集/削除 |

## 画面種別

一覧（管理画面）

## URL/ルーティング

`/accounts/bank-accounts`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- フィルタエリア：送金可否、銀行、口座名義人、作成者のフィルタ
- テーブルエリア：銀行口座一覧テーブル（グループ化機能付き、列並び替え可能）
- 行アクション：編集、復元、削除、強制削除
- 一括操作エリア：一括復元、一括削除、一括強制削除

## 入出力項目

### 新規作成・編集モーダル

| No | 項目名 | 物理名 | 型 | 必須 | 初期値 | 説明 | 入力形式 |
|----|--------|--------|-----|------|--------|------|---------|
| 1 | 口座番号 | account_number | string | ○ | なし | 銀行口座番号 | テキスト入力（一意、最大255文字） |
| 2 | 銀行 | bank_id | integer | ○ | なし | 銀行 | セレクトボックス（検索可能、作成可能） |
| 3 | 口座名義人 | partner_id | integer | ○ | なし | 口座名義のパートナー | セレクトボックス（検索可能） |

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | 口座番号 | account_number | string | 銀行口座番号 | 検索・ソート可能 |
| 2 | 銀行 | bank.name | string | 銀行名 | 検索・ソート可能 |
| 3 | 口座名義人 | partner.name | string | 口座名義のパートナー名 | ソート可能 |
| 4 | 削除日時 | deleted_at | datetime | ソフトデリート日時 | デフォルト非表示 |
| 5 | 作成日時 | created_at | datetime | レコード作成日時 | デフォルト非表示 |
| 6 | 更新日時 | updated_at | datetime | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタンを押下すると、新規作成モーダルが表示されます。フォームに情報を入力し保存すると、新規銀行口座レコードが作成されます。

### 2-編集アクション

行の編集アクションを選択すると、該当レコードの編集モーダルが表示されます。削除済みレコードには表示されません。保存成功時は通知メッセージが表示されます。

### 3-削除アクション

行の削除アクションを選択すると、確認ダイアログ表示後、該当レコードをソフトデリートします。削除後も復元が可能です。

### 4-復元アクション

削除済みレコードの復元アクションを選択すると、該当レコードを復元します。復元成功時は通知メッセージが表示されます。

### 5-強制削除アクション

削除済みレコードの強制削除アクションを選択すると、確認ダイアログ表示後、該当レコードを完全に削除します。この操作は取り消しできません。

### 6-フィルタ操作

以下のフィルタが使用可能です：
- 銀行（bank_id）
- 口座名義人（partner_id）
- 作成者（creator_id）

### 7-グループ化

テーブルは以下の項目でグループ化が可能です：
- 銀行
- 作成日（日付単位）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | partners_bank_accounts | INSERT | 新規銀行口座レコードを作成 |
| 編集保存 | partners_bank_accounts | UPDATE | 銀行口座レコードを更新 |
| 削除アクション | partners_bank_accounts | UPDATE | deleted_atを設定（ソフトデリート） |
| 復元アクション | partners_bank_accounts | UPDATE | deleted_atをnullに設定 |
| 強制削除 | partners_bank_accounts | DELETE | レコードを完全削除 |

### テーブル別更新項目詳細

#### partners_bank_accounts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | account_number | フォーム入力値 | 必須、一意制約 |
| INSERT | bank_id | フォーム選択値 | 必須 |
| INSERT | partner_id | フォーム選択値 | 必須 |
| UPDATE | deleted_at | 現在日時 | ソフトデリート時 |
| UPDATE | deleted_at | null | 復元時 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 銀行口座が作成されました | 作成成功時 |
| MSG-002 | 成功 | 銀行口座が更新されました | 編集成功時 |
| MSG-003 | 成功 | 銀行口座が削除されました | 削除成功時 |
| MSG-004 | 成功 | 銀行口座が復元されました | 復元成功時 |
| MSG-005 | 成功 | 銀行口座が完全に削除されました | 強制削除成功時 |
| MSG-006 | 成功 | 銀行口座が一括削除されました | 一括削除成功時 |
| MSG-007 | 成功 | 銀行口座が一括復元されました | 一括復元成功時 |
| MSG-008 | 成功 | 銀行口座が一括で完全削除されました | 一括強制削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 口座番号重複 | フォームエラー表示 | この口座番号は既に登録されています |
| 必須項目未入力 | フォームエラー表示 | 必須項目を入力してください |
| データベースエラー | エラー通知表示 | データの保存に失敗しました |

## 備考

- 本画面はPartnerモジュールのBankAccountResourceを継承しています
- 会計モジュール用にcan_send_money列を非表示に設定しています
- ソフトデリート機能を実装しており、削除済みレコードも一覧に表示されます
- 銀行選択時に削除済みの銀行も選択肢に表示されますが、選択不可（(Deleted)表示）
- 新規銀行は銀行選択欄から直接作成可能です
- テーブル列の並び替え（ドラッグ&ドロップ）が可能です
- ナビゲーションへの表示は無効化されています（shouldRegisterNavigation = false）
