# 画面設計書 60-カテゴリ一覧（顧客）

## 概要

本ドキュメントは、Aureus ERPシステムにおけるブログカテゴリ一覧画面（顧客向け）の設計仕様を記載します。

### 本画面の処理概要

**業務上の目的・背景**：カテゴリ一覧画面（顧客向け）は、ブログモジュールにおいて一般ユーザー（顧客）がブログ記事を閲覧するためのエントリーポイントとなる画面です。公開されているブログ記事をカテゴリ別に分類して表示し、読者が興味のあるコンテンツを見つけやすくします。検索機能やページネーションを提供し、大量の記事があっても効率的にブラウジングできます。

**画面へのアクセス方法**：顧客向けポータルのナビゲーションから「ブログ」をクリック、または直接URLにアクセスすることで本画面に遷移します。URLパターンは `/blog` となります。

**主要な操作・処理内容**：
1. カテゴリ一覧の表示
2. 公開済み投稿一覧の表示（最新順、ページネーション）
3. 投稿の検索（タイトル・本文）
4. カテゴリによるフィルタリング（カテゴリ詳細画面へ遷移）
5. 投稿詳細画面への遷移

**画面遷移**：顧客向けナビゲーションから遷移します。カテゴリクリックでカテゴリ詳細画面に、投稿クリックで投稿詳細画面に遷移します。

**権限による表示制御**：認証不要で誰でもアクセス可能（shouldSkipAuthorization = true）。公開済み（is_published = 1）の投稿のみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-BLOG-008 | カテゴリ閲覧 | 主機能 | 顧客向けカテゴリの一覧表示 |
| FN-BLOG-007 | ブログ閲覧 | 補助機能 | 顧客向け投稿の一覧表示 |

## 画面種別

一覧画面（顧客向け、カスタムビュー）

## URL/ルーティング

- パス: `/blog`
- ルート定義: `CategoryResource::route('/')`
- recordRouteKeyName: `slug`

## 画面構成

本画面はカスタムBladeビュー（`blogs::filament.customer.resources.category.pages.list-records`）を使用しています。

- ヘッダーエリア
  - ページタイトル
  - 検索ボックス
- カテゴリナビゲーション
  - カテゴリ一覧（すべてのカテゴリ）
- 投稿一覧エリア
  - 投稿カード（タイトル、サブタイトル、著者、タグ、作成日、読了時間）
  - ページネーション（9件/ページ）

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 検索キーワード | search | string | - | タイトル・本文を検索 |

## 表示項目

### カテゴリ情報

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| カテゴリ名 | name | string | カテゴリの名称 |
| スラッグ | slug | string | URLパス用 |

### 投稿情報

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| タイトル | title | string | 投稿タイトル |
| サブタイトル | sub_title | string | サブタイトル |
| 本文（抜粋） | content | text | 投稿本文の抜粋 |
| バナー画像 | image | file | アイキャッチ画像 |
| カテゴリ | category.name | string | 所属カテゴリ |
| 著者 | creator.name | string | 投稿者名 |
| タグ | tags.name | array | タグ一覧 |
| 公開日時 | published_at | datetime | 公開日時 |
| 読了時間 | reading_time | string | 推定読了時間（自動計算） |

## イベント仕様

### 1-検索実行

検索ボックスにキーワードを入力して検索を実行すると、タイトルまたは本文にキーワードを含む投稿をフィルタリングして表示します。

### 2-カテゴリクリック

カテゴリ名をクリックすると、該当カテゴリの詳細画面（ViewCategory）に遷移します。

### 3-投稿クリック

投稿カードをクリックすると、該当投稿の詳細画面（ViewPost）に遷移します。

### 4-ページネーション操作

ページネーションリンクをクリックすると、該当ページの投稿一覧を表示します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | blogs_categories | SELECT | すべてのカテゴリを取得 |
| 画面表示 | blogs_posts | SELECT | 公開済み投稿を取得（ページネーション） |

### テーブル別更新項目詳細

#### blogs_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | Category::all() | すべてのカテゴリを取得 |

#### blogs_posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | WHERE is_published = 1 | 公開済みのみ |
| SELECT | - | WHERE title/content LIKE %search% | 検索キーワードでフィルタ |
| SELECT | - | ORDER BY published_at DESC | 公開日時降順 |
| SELECT | - | LIMIT 9 | 9件/ページ |

## メッセージ仕様

本画面は読み取り専用のため、メッセージ仕様はありません。

## 例外処理

| 例外種別 | 発生条件 | 処理内容 |
|----------|----------|----------|
| 該当データなし | 検索結果が0件 | 「該当する投稿がありません」を表示 |

## 備考

- 顧客向け画面のためFilament ResourceのListRecordsを継承しつつ、カスタムBladeビューを使用
- 認証不要でアクセス可能（`$shouldSkipAuthorization = true`）
- レコードのルートキーはスラッグ（`$recordRouteKeyName = 'slug'`）
- ページネーションは9件/ページ
- 投稿はカテゴリ、作成者、タグをリレーションでロード（`with(['category', 'creator', 'tags'])`）
- 公開済み投稿のみ表示（`where('is_published', 1)`）
- 検索はタイトルと本文の両方を対象（LIKE検索）
- 投稿は公開日時の降順で表示
- 読了時間はPostモデルの`getReadingTimeAttribute`アクセサで自動計算（200語/分）
- パンくずリストは非表示（`getBreadcrumbs`で空配列を返却）
