# 画面設計書 61-カテゴリ詳細（顧客）

## 概要

本ドキュメントは、Aureus ERPシステムのブログモジュールにおける顧客向けカテゴリ詳細画面の設計を記載します。

### 本画面の処理概要

この画面は、顧客（一般ユーザー）がブログカテゴリの詳細を閲覧し、そのカテゴリに属する投稿一覧を確認するための画面です。

**業務上の目的・背景**：
ブログシステムにおいて、カテゴリ別に記事を整理・閲覧できることは、情報の探しやすさを向上させ、ユーザーエクスペリエンスを改善するために重要です。顧客がカテゴリを選択することで、関連する記事のみを絞り込んで閲覧でき、効率的な情報収集が可能となります。

**画面へのアクセス方法**：
1. 顧客向けブログ一覧画面（/blog）にアクセス
2. カテゴリ一覧からカテゴリを選択
3. カテゴリ詳細画面（/blog/{category-slug}）に遷移

**主要な操作・処理内容**：
1. カテゴリ情報（名前、サブタイトル、画像）の表示
2. カテゴリに属する公開済み投稿の一覧表示（ページネーション付き、9件/ページ）
3. 投稿のタイトル・内容での検索機能
4. 各投稿への詳細画面への遷移リンク

**画面遷移**：
- 遷移元: カテゴリ一覧画面（ListCategories）
- 遷移先: 投稿詳細画面（ViewPost）- カテゴリ配下の投稿を選択

**権限による表示制御**：
- 認可はスキップされており（shouldSkipAuthorization = true）、全ユーザーがアクセス可能
- 公開済み（is_published = 1）の投稿のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-BLOG-008 | カテゴリ閲覧 | 主機能 | カテゴリ詳細情報の表示 |
| FN-BLOG-007 | ブログ閲覧 | 遷移先機能 | カテゴリ配下の投稿一覧表示 |

## 画面種別

詳細 / 一覧（カテゴリ詳細 + 投稿一覧のハイブリッド）

## URL/ルーティング

- URL: `/blog/{record}`
- パラメータ: `record` - カテゴリのスラッグ（slug）
- ルートキー: `slug`（recordRouteKeyName）

## 画面構成

1. **カテゴリ情報セクション**
   - カテゴリ名
   - サブタイトル
   - カテゴリ画像

2. **検索フォーム**
   - テキスト検索入力欄

3. **投稿一覧セクション**
   - 投稿カード（9件/ページ）
     - 投稿画像
     - タイトル
     - サブタイトル
     - 著者名
     - 公開日
     - 読了時間
     - タグ
   - ページネーション

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| search | 入力 | string | No | 投稿検索キーワード（タイトル・内容を検索） |

## 表示項目

### カテゴリ情報

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| カテゴリ名 | blogs_categories.name | テキスト | カテゴリの名称 |
| サブタイトル | blogs_categories.sub_title | テキスト | カテゴリのサブタイトル |
| 画像 | blogs_categories.image | 画像 | カテゴリのイメージ画像 |

### 投稿一覧

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| タイトル | blogs_posts.title | テキスト | 投稿のタイトル |
| サブタイトル | blogs_posts.sub_title | テキスト | 投稿のサブタイトル |
| コンテンツ | blogs_posts.content | HTML | 投稿の本文 |
| 画像 | blogs_posts.image | 画像 | 投稿のサムネイル画像 |
| 著者名 | blogs_posts.author_name | テキスト | 記事の著者 |
| 公開日 | blogs_posts.published_at | 日時 | 公開日時 |
| 読了時間 | 算出値 | テキスト | コンテンツ文字数から算出（200語/分） |
| タグ | blogs_post_tags + blogs_tags | バッジ | 投稿に付与されたタグ |

## イベント仕様

### 1-検索実行

**トリガー**: 検索フォームへの入力・送信

**処理内容**:
1. 入力されたキーワードをリクエストパラメータ（search）として受け取る
2. 投稿のtitleカラムまたはcontentカラムに対してLIKE検索を実行
3. 検索結果を一覧に反映

**データ取得クエリ**:
```sql
SELECT * FROM blogs_posts
WHERE category_id = {current_category_id}
  AND is_published = 1
  AND (title LIKE '%{search}%' OR content LIKE '%{search}%')
ORDER BY published_at DESC
LIMIT 9 OFFSET {page * 9}
```

### 2-投稿選択

**トリガー**: 投稿カードのクリック

**処理内容**:
1. 選択した投稿のスラッグを取得
2. 投稿詳細画面（ViewPost）へ遷移

**遷移先URL**: `/blog/{category-slug}/{post-slug}`

### 3-ページネーション

**トリガー**: ページネーションリンクのクリック

**処理内容**:
1. 指定されたページ番号に基づいて投稿一覧を再取得
2. 1ページあたり9件の投稿を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| カテゴリ表示 | blogs_categories | SELECT | カテゴリ情報の取得 |
| 投稿一覧表示 | blogs_posts | SELECT | カテゴリに属する公開済み投稿の取得 |
| 投稿一覧表示 | blogs_tags | SELECT | 投稿に紐づくタグ情報の取得 |

### テーブル別更新項目詳細

#### blogs_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id, name, sub_title, image, slug | WHERE slug = {record} | スラッグでカテゴリを特定 |

#### blogs_posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE category_id = {id} AND is_published = 1 | 公開済み投稿のみ |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| 情報 | 投稿が0件の場合 | 「このカテゴリには投稿がありません」 |
| 情報 | 検索結果が0件の場合 | 「該当する投稿が見つかりませんでした」 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| カテゴリが存在しない | 404エラーページを表示 |
| カテゴリが削除済み（ソフトデリート） | 404エラーページを表示 |

## 備考

- ビューテンプレートは `blogs::filament.customer.resources.category.pages.view-record` を使用
- パンくずリストは空配列を返しており、表示されない設定
- 投稿一覧は公開日（published_at）の降順でソート
- 読了時間は内部的に計算される属性（getReadingTimeAttribute）で、200語/分を基準に算出
