# 画面設計書 62-投稿詳細（顧客）

## 概要

本ドキュメントは、Aureus ERPシステムのブログモジュールにおける顧客向け投稿詳細画面の設計を記載します。

### 本画面の処理概要

この画面は、顧客（一般ユーザー）がブログ投稿の詳細内容を閲覧するための画面です。カテゴリ詳細画面から特定の投稿を選択した際に表示されます。

**業務上の目的・背景**：
ブログシステムにおいて、個々の記事の全文を読みやすく表示することは、コンテンツマーケティングや情報発信の根幹となる機能です。顧客は記事の詳細情報、著者情報、関連タグなどを確認でき、企業やサービスに対する理解を深めることができます。

**画面へのアクセス方法**：
1. 顧客向けブログ一覧画面（/blog）にアクセス
2. カテゴリを選択してカテゴリ詳細画面へ遷移
3. 投稿一覧から閲覧したい投稿を選択
4. 投稿詳細画面（/blog/{category-slug}/{post-slug}）に遷移

**主要な操作・処理内容**：
1. 投稿のタイトル・サブタイトルの表示
2. 投稿本文（リッチテキストコンテンツ）の表示
3. 著者情報（著者名）の表示
4. 公開日時の表示
5. 関連タグの表示
6. 読了時間の表示

**画面遷移**：
- 遷移元: カテゴリ詳細画面（ViewCategory）
- 遷移先: なし（詳細表示のみ）

**権限による表示制御**：
- 認可はスキップされており（shouldSkipAuthorization = true）、全ユーザーがアクセス可能
- グローバル検索では公開済み（is_published = true）の投稿のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-BLOG-007 | ブログ閲覧 | 主機能 | 投稿詳細情報の表示 |
| FN-BLOG-008 | カテゴリ閲覧 | 遷移元機能 | カテゴリ詳細から投稿詳細への遷移 |

## 画面種別

詳細

## URL/ルーティング

- URL: `/blog/{category}/{record}`
- パラメータ:
  - `category` - カテゴリのスラッグ（親リソース）
  - `record` - 投稿のスラッグ
- ルートキー: `slug`（recordRouteKeyName）
- 親リソース: CategoryResource

## 画面構成

1. **ヘッダーセクション**
   - 投稿タイトル
   - サブタイトル
   - 投稿画像（メインビジュアル）

2. **メタ情報セクション**
   - 著者名
   - 公開日時
   - 読了時間
   - カテゴリ名

3. **コンテンツセクション**
   - 投稿本文（HTMLリッチテキスト）

4. **タグセクション**
   - 関連タグ一覧

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| なし | - | - | - | 閲覧専用画面のため入力項目なし |

## 表示項目

### 投稿詳細情報

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| タイトル | blogs_posts.title | テキスト（ページタイトル） | 投稿のタイトル（getTitle()で取得） |
| サブタイトル | blogs_posts.sub_title | テキスト | 投稿のサブタイトル |
| コンテンツ | blogs_posts.content | HTML | 投稿の本文 |
| 画像 | blogs_posts.image | 画像 | 投稿のメインビジュアル |
| 著者名 | blogs_posts.author_name | テキスト | 記事の著者 |
| 公開日 | blogs_posts.published_at | 日時 | 公開日時 |
| 読了時間 | 算出値（reading_time） | テキスト | コンテンツ文字数から算出 |
| 訪問数 | blogs_posts.visits | 数値 | 閲覧回数 |
| カテゴリ名 | blogs_categories.name | テキスト | 所属カテゴリ |
| タグ | blogs_post_tags + blogs_tags | バッジ | 投稿に付与されたタグ |

## イベント仕様

### 1-ページ表示

**トリガー**: URLアクセス

**処理内容**:
1. カテゴリスラッグから親リソースを特定
2. 投稿スラッグから対象投稿を取得
3. 関連データ（カテゴリ、タグ）をEager Loading
4. ページタイトルに投稿タイトルを設定

**データ取得**:
- 投稿レコードを取得し、カテゴリとの関連を検証
- グローバル検索対応のため、is_published = true の条件が適用される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 投稿表示 | blogs_posts | SELECT | 投稿情報の取得 |
| 投稿表示 | blogs_categories | SELECT | 関連カテゴリ情報の取得 |
| 投稿表示 | blogs_tags | SELECT | 関連タグ情報の取得 |

### テーブル別更新項目詳細

#### blogs_posts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE slug = {record} | スラッグで投稿を特定 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| なし | - | 閲覧専用画面のためメッセージなし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 投稿が存在しない | 404エラーページを表示 |
| 投稿が削除済み（ソフトデリート） | 404エラーページを表示 |
| カテゴリと投稿の不整合 | 404エラーページを表示 |

## 備考

- ビューテンプレートは `blogs::filament.customer.resources.post.pages.view-record` を使用
- パンくずリストは空配列を返しており、表示されない設定
- 親リソースとしてCategoryResourceが設定されている
- ナビゲーションには表示されない（shouldRegisterNavigation = false）
- グローバル検索に対応しており、タイトルとカテゴリ名で検索可能
- グローバル検索結果からのURL生成は `CategoryResource::getUrl('posts.view', ...)` を使用
- 読了時間は内部的に計算される属性で、200語/分を基準に算出
