# 画面設計書 63-パートナー一覧

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおけるパートナー一覧画面の設計を記載します。

### 本画面の処理概要

この画面は、システムに登録されているパートナー（連絡先）の一覧を表示し、検索・フィルタリング・グループ化・新規作成・編集・削除などの操作を行うための画面です。

**業務上の目的・背景**：
ERPシステムにおいて、取引先や顧客、サプライヤーなどのパートナー情報を一元管理することは、営業活動、購買管理、請求処理など多くの業務プロセスの基盤となります。パートナー一覧画面は、これらの情報に素早くアクセスし、効率的に管理するための中核的な機能を提供します。個人と法人を区別し、アーカイブ済みデータも管理できる柔軟な設計となっています。

**画面へのアクセス方法**：
1. サイドメニューから「連絡先」モジュールを選択
2. パートナー一覧画面が表示

**主要な操作・処理内容**：
1. パートナー一覧のカード形式表示（レスポンシブグリッド）
2. パートナーの新規作成（作成ボタン）
3. パートナーの詳細表示・編集・削除（レコードアクション）
4. 高度なフィルタリング（QueryBuilder）
5. グループ化（アカウントタイプ、親会社、役職など）
6. プリセットビュー（個人、法人、アーカイブ済み）
7. 一括操作（復元、削除、完全削除）

**画面遷移**：
- 遷移先: パートナー作成画面（CreatePartner）
- 遷移先: パートナー詳細画面（ViewPartner）
- 遷移先: パートナー編集画面（EditPartner）

**権限による表示制御**：
- 削除済みレコードは「表示」「編集」アクションが非表示
- 削除済みレコードには「復元」「完全削除」アクションが表示
- 一括操作も同様の権限制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-001 | 連絡先一覧 | 主機能 | パートナー一覧の表示・検索・フィルタリング |
| FN-CONT-002 | 連絡先作成 | 遷移先機能 | 新規パートナーの作成 |
| FN-CONT-003 | 連絡先編集 | 遷移先機能 | パートナー情報の編集 |
| FN-CONT-004 | 連絡先表示 | 遷移先機能 | パートナー詳細の表示 |

## 画面種別

一覧（カードグリッド形式）

## URL/ルーティング

- URL: `/contacts/partners`
- Filament Resource: `PartnerResource`

## 画面構成

1. **ヘッダー**
   - 画面タイトル
   - 作成ボタン（+アイコン付き）

2. **プリセットビュータブ**
   - 個人（Individuals）- お気に入り
   - 法人（Companies）- お気に入り
   - アーカイブ済み（Archived）- お気に入り

3. **テーブルビュー管理**
   - ビューの保存・切り替え機能

4. **フィルターボタン**
   - QueryBuilderによる高度なフィルタリング（スライドオーバー形式）

5. **パートナーカードグリッド**
   - レスポンシブ表示（sm:1列, md:2列, xl:3列, 2xl:4列）
   - 各カードにパートナー情報を表示

6. **ページネーション**
   - 16, 32, 64件、または全件表示

## 入出力項目

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| フィルター条件 | 入力 | 複合 | No | QueryBuilderによる各種フィルター条件 |
| グループ | 入力 | string | No | グループ化の基準 |

## 表示項目

### パートナーカード

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| アバター画像 | partners_partners.avatar | 画像（200x250px） | パートナーのプロフィール画像 |
| 名前 | partners_partners.name | テキスト（太字） | パートナー名 |
| 親会社 | parent.name | テキスト（アイコン付き） | 所属会社名（個人の場合） |
| 役職 | partners_partners.job_title | テキスト（ブリーフケースアイコン） | 職位・役職名 |
| メール | partners_partners.email | テキスト（封筒アイコン、最大20文字） | メールアドレス |
| 電話 | partners_partners.phone | テキスト（電話アイコン、最大30文字） | 電話番号 |
| タグ | partners_tags | バッジ（カラー付き） | 付与されたタグ一覧 |

## イベント仕様

### 1-作成ボタン押下

**トリガー**: ヘッダーの「作成」ボタンクリック

**処理内容**:
1. パートナー作成画面（CreatePartner）へ遷移

### 2-レコード表示

**トリガー**: カードの「表示」アクションクリック

**処理内容**:
1. 選択したパートナーの詳細画面（ViewPartner）へ遷移

**表示条件**: レコードが削除済み（trashed）でない場合のみ表示

### 3-レコード編集

**トリガー**: カードの「編集」アクションクリック

**処理内容**:
1. 選択したパートナーの編集画面（EditPartner）へ遷移

**成功時通知**: 「パートナーが更新されました」

**表示条件**: レコードが削除済み（trashed）でない場合のみ表示

### 4-レコード削除

**トリガー**: カードの「削除」アクションクリック

**処理内容**:
1. 確認ダイアログを表示
2. ソフトデリートを実行

**成功時通知**: 「パートナーが削除されました」

### 5-レコード復元

**トリガー**: 削除済みカードの「復元」アクションクリック

**処理内容**:
1. ソフトデリートを解除（restore）

**成功時通知**: 「パートナーが復元されました」

### 6-レコード完全削除

**トリガー**: 削除済みカードの「完全削除」アクションクリック

**処理内容**:
1. 確認ダイアログを表示
2. 物理削除を実行

**成功時通知**: 「パートナーが完全に削除されました」
**エラー時通知**: 「パートナーを削除できませんでした」（外部キー制約違反時）

### 7-一括削除

**トリガー**: 複数選択後の「一括削除」アクションクリック

**処理内容**:
1. 選択したレコードを一括でソフトデリート

**成功時通知**: 「パートナーが削除されました」

### 8-プリセットビュー切替

**トリガー**: プリセットビュータブのクリック

**処理内容**:
- 個人: account_type = 'individual' でフィルタリング
- 法人: account_type = 'company' でフィルタリング
- アーカイブ済み: ソフトデリート済みレコードのみ表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | partners_partners | SELECT | パートナー情報の取得 |
| 一覧表示 | partners_tags | SELECT | タグ情報の取得 |
| レコード削除 | partners_partners | UPDATE | deleted_atの更新（ソフトデリート） |
| レコード復元 | partners_partners | UPDATE | deleted_atのNULL更新 |
| 完全削除 | partners_partners | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE account_type != 'address' | 住所タイプを除外 |
| UPDATE（削除） | deleted_at | CURRENT_TIMESTAMP | ソフトデリート |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |
| DELETE | - | WHERE id = {id} | 完全削除 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| 成功 | 編集成功 | パートナーが更新されました |
| 成功 | 削除成功 | パートナーが削除されました |
| 成功 | 復元成功 | パートナーが復元されました |
| 成功 | 完全削除成功 | パートナーが完全に削除されました |
| エラー | 完全削除失敗 | パートナーを削除できませんでした |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 完全削除時の外部キー制約違反 | エラー通知を表示し、処理をキャンセル |
| 権限不足 | 該当アクションを非表示 |

## 備考

- HasTableViews トレイトを使用し、テーブルビュー管理機能を提供
- フィルターはモーダル形式（FiltersLayout::Modal）でスライドオーバー表示
- カードグリッドはレスポンシブデザインに対応
- account_type = 'address' のレコードは一覧から除外される
- 作成日時の降順（created_at DESC）がデフォルトソート
- パートナー親子関係（parent_id）により、会社と個人の関連付けが可能
