# 画面設計書 64-パートナー作成

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおけるパートナー作成画面の設計を記載します。

### 本画面の処理概要

この画面は、新規のパートナー（連絡先）をシステムに登録するための入力フォームを提供します。個人・法人の区別、連絡先情報、住所情報、営業・購買関連情報を入力できます。

**業務上の目的・背景**：
ERPシステムにおいて、取引先や顧客、サプライヤーなどのパートナー情報を正確に登録することは、すべての業務プロセスの基盤となります。新規取引開始時や既存システムからのデータ移行時に使用され、個人・法人の種別に応じた適切な情報入力を可能にします。

**画面へのアクセス方法**：
1. パートナー一覧画面から「作成」ボタンをクリック
2. パートナー作成画面に遷移

**主要な操作・処理内容**：
1. アカウントタイプ（個人/法人）の選択
2. 基本情報（名前、メール、電話等）の入力
3. アバター画像のアップロード
4. 所属会社の選択（個人の場合）
5. 住所情報の入力
6. 営業・購買関連情報の入力
7. タグの付与
8. 保存処理の実行

**画面遷移**：
- 遷移元: パートナー一覧画面（ListPartners）
- 遷移先（保存後）: パートナー詳細画面（ViewPartner）

**権限による表示制御**：
- 作成権限を持つユーザーのみアクセス可能
- 会社選択フィールドは個人（Individual）選択時のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-002 | 連絡先作成 | 主機能 | 新規パートナーの登録 |
| FN-CONT-001 | 連絡先一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-CONT-004 | 連絡先表示 | 遷移先機能 | 保存後の詳細画面表示 |

## 画面種別

登録（Create）

## URL/ルーティング

- URL: `/contacts/partners/create`
- Filament Resource: `PartnerResource`
- Filament Page: `CreatePartner`

## 画面構成

1. **基本情報セクション（General）**
   - アカウントタイプ（個人/法人）ラジオボタン
   - 名前入力フィールド
   - アバター画像アップロード
   - 会社選択（個人時のみ）
   - 税ID、役職、電話、携帯、メール、ウェブサイト
   - 敬称選択、タグ選択
   - 住所フィールドセット

2. **タブセクション**
   - 営業・購買タブ
     - 担当者選択
     - 会社ID、参照番号、業種選択

## 入出力項目

### 基本情報

| 項目名 | 項目種別 | データ型 | 必須 | 最大長 | 説明 |
|--------|----------|----------|------|--------|------|
| account_type | Radio | enum | Yes | - | アカウントタイプ（individual/company） |
| name | TextInput | string | Yes | 255 | パートナー名 |
| avatar | FileUpload | file | No | - | アバター画像（partners/avatar/に保存） |
| parent_id | Select | integer | No | - | 親会社（個人時のみ表示） |
| tax_id | TextInput | string | No | 255 | 税ID（例：29ABCDE1234F1Z5） |
| job_title | TextInput | string | No | 255 | 役職（例：CEO） |
| phone | TextInput | string | No | 255 | 電話番号 |
| mobile | TextInput | string | No | 255 | 携帯電話番号 |
| email | TextInput | email | No | 255 | メールアドレス（一意制約） |
| website | TextInput | url | No | 255 | ウェブサイトURL |
| title_id | Select | integer | No | - | 敬称 |
| tags | Select | array | No | - | タグ（複数選択可） |

### 住所情報

| 項目名 | 項目種別 | データ型 | 必須 | 最大長 | 説明 |
|--------|----------|----------|------|--------|------|
| street1 | TextInput | string | No | 255 | 住所1 |
| street2 | TextInput | string | No | 255 | 住所2 |
| city | TextInput | string | No | 255 | 市区町村 |
| zip | TextInput | string | No | 255 | 郵便番号 |
| country_id | Select | integer | No | - | 国 |
| state_id | Select | integer | No | - | 都道府県/州 |

### 営業・購買情報

| 項目名 | 項目種別 | データ型 | 必須 | 最大長 | 説明 |
|--------|----------|----------|------|--------|------|
| user_id | Select | integer | No | - | 担当者 |
| company_registry | TextInput | string | No | 255 | 会社登録番号 |
| reference | TextInput | string | No | 255 | 参照番号 |
| industry_id | Select | integer | No | - | 業種 |

## 表示項目

なし（作成画面のため入力項目のみ）

## イベント仕様

### 1-アカウントタイプ変更

**トリガー**: account_type ラジオボタンの選択変更

**処理内容**:
1. Individual選択時：parent_id（会社選択）フィールドを表示
2. Company選択時：parent_id フィールドを非表示
3. プレースホルダーテキストを動的に変更
   - Individual: "Jhon Doe"
   - Company: "ACME Corp"

### 2-国選択変更

**トリガー**: country_id の選択変更

**処理内容**:
1. state_id の値をリセット（null）
2. state_id の選択肢を選択された国のものにフィルタリング

### 3-保存ボタン押下

**トリガー**: フォーム保存ボタンのクリック

**処理内容**:
1. バリデーション実行
2. partners_partners テーブルへのINSERT
3. タグの関連付け（partners_partner_tag テーブル）
4. 成功通知の表示
5. パートナー詳細画面（ViewPartner）へリダイレクト

**成功時通知**:
- タイトル: パートナー作成成功
- 本文: パートナーが作成されました

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | partners_partners | INSERT | パートナーレコードの作成 |
| 保存 | partners_partner_tag | INSERT | タグ関連付けの作成 |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | account_type | フォーム入力値 | individual または company |
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | avatar | アップロードファイルパス | partners/avatar/ |
| INSERT | email | フォーム入力値 | 一意制約 |
| INSERT | job_title | フォーム入力値 | |
| INSERT | website | フォーム入力値 | URL形式 |
| INSERT | tax_id | フォーム入力値 | |
| INSERT | phone | フォーム入力値 | |
| INSERT | mobile | フォーム入力値 | |
| INSERT | company_registry | フォーム入力値 | |
| INSERT | reference | フォーム入力値 | |
| INSERT | street1 | フォーム入力値 | |
| INSERT | street2 | フォーム入力値 | |
| INSERT | city | フォーム入力値 | |
| INSERT | zip | フォーム入力値 | |
| INSERT | state_id | フォーム選択値 | FK: states |
| INSERT | country_id | フォーム選択値 | FK: countries |
| INSERT | parent_id | フォーム選択値 | FK: partners_partners |
| INSERT | user_id | フォーム選択値 | FK: users |
| INSERT | title_id | フォーム選択値 | FK: partners_titles |
| INSERT | industry_id | フォーム選択値 | FK: partners_industries |
| INSERT | creator_id | Auth::id() | 自動設定 |

#### partners_partner_tag

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | partner_id | 作成されたパートナーID | |
| INSERT | tag_id | 選択されたタグID | 複数レコード |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| 成功 | 作成成功 | パートナーが作成されました |
| エラー | バリデーションエラー | 各フィールドのエラーメッセージ |
| エラー | メール重複 | このメールアドレスは既に使用されています |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| バリデーションエラー | フォームにエラーメッセージを表示 |
| メール重複エラー | メールフィールドにエラーを表示 |
| データベースエラー | エラー通知を表示 |

## 備考

- CreateRecord クラスを継承
- 保存後は自動的に詳細画面（ViewPartner）へリダイレクト
- アバター画像はImageEditor機能付きで編集可能
- 会社選択時はインラインでのパートナー作成も可能（createOptionForm）
- 敬称選択時もインラインでの敬称作成が可能
- タグ選択時もインラインでのタグ作成が可能（名前と色）
- 都道府県は国に連動して絞り込み表示
- 都道府県の新規作成も可能（name, code, country_id）
