# 画面設計書 65-パートナー編集

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおけるパートナー編集画面の設計を記載します。

### 本画面の処理概要

この画面は、既存のパートナー（連絡先）情報を編集するための入力フォームを提供します。パートナー作成画面と同様のフォーム構成で、既存データをプリフィルした状態で表示します。

**業務上の目的・背景**：
取引先情報の変更（住所変更、担当者変更、連絡先変更など）は日常的に発生する業務です。パートナー編集画面は、これらの変更を迅速かつ正確に反映させ、システム全体のデータ整合性を維持するために重要な機能を提供します。

**画面へのアクセス方法**：
1. パートナー一覧画面からレコードの「編集」アクションをクリック
2. パートナー詳細画面から「編集」ボタンをクリック
3. パートナー編集画面に遷移

**主要な操作・処理内容**：
1. 既存パートナー情報の表示（プリフィル）
2. 各項目の編集
3. チャット機能（コミュニケーション履歴の管理）
4. 詳細画面への切り替え（表示ボタン）
5. パートナーの削除
6. 保存処理の実行

**画面遷移**：
- 遷移元: パートナー一覧画面（ListPartners）、パートナー詳細画面（ViewPartner）
- 遷移先（保存後）: パートナー詳細画面（ViewPartner）
- 遷移先（表示）: パートナー詳細画面（ViewPartner）
- 関連ページナビゲーション: 住所管理、連絡先管理

**権限による表示制御**：
- 編集権限を持つユーザーのみアクセス可能
- 削除権限によるDeleteActionの表示制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-003 | 連絡先編集 | 主機能 | パートナー情報の編集 |
| FN-CONT-001 | 連絡先一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-CONT-004 | 連絡先表示 | 遷移元/先機能 | 詳細画面との連携 |

## 画面種別

編集（Edit）

## URL/ルーティング

- URL: `/contacts/partners/{record}/edit`
- パラメータ: `record` - パートナーID
- Filament Resource: `PartnerResource`
- Filament Page: `EditPartner`

## 画面構成

1. **ヘッダーアクション**
   - チャットボタン（ChatterAction）
   - 表示ボタン（ViewAction）
   - 削除ボタン（DeleteAction）

2. **レコードナビゲーションタブ**
   - HasRecordNavigationTabs トレイトによる関連ページへのナビゲーション

3. **基本情報セクション（General）**
   - パートナー作成画面と同一のフォーム構成
   - 既存データがプリフィルされた状態

4. **タブセクション**
   - 営業・購買タブ（作成画面と同一）

## 入出力項目

パートナー作成画面（64-パートナー作成.md）と同一のフォーム項目。既存データがプリフィルされて表示されます。

## 表示項目

なし（編集画面のため入力項目のみ）

## イベント仕様

### 1-チャット（Chatter）ボタン押下

**トリガー**: ヘッダーの「チャット」ボタンクリック

**処理内容**:
1. ChatterActionダイアログを表示
2. パートナーに関連するコミュニケーション履歴の表示・追加

### 2-表示ボタン押下

**トリガー**: ヘッダーの「表示」ボタンクリック

**処理内容**:
1. パートナー詳細画面（ViewPartner）へ遷移

### 3-削除ボタン押下

**トリガー**: ヘッダーの「削除」ボタンクリック

**処理内容**:
1. 確認ダイアログを表示
2. ソフトデリートを実行
3. 成功通知を表示

**成功時通知**:
- タイトル: パートナー削除成功
- 本文: パートナーが削除されました

### 4-保存ボタン押下

**トリガー**: フォーム保存ボタンのクリック

**処理内容**:
1. バリデーション実行
2. partners_partners テーブルへのUPDATE
3. タグの関連付け更新（partners_partner_tag テーブル）
4. 成功通知の表示
5. パートナー詳細画面（ViewPartner）へリダイレクト

**成功時通知**:
- タイトル: パートナー更新成功
- 本文: パートナーが更新されました

### 5-アカウントタイプ変更・国選択変更

パートナー作成画面（64-パートナー作成.md）と同一の動作。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示 | partners_partners | SELECT | パートナー情報の取得 |
| 保存 | partners_partners | UPDATE | パートナーレコードの更新 |
| 保存 | partners_partner_tag | DELETE/INSERT | タグ関連付けの更新（全削除後再作成） |
| 削除 | partners_partners | UPDATE | deleted_atの更新（ソフトデリート） |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE id = {record} | 編集対象の取得 |
| UPDATE | 全フォーム項目 | フォーム入力値 | 変更された項目 |
| UPDATE（削除） | deleted_at | CURRENT_TIMESTAMP | ソフトデリート |

#### partners_partner_tag

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE partner_id = {record} | 既存タグ関連付けの削除 |
| INSERT | partner_id, tag_id | 選択されたタグ | 新規タグ関連付け |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| 成功 | 更新成功 | パートナーが更新されました |
| 成功 | 削除成功 | パートナーが削除されました |
| エラー | バリデーションエラー | 各フィールドのエラーメッセージ |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| パートナーが存在しない | 404エラーページを表示 |
| パートナーが削除済み | 404エラーページまたは復元オプション |
| バリデーションエラー | フォームにエラーメッセージを表示 |
| メール重複エラー | メールフィールドにエラーを表示 |

## 備考

- EditRecord クラスを継承
- HasRecordNavigationTabs トレイトにより、関連ページ（住所管理、連絡先管理等）へのナビゲーションが提供される
- ChatterAction によりパートナーに関するコミュニケーション履歴を管理可能
- 保存後は自動的に詳細画面（ViewPartner）へリダイレクト
- フォーム構成はパートナー作成画面と同一（PartnerResource::form()を共有）
- サブナビゲーション機能により、クラスターに属するコンポーネントへのナビゲーションも提供
