# 画面設計書 66-パートナー詳細

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおけるパートナー詳細画面の設計を記載します。

### 本画面の処理概要

この画面は、既存のパートナー（連絡先）情報を閲覧するための詳細表示画面です。Infolistコンポーネントを使用し、読み取り専用で情報を表示します。

**業務上の目的・背景**：
取引先情報の確認は、営業活動、請求処理、配送手配など多くの業務で必要となります。パートナー詳細画面は、パートナーの全情報を一覧できる形式で表示し、迅速な情報確認と関連ページへの効率的なナビゲーションを提供します。

**画面へのアクセス方法**：
1. パートナー一覧画面からレコードの「表示」アクションをクリック
2. パートナー作成後のリダイレクト
3. パートナー編集後のリダイレクト
4. パートナー詳細画面に遷移

**主要な操作・処理内容**：
1. パートナー基本情報の表示
2. 連絡先情報（電話、メール、ウェブサイト）の表示
3. 住所情報の表示
4. 営業・購買関連情報の表示
5. タグ情報の表示
6. チャット機能（コミュニケーション履歴の管理）
7. 編集画面への遷移
8. パートナーの削除

**画面遷移**：
- 遷移元: パートナー一覧画面（ListPartners）、作成画面、編集画面
- 遷移先: パートナー編集画面（EditPartner）
- 関連ページナビゲーション: 住所管理、連絡先管理

**権限による表示制御**：
- 閲覧権限を持つユーザーがアクセス可能
- 編集・削除権限によるアクションの表示制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-004 | 連絡先表示 | 主機能 | パートナー詳細情報の表示 |
| FN-CONT-001 | 連絡先一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-CONT-003 | 連絡先編集 | 遷移先機能 | 編集画面への遷移 |

## 画面種別

詳細（View）

## URL/ルーティング

- URL: `/contacts/partners/{record}`
- パラメータ: `record` - パートナーID
- Filament Resource: `PartnerResource`
- Filament Page: `ViewPartner`

## 画面構成

1. **ヘッダーアクション**
   - チャットボタン（ChatterAction）
   - 編集ボタン（EditAction）
   - 削除ボタン（DeleteAction）

2. **レコードナビゲーションタブ**
   - HasRecordNavigationTabs トレイトによる関連ページへのナビゲーション
   - 住所管理、連絡先管理などへのタブナビゲーション

3. **基本情報セクション（General）**
   - アカウントタイプ（バッジ表示）
   - 名前（太字、大サイズ）
   - 会社名（個人の場合）
   - アバター画像（円形、100x100）
   - 税ID、役職、電話、携帯、メール、ウェブサイト
   - 敬称、タグ
   - 住所フィールドセット

4. **タブセクション**
   - 営業・購買タブ
     - 担当者
     - 会社ID、参照番号、業種

## 入出力項目

なし（詳細画面のため表示項目のみ）

## 表示項目

### 基本情報セクション

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| アカウントタイプ | partners_partners.account_type | バッジ（primary色） | individual/company |
| 名前 | partners_partners.name | テキスト（太字、大サイズ） | パートナー名 |
| 会社 | parent.name | テキスト | 所属会社名（個人のみ表示） |
| アバター | partners_partners.avatar | 画像（円形、100x100） | プロフィール画像 |
| 税ID | partners_partners.tax_id | テキスト | 税識別番号 |
| 役職 | partners_partners.job_title | テキスト | 職位・役職 |
| 電話 | partners_partners.phone | テキスト（電話アイコン） | 電話番号 |
| 携帯 | partners_partners.mobile | テキスト（モバイルアイコン） | 携帯電話番号 |
| メール | partners_partners.email | テキスト（封筒アイコン） | メールアドレス |
| ウェブサイト | partners_partners.website | テキスト（地球アイコン） | ウェブサイトURL |
| 敬称 | title.name | テキスト | 敬称 |
| タグ | tags.name | バッジ（カラー付き） | タグ一覧 |

### 住所情報

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| 住所1 | partners_partners.street1 | テキスト | 番地等 |
| 住所2 | partners_partners.street2 | テキスト | 建物名等 |
| 市区町村 | partners_partners.city | テキスト | 市区町村 |
| 郵便番号 | partners_partners.zip | テキスト | 郵便番号 |
| 国 | country.name | テキスト | 国名 |
| 都道府県/州 | state.name | テキスト | 都道府県/州名 |

### 営業・購買情報

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| 担当者 | user.name | テキスト | 責任者名 |
| 会社ID | partners_partners.company_registry | テキスト | 会社登録番号 |
| 参照番号 | partners_partners.reference | テキスト | 参照番号 |
| 業種 | industry.name | テキスト | 業種名 |

## イベント仕様

### 1-チャット（Chatter）ボタン押下

**トリガー**: ヘッダーの「チャット」ボタンクリック

**処理内容**:
1. ChatterActionダイアログを表示
2. パートナーに関連するコミュニケーション履歴の表示・追加

### 2-編集ボタン押下

**トリガー**: ヘッダーの「編集」ボタンクリック

**処理内容**:
1. パートナー編集画面（EditPartner）へ遷移

### 3-削除ボタン押下

**トリガー**: ヘッダーの「削除」ボタンクリック

**処理内容**:
1. 確認ダイアログを表示
2. ソフトデリートを実行
3. 成功通知を表示
4. 一覧画面へリダイレクト

**成功時通知**:
- タイトル: パートナー削除成功
- 本文: パートナーが削除されました

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示 | partners_partners | SELECT | パートナー情報の取得 |
| 表示 | partners_tags | SELECT | タグ情報の取得 |
| 削除 | partners_partners | UPDATE | deleted_atの更新（ソフトデリート） |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE id = {record} | リレーション含む |
| UPDATE（削除） | deleted_at | CURRENT_TIMESTAMP | ソフトデリート |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| 成功 | 削除成功 | パートナーが削除されました |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| パートナーが存在しない | 404エラーページを表示 |
| パートナーが削除済み | 404エラーページまたは復元オプション |

## 備考

- ViewRecord クラスを継承
- HasRecordNavigationTabs トレイトにより、関連ページへのナビゲーションが提供される
- Infolist を使用した読み取り専用表示
- タグはカラーパレットを動的に生成して表示（Color::generateV3Palette）
- 会社選択フィールドは個人（Individual）の場合のみ表示
- 未設定項目はプレースホルダー「—」を表示
- ChatterAction によりパートナーに関するコミュニケーション履歴を管理可能
- アバター画像は円形で表示（circular）
