# 画面設計書 67-住所管理

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおける住所管理画面の設計を記載します。

### 本画面の処理概要

この画面は、パートナーに関連する住所情報を管理するための関連レコード管理画面です。パートナー詳細画面のタブナビゲーションからアクセスし、請求先住所や配送先住所などを個別に管理できます。

**業務上の目的・背景**：
ERPシステムにおいて、取引先は複数の住所（本社所在地、請求先、配送先など）を持つことが一般的です。住所管理画面は、これらの住所情報を一元的に管理し、請求書や配送伝票への正確な住所反映を可能にします。住所タイプ（請求/配送/その他等）を区別して管理することで、業務効率を向上させます。

**画面へのアクセス方法**：
1. パートナー一覧画面からパートナーを選択
2. パートナー詳細・編集画面のレコードナビゲーションタブから「住所」を選択
3. 住所管理画面に遷移

**主要な操作・処理内容**：
1. パートナーに紐づく住所一覧の表示
2. 新規住所の作成（ヘッダーアクション）
3. 既存住所の編集（レコードアクション）
4. 住所の削除（レコードアクション）
5. 住所の一括削除（ツールバーアクション）

**画面遷移**：
- 遷移元: パートナー詳細画面（ViewPartner）、パートナー編集画面（EditPartner）
- タブナビゲーション: 他の関連ページ（連絡先管理等）への切り替え

**権限による表示制御**：
- パートナーへのアクセス権限に基づく
- 各操作（作成、編集、削除）は個別の権限設定による

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-005 | 住所一覧 | 主機能 | 住所の一覧表示 |
| FN-CONT-006 | 住所作成 | 主機能 | 新規住所の作成 |
| FN-CONT-007 | 住所編集 | 主機能 | 既存住所の編集 |
| FN-CONT-008 | 住所表示 | 主機能 | 住所詳細の表示 |

## 画面種別

関連レコード管理（ManageRelatedRecords）

## URL/ルーティング

- URL: `/contacts/partners/{record}/addresses`
- パラメータ: `record` - 親パートナーID
- Filament Resource: `PartnerResource`
- Filament Page: `ManageAddresses`
- リレーション: `addresses`

## 画面構成

1. **レコードナビゲーションタブ**
   - HasRecordNavigationTabs トレイトによる関連ページへのナビゲーション
   - マップピンアイコン（heroicon-o-map-pin）

2. **住所一覧テーブル**
   - ヘッダーアクション: 作成ボタン
   - 住所データの一覧表示
   - レコードアクション: 編集、削除
   - ツールバーアクション: 一括削除

## 入出力項目

### 住所フォーム

| 項目名 | 項目種別 | データ型 | 必須 | 最大長 | 説明 |
|--------|----------|----------|------|--------|------|
| sub_type | Radio | enum | No | - | 住所タイプ（invoice/delivery/other等） |
| name | TextInput | string | Yes | 255 | 住所名・宛名 |
| email | TextInput | email | No | 255 | メールアドレス |
| phone | TextInput | string | No | 255 | 電話番号 |
| mobile | TextInput | string | No | - | 携帯電話番号 |
| street1 | TextInput | string | No | 255 | 住所1 |
| street2 | TextInput | string | No | 255 | 住所2 |
| city | TextInput | string | No | 255 | 市区町村 |
| zip | TextInput | string | No | 255 | 郵便番号 |
| country_id | Select | integer | No | - | 国 |
| state_id | Select | integer | No | - | 都道府県/州 |

## 表示項目

### 住所一覧テーブル

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| タイプ | partners_partners.sub_type | テキスト | 住所タイプ（検索可） |
| 名前 | partners_partners.name | テキスト | 住所名・宛名（検索可） |
| 国 | country.name | テキスト | 国名（検索可） |
| 都道府県/州 | state.name | テキスト | 都道府県/州名（検索可） |
| 住所1 | partners_partners.street1 | テキスト | 番地等（検索可） |
| 住所2 | partners_partners.street2 | テキスト | 建物名等（検索可） |
| 市区町村 | partners_partners.city | テキスト | 市区町村（検索可） |
| 郵便番号 | partners_partners.zip | テキスト | 郵便番号（検索可） |

## イベント仕様

### 1-住所作成

**トリガー**: ヘッダーの「作成」ボタンクリック

**処理内容**:
1. 住所作成モーダルを表示
2. フォーム入力を受け付け
3. バリデーション実行
4. account_type = 'address' を自動設定
5. creator_id に現在のユーザーIDを設定
6. partners_partners テーブルへINSERT（親パートナーのparent_idを設定）
7. 成功通知を表示

**成功時通知**:
- タイトル: 住所作成成功
- 本文: 住所が作成されました

### 2-住所編集

**トリガー**: レコードの「編集」アクションクリック

**処理内容**:
1. 住所編集モーダルを表示（既存データをプリフィル）
2. フォーム入力の変更を受け付け
3. バリデーション実行
4. partners_partners テーブルをUPDATE
5. 成功通知を表示

**成功時通知**:
- タイトル: 住所更新成功
- 本文: 住所が更新されました

### 3-住所削除

**トリガー**: レコードの「削除」アクションクリック

**処理内容**:
1. 確認ダイアログを表示
2. partners_partners テーブルからDELETE（または ソフトデリート）
3. 成功通知を表示

**成功時通知**:
- タイトル: 住所削除成功
- 本文: 住所が削除されました

### 4-一括削除

**トリガー**: 複数選択後の「一括削除」アクションクリック

**処理内容**:
1. 選択した住所レコードを一括で削除
2. 成功通知を表示

**成功時通知**:
- タイトル: 住所一括削除成功
- 本文: 住所が削除されました

### 5-国選択変更

**トリガー**: country_id の選択変更

**処理内容**:
1. state_id の値をリセット（null）
2. state_id の選択肢を選択された国のものにフィルタリング

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | partners_partners | SELECT | 住所情報の取得（addresses リレーション） |
| 作成 | partners_partners | INSERT | 住所レコードの作成 |
| 編集 | partners_partners | UPDATE | 住所レコードの更新 |
| 削除 | partners_partners | DELETE | 住所レコードの削除 |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE parent_id = {record} AND account_type = 'address' | 住所タイプのみ |
| INSERT | account_type | 'address' | 自動設定 |
| INSERT | parent_id | 親パートナーID | 自動設定 |
| INSERT | creator_id | Auth::id() | 自動設定 |
| INSERT | sub_type | フォーム入力値 | invoice/delivery/other等 |
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | email | フォーム入力値 | |
| INSERT | phone | フォーム入力値 | |
| INSERT | mobile | フォーム入力値 | |
| INSERT | street1 | フォーム入力値 | |
| INSERT | street2 | フォーム入力値 | |
| INSERT | city | フォーム入力値 | |
| INSERT | zip | フォーム入力値 | |
| INSERT | country_id | フォーム選択値 | FK: countries |
| INSERT | state_id | フォーム選択値 | FK: states |
| UPDATE | 各カラム | フォーム入力値 | 変更された項目 |
| DELETE | - | WHERE id = {id} | 物理削除 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| 成功 | 作成成功 | 住所が作成されました |
| 成功 | 更新成功 | 住所が更新されました |
| 成功 | 削除成功 | 住所が削除されました |
| 成功 | 一括削除成功 | 住所が削除されました |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| パートナーが存在しない | 404エラーページを表示 |
| バリデーションエラー | フォームにエラーメッセージを表示 |

## 備考

- ManageRelatedRecords クラスを継承
- HasRecordNavigationTabs トレイトにより、関連ページへのナビゲーションが提供される
- 住所はパートナーテーブル（partners_partners）の一部として保存される（account_type = 'address'）
- 親パートナーとの関連付けは parent_id カラムで管理
- フォーム定義は AddressResource::form() を使用
- テーブル定義は AddressResource::table() を使用
- 住所タイプ（sub_type）はAddressType Enumで定義（invoice, delivery 等）
- 都道府県は国に連動して絞り込み表示
- 都道府県の新規作成も可能（name, code, country_id）
