# 画面設計書 68-連絡先管理

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおける連絡先管理画面の設計を記載します。

### 本画面の処理概要

この画面は、パートナー（主に会社）に関連する連絡先（担当者・従業員）情報を管理するための関連レコード管理画面です。パートナー詳細画面のタブナビゲーションからアクセスし、会社に所属する個人の連絡先を管理できます。

**業務上の目的・背景**：
ERPシステムにおいて、取引先企業には複数の担当者（営業担当、経理担当、技術担当など）が存在することが一般的です。連絡先管理画面は、これらの担当者情報を一元的に管理し、適切な担当者への連絡を可能にします。これにより、業務効率の向上と顧客満足度の改善を実現します。

**画面へのアクセス方法**：
1. パートナー一覧画面からパートナー（会社）を選択
2. パートナー詳細・編集画面のレコードナビゲーションタブから「連絡先」を選択
3. 連絡先管理画面に遷移

**主要な操作・処理内容**：
1. パートナーに紐づく連絡先一覧の表示（カードグリッド形式）
2. 新規連絡先の作成（ヘッダーアクション）
3. 既存連絡先の表示・編集（レコードアクション）
4. 連絡先の削除（レコードアクション）
5. 連絡先の一括操作（復元、削除、完全削除）

**画面遷移**：
- 遷移元: パートナー詳細画面（ViewPartner）、パートナー編集画面（EditPartner）
- タブナビゲーション: 他の関連ページ（住所管理等）への切り替え

**権限による表示制御**：
- パートナーへのアクセス権限に基づく
- 各操作（作成、編集、削除）は個別の権限設定による
- 削除済みレコードには復元・完全削除アクションが表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-001 | 連絡先一覧 | 主機能 | 連絡先の一覧表示 |
| FN-CONT-002 | 連絡先作成 | 主機能 | 新規連絡先の作成 |
| FN-CONT-003 | 連絡先編集 | 主機能 | 既存連絡先の編集 |
| FN-CONT-004 | 連絡先表示 | 主機能 | 連絡先詳細の表示 |

## 画面種別

関連レコード管理（ManageRelatedRecords）

## URL/ルーティング

- URL: `/contacts/partners/{record}/contacts`
- パラメータ: `record` - 親パートナーID
- Filament Resource: `PartnerResource`
- Filament Page: `ManageContacts`
- リレーション: `contacts`

## 画面構成

1. **レコードナビゲーションタブ**
   - HasRecordNavigationTabs トレイトによる関連ページへのナビゲーション
   - ユーザーグループアイコン（heroicon-o-users）

2. **連絡先一覧テーブル**
   - ヘッダーアクション: 作成ボタン
   - カードグリッド形式での表示（PartnerResource::table()使用）
   - レコードアクション: 表示、編集、復元、削除、完全削除
   - ツールバーアクション: 一括削除、一括復元、一括完全削除

## 入出力項目

連絡先フォームはパートナー作成フォーム（PartnerResource::form()）と同一。
主な入力項目:

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| account_type | Radio | enum | Yes | 個人/法人 |
| name | TextInput | string | Yes | 連絡先名 |
| email | TextInput | email | No | メールアドレス |
| phone | TextInput | string | No | 電話番号 |
| mobile | TextInput | string | No | 携帯電話番号 |
| job_title | TextInput | string | No | 役職 |
| その他 | - | - | No | パートナーフォームと同一 |

## 表示項目

### 連絡先一覧（カードグリッド）

PartnerResource::table() の定義に従う。主な表示項目:

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| アバター | partners_partners.avatar | 画像（200x250px） | プロフィール画像 |
| 名前 | partners_partners.name | テキスト（太字） | 連絡先名 |
| 役職 | partners_partners.job_title | テキスト（ブリーフケースアイコン） | 職位 |
| メール | partners_partners.email | テキスト（封筒アイコン） | メールアドレス |
| 電話 | partners_partners.phone | テキスト（電話アイコン） | 電話番号 |
| タグ | tags.name | バッジ | タグ一覧 |

## イベント仕様

### 1-連絡先作成

**トリガー**: ヘッダーの「作成」ボタンクリック

**処理内容**:
1. 連絡先作成モーダルを表示（PartnerResource::form()使用）
2. フォーム入力を受け付け
3. バリデーション実行
4. creator_id に現在のユーザーIDを設定（mutateDataUsing）
5. partners_partners テーブルへINSERT（親パートナーのparent_idを設定）
6. 成功通知を表示

**成功時通知**:
- タイトル: 連絡先作成成功
- 本文: 連絡先が作成されました

### 2-連絡先表示

**トリガー**: カードの「表示」アクションクリック

**処理内容**:
1. 連絡先の詳細をモーダルまたはページで表示

**表示条件**: レコードが削除済み（trashed）でない場合のみ表示

### 3-連絡先編集

**トリガー**: カードの「編集」アクションクリック

**処理内容**:
1. 連絡先編集モーダルを表示（既存データをプリフィル）
2. フォーム入力の変更を受け付け
3. バリデーション実行
4. partners_partners テーブルをUPDATE
5. 成功通知を表示

**表示条件**: レコードが削除済み（trashed）でない場合のみ表示

### 4-連絡先削除

**トリガー**: カードの「削除」アクションクリック

**処理内容**:
1. 確認ダイアログを表示
2. ソフトデリートを実行
3. 成功通知を表示

### 5-連絡先復元

**トリガー**: 削除済みカードの「復元」アクションクリック

**処理内容**:
1. ソフトデリートを解除
2. 成功通知を表示

### 6-連絡先完全削除

**トリガー**: 削除済みカードの「完全削除」アクションクリック

**処理内容**:
1. 確認ダイアログを表示
2. 物理削除を実行
3. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | partners_partners | SELECT | 連絡先情報の取得（contacts リレーション） |
| 作成 | partners_partners | INSERT | 連絡先レコードの作成 |
| 編集 | partners_partners | UPDATE | 連絡先レコードの更新 |
| 削除 | partners_partners | UPDATE | deleted_atの更新（ソフトデリート） |
| 復元 | partners_partners | UPDATE | deleted_atのNULL更新 |
| 完全削除 | partners_partners | DELETE | 物理削除 |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE parent_id = {record} AND account_type != 'address' | 住所以外 |
| INSERT | parent_id | 親パートナーID | 自動設定 |
| INSERT | creator_id | Auth::id() | mutateDataUsingで設定 |
| INSERT | 各フォーム項目 | フォーム入力値 | |
| UPDATE | 各カラム | フォーム入力値 | 変更された項目 |
| UPDATE（削除） | deleted_at | CURRENT_TIMESTAMP | ソフトデリート |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |
| DELETE | - | WHERE id = {id} | 完全削除 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| 成功 | 作成成功 | 連絡先が作成されました |
| 成功 | 更新成功 | 連絡先が更新されました |
| 成功 | 削除成功 | 連絡先が削除されました |
| 成功 | 復元成功 | 連絡先が復元されました |
| 成功 | 完全削除成功 | 連絡先が完全に削除されました |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| パートナーが存在しない | 404エラーページを表示 |
| バリデーションエラー | フォームにエラーメッセージを表示 |
| 完全削除時の外部キー制約違反 | エラー通知を表示 |

## 備考

- ManageRelatedRecords クラスを継承
- HasRecordNavigationTabs トレイトにより、関連ページへのナビゲーションが提供される
- 連絡先はパートナーテーブル（partners_partners）の一部として保存される（account_type != 'address'）
- 親パートナーとの関連付けは parent_id カラムで管理
- フォーム定義は PartnerResource::form() を使用（作成フォームと同一）
- テーブル定義は PartnerResource::table() を使用（一覧画面と同一のカードグリッド形式）
- 作成時に creator_id が自動設定される（mutateDataUsing）
- カードグリッドはレスポンシブデザインに対応
