# 画面設計書 69-銀行口座管理

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおける銀行口座管理画面の設計を記載します。

### 本画面の処理概要

この画面は、パートナーに関連する銀行口座情報を管理するための画面です。連絡先モジュールの設定クラスター（Configurations）に属し、パートナーの銀行口座を一元管理します。

**業務上の目的・背景**：
ERPシステムにおいて、取引先の銀行口座情報は支払処理、振込処理、入金確認などの財務業務に不可欠です。銀行口座管理画面は、これらの銀行口座情報を正確に登録・管理し、スムーズな決済処理を実現します。送金可能フラグにより、実際に資金移動が可能な口座を識別できます。

**画面へのアクセス方法**：
1. サイドメニューから「連絡先」モジュールを選択
2. 設定（Configurations）クラスターから「銀行口座」を選択
3. 銀行口座管理画面に遷移

**主要な操作・処理内容**：
1. 銀行口座一覧の表示
2. 新規銀行口座の作成（ヘッダーアクション）
3. 既存銀行口座の編集（レコードアクション）
4. 銀行口座の削除・復元・完全削除
5. フィルタリング（送金可否、銀行、口座名義人、作成者）
6. グループ化（銀行、送金可否、作成日）
7. タブ切替（全件、アーカイブ済み）

**画面遷移**：
- タブナビゲーション: 全件、アーカイブ済み
- 銀行のインライン作成

**権限による表示制御**：
- 削除済みレコードには「編集」アクションが非表示
- 削除済みレコードには「復元」「完全削除」アクションが表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-013 | 銀行口座管理 | 主機能 | 銀行口座の作成・編集・削除 |

## 画面種別

管理（ManageRecords）

## URL/ルーティング

- URL: `/contacts/configurations/bank-accounts`
- Filament Resource: `BankAccountResource`
- Filament Page: `ManageBankAccounts`
- クラスター: Configurations

## 画面構成

1. **ヘッダー**
   - 画面タイトル
   - 作成ボタン（+アイコン付き）

2. **タブ**
   - 全件（All）- レコード件数バッジ付き
   - アーカイブ済み（Archived）- 削除済みレコード件数バッジ付き

3. **銀行口座一覧テーブル**
   - カラム並べ替え可能（reorderableColumns）
   - フィルター機能
   - グループ化機能
   - レコードアクション
   - ツールバーアクション（一括操作）

## 入出力項目

### 銀行口座フォーム

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| account_number | TextInput | string | Yes | 口座番号（一意制約） |
| can_send_money | Toggle | boolean | No | 送金可能フラグ |
| bank_id | Select | integer | Yes | 銀行（インライン作成可） |
| partner_id | Select | integer | Yes | 口座名義人（パートナー） |

## 表示項目

### 銀行口座一覧テーブル

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| 口座番号 | partners_bank_accounts.account_number | テキスト | 銀行口座番号（検索・ソート可） |
| 銀行 | bank.name | テキスト | 銀行名（検索・ソート可） |
| 口座名義人 | partner.name | テキスト | パートナー名（ソート可） |
| 送金可否 | partners_bank_accounts.can_send_money | アイコン（boolean） | 送金可能かどうか（ソート可） |
| 削除日 | partners_bank_accounts.deleted_at | 日時 | 削除日時（トグル非表示） |
| 作成日 | partners_bank_accounts.created_at | 日時 | 作成日時（トグル非表示） |
| 更新日 | partners_bank_accounts.updated_at | 日時 | 更新日時（トグル非表示） |

## イベント仕様

### 1-銀行口座作成

**トリガー**: ヘッダーの「作成」ボタンクリック

**処理内容**:
1. 銀行口座作成モーダルを表示
2. フォーム入力を受け付け
3. バリデーション実行（口座番号の一意性確認）
4. creator_id に現在のユーザーIDを設定
5. partners_bank_accounts テーブルへINSERT
6. 成功通知を表示

**成功時通知**:
- タイトル: 銀行口座作成成功
- 本文: 銀行口座が作成されました

### 2-銀行口座編集

**トリガー**: レコードの「編集」アクションクリック

**処理内容**:
1. 銀行口座編集モーダルを表示（既存データをプリフィル）
2. フォーム入力の変更を受け付け
3. バリデーション実行
4. partners_bank_accounts テーブルをUPDATE
5. 成功通知を表示

**表示条件**: レコードが削除済み（trashed）でない場合のみ表示

**成功時通知**:
- タイトル: 銀行口座更新成功
- 本文: 銀行口座が更新されました

### 3-銀行口座削除

**トリガー**: レコードの「削除」アクションクリック

**処理内容**:
1. 確認ダイアログを表示
2. ソフトデリートを実行
3. 成功通知を表示

**成功時通知**:
- タイトル: 銀行口座削除成功
- 本文: 銀行口座が削除されました

### 4-銀行口座復元

**トリガー**: 削除済みレコードの「復元」アクションクリック

**処理内容**:
1. ソフトデリートを解除
2. 成功通知を表示

**成功時通知**:
- タイトル: 銀行口座復元成功
- 本文: 銀行口座が復元されました

### 5-銀行口座完全削除

**トリガー**: 削除済みレコードの「完全削除」アクションクリック

**処理内容**:
1. 確認ダイアログを表示
2. 物理削除を実行
3. 成功通知を表示

**成功時通知**:
- タイトル: 銀行口座完全削除成功
- 本文: 銀行口座が完全に削除されました

### 6-タブ切替

**トリガー**: タブのクリック

**処理内容**:
- 全件: 全銀行口座を表示
- アーカイブ済み: ソフトデリート済みレコードのみ表示（onlyTrashed）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | partners_bank_accounts | SELECT | 銀行口座情報の取得 |
| 作成 | partners_bank_accounts | INSERT | 銀行口座レコードの作成 |
| 編集 | partners_bank_accounts | UPDATE | 銀行口座レコードの更新 |
| 削除 | partners_bank_accounts | UPDATE | deleted_atの更新（ソフトデリート） |
| 復元 | partners_bank_accounts | UPDATE | deleted_atのNULL更新 |
| 完全削除 | partners_bank_accounts | DELETE | 物理削除 |

### テーブル別更新項目詳細

#### partners_bank_accounts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | - | リレーション含む（bank, partner） |
| INSERT | account_number | フォーム入力値 | 必須、一意 |
| INSERT | can_send_money | フォーム入力値 | boolean |
| INSERT | bank_id | フォーム選択値 | FK: partners_banks |
| INSERT | partner_id | フォーム選択値 | FK: partners_partners |
| INSERT | creator_id | Auth::id() | 自動設定 |
| UPDATE | 各カラム | フォーム入力値 | 変更された項目 |
| UPDATE（削除） | deleted_at | CURRENT_TIMESTAMP | ソフトデリート |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |
| DELETE | - | WHERE id = {id} | 完全削除 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| 成功 | 作成成功 | 銀行口座が作成されました |
| 成功 | 更新成功 | 銀行口座が更新されました |
| 成功 | 削除成功 | 銀行口座が削除されました |
| 成功 | 復元成功 | 銀行口座が復元されました |
| 成功 | 完全削除成功 | 銀行口座が完全に削除されました |
| 成功 | 一括削除成功 | 銀行口座が削除されました |
| 成功 | 一括復元成功 | 銀行口座が復元されました |
| 成功 | 一括完全削除成功 | 銀行口座が完全に削除されました |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 口座番号重複 | バリデーションエラーを表示 |
| 外部キー制約違反（完全削除時） | エラー通知を表示 |

## 備考

- ManageRecords クラスを継承
- Configurations クラスターに属する
- 銀行選択時に削除済み銀行も表示（withTrashed）、ただし選択不可（disableOptionWhen）
- 銀行のインライン作成が可能（BankResource::form()使用）
- カラム並べ替え可能（reorderableColumns = true）
- 日時カラムはデフォルトで非表示（isToggledHiddenByDefault = true）
- グループ化機能: 銀行、送金可否、作成日でグループ化可能
- フィルター機能: 送金可否、銀行、口座名義人、作成者
- タブにレコード件数がバッジ表示される
