# 画面設計書 7-請求書一覧

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける仕入先請求書（Bill）一覧画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、仕入先から受け取った請求書（仕入請求書）を一覧形式で管理するための画面です。請求書の検索、表示、新規作成、編集への導線を提供し、プリセットビュー（タブ）機能によるステータス別の絞り込み表示が可能です。

**業務上の目的・背景**：仕入先請求書は、購買プロセスにおける支払義務を管理するための重要な書類です。本画面により、経理担当者は未払いの請求書、支払済みの請求書、下書き状態の請求書などを効率的に管理し、支払スケジュールの把握と適切な資金管理を実現します。

**画面へのアクセス方法**：会計モジュールのメニューから「仕入先請求書」を選択してアクセスします。

**主要な操作・処理内容**：
1. 請求書一覧の表示（請求書番号、仕入先、日付、金額、ステータス等）
2. プリセットビュー（タブ）によるステータス別絞り込み
3. 検索・フィルタ機能による絞り込み
4. 「新規作成」ボタンから請求書作成画面への遷移
5. 一覧行クリックによる詳細画面への遷移

**画面遷移**：
- 本画面から遷移可能：請求書作成画面、請求書詳細画面、請求書編集画面
- 本画面への遷移元：会計モジュールメニュー、ダッシュボード

**権限による表示制御**：会計モジュールへのアクセス権限を持つユーザーのみ表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-005 | 仕入請求書一覧 | 主機能 | 仕入請求書の一覧表示 |
| FN-ACC-006 | 仕入請求書作成 | 遷移先機能 | 新規仕入請求書の作成 |
| FN-ACC-007 | 仕入請求書編集 | 遷移先機能 | 既存仕入請求書の編集 |
| FN-ACC-008 | 仕入請求書表示 | 遷移先機能 | 仕入請求書詳細の表示 |

## 画面種別

一覧

## URL/ルーティング

`/accounts/bills`

## 画面構成

- ヘッダーエリア：画面タイトル、新規作成ボタン
- プリセットビュータブ：請求書（デフォルト）、その他のビュー
- テーブルエリア：請求書一覧テーブル
- フィルタエリア：各種フィルタ条件

## 入出力項目

該当なし（一覧画面のため入力項目なし）

## 表示項目

| No | 項目名 | 物理名 | 型 | 説明 | 備考 |
|----|--------|--------|-----|------|------|
| 1 | 請求書番号 | name | string | 請求書の識別番号 | 検索可能 |
| 2 | 仕入先 | invoice_partner_display_name | string | 仕入先名 | |
| 3 | 請求日 | invoice_date | date | 請求書の日付 | |
| 4 | 会計日 | date | date | 会計上の日付 | |
| 5 | 支払期日 | invoice_date_due | date | 支払期限 | |
| 6 | ステータス | state | enum | 請求書のステータス | MoveState Enum |
| 7 | 支払状態 | payment_state | enum | 支払状態 | PaymentState Enum |
| 8 | 税抜金額 | amount_untaxed | decimal | 税抜合計金額 | |
| 9 | 税額 | amount_tax | decimal | 税額合計 | |
| 10 | 合計金額 | amount_total | decimal | 税込合計金額 | |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「+」アイコン付きボタンを押下すると、請求書作成画面（CreateBill）へ遷移します。

### 2-プリセットビュー選択

プリセットビュー（タブ）を選択すると、対応するフィルタ条件でテーブルが絞り込まれます。
- 請求書（bill）：move_type = IN_INVOICE でフィルタリング（デフォルト、お気に入り設定）
- その他のビュー：親クラスから継承（Invoice以外）

### 3-行クリック

一覧の行をクリックすると、該当レコードの詳細画面（ViewBill）へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | accounts_moves | SELECT | 請求書レコードを取得（move_type条件付き） |

### テーブル別更新項目詳細

本画面は一覧表示のため、データベース更新は行いません。

## メッセージ仕様

該当なし（一覧表示画面のため）

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| データ取得失敗 | エラーページ表示 | システムエラーが発生しました |
| 権限不足 | アクセス拒否 | この画面を表示する権限がありません |

## 備考

- 本画面はInvoiceResource（顧客請求書）のListInvoicesを継承しています
- HasTableViewsトレイトを使用してプリセットビュー機能を実装しています
- デフォルトビューは「請求書（bill）」で、move_type = IN_INVOICEでフィルタリング
- 親クラスの「invoice」ビューは除外されています
- プリセットビューはお気に入り設定・デフォルト設定が可能です
- テーブル定義はInvoiceResource::table()を共有使用しています
- モデルはAccountMove（accounts_moves）を使用
- ナビゲーションへの表示は無効化されています（shouldRegisterNavigation = false）
