# 画面設計書 70-タグ管理

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおけるタグ管理画面の設計を記載します。

### 本画面の処理概要

この画面は、パートナーに付与するタグを管理するための画面です。連絡先モジュールの設定クラスター（Configurations）に属し、パートナーの分類・カテゴライズに使用するタグを一元管理します。

**業務上の目的・背景**：
ERPシステムにおいて、タグはパートナーの分類やフィルタリングに使用される重要な機能です。タグ管理画面は、これらのタグを作成・編集・削除し、パートナー一覧での効率的なフィルタリングや、マーケティング活動のセグメンテーションを可能にします。タグには色を設定でき、視覚的な識別を容易にします。

**画面へのアクセス方法**：
1. サイドメニューから「連絡先」モジュールを選択
2. 設定（Configurations）クラスターから「タグ」を選択
3. タグ管理画面に遷移

**主要な操作・処理内容**：
1. タグ一覧の表示
2. 新規タグの作成（ヘッダーアクション）
3. 既存タグの編集（レコードアクション）
4. タグの削除・復元・完全削除
5. タブ切替（全件、アーカイブ済み）

**画面遷移**：
- タブナビゲーション: 全件、アーカイブ済み

**権限による表示制御**：
- 削除済みレコードには「編集」アクションが非表示
- 削除済みレコードには「復元」「完全削除」アクションが表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-009 | タグ管理 | 主機能 | タグの作成・編集・削除 |

## 画面種別

管理（ManageRecords）

## URL/ルーティング

- URL: `/contacts/configurations/tags`
- Filament Resource: `TagResource`
- Filament Page: `ManageTags`
- クラスター: Configurations

## 画面構成

1. **ヘッダー**
   - 画面タイトル
   - 作成ボタン（+アイコン付き）

2. **タブ**
   - 全件（All）- レコード件数バッジ付き
   - アーカイブ済み（Archived）- 削除済みレコード件数バッジ付き

3. **タグ一覧テーブル**
   - シンプルな2カラム構成（名前、色）
   - レコードアクション
   - ツールバーアクション（一括操作）

## 入出力項目

### タグフォーム

| 項目名 | 項目種別 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| name | TextInput | string | Yes | タグ名（一意制約） |
| color | ColorPicker | string | No | 表示色（16進数カラー） |

## 表示項目

### タグ一覧テーブル

| 項目名 | データソース | 表示形式 | 説明 |
|--------|--------------|----------|------|
| 名前 | partners_tags.name | テキスト | タグ名（検索可） |
| 色 | partners_tags.color | カラーセル | 設定された表示色 |

## イベント仕様

### 1-タグ作成

**トリガー**: ヘッダーの「作成」ボタンクリック

**処理内容**:
1. タグ作成モーダルを表示
2. フォーム入力を受け付け
3. バリデーション実行（タグ名の一意性確認）
4. creator_id に現在のユーザーIDを設定
5. partners_tags テーブルへINSERT
6. 成功通知を表示

**成功時通知**:
- タイトル: タグ作成成功
- 本文: タグが作成されました

### 2-タグ編集

**トリガー**: レコードの「編集」アクションクリック

**処理内容**:
1. タグ編集モーダルを表示（既存データをプリフィル）
2. フォーム入力の変更を受け付け
3. バリデーション実行
4. partners_tags テーブルをUPDATE
5. 成功通知を表示

**表示条件**: レコードが削除済み（trashed）でない場合のみ表示

**成功時通知**:
- タイトル: タグ更新成功
- 本文: タグが更新されました

### 3-タグ削除

**トリガー**: レコードの「削除」アクションクリック

**処理内容**:
1. 確認ダイアログを表示
2. ソフトデリートを実行
3. 成功通知を表示

**成功時通知**:
- タイトル: タグ削除成功
- 本文: タグが削除されました

### 4-タグ復元

**トリガー**: 削除済みレコードの「復元」アクションクリック

**処理内容**:
1. ソフトデリートを解除
2. 成功通知を表示

**成功時通知**:
- タイトル: タグ復元成功
- 本文: タグが復元されました

### 5-タグ完全削除

**トリガー**: 削除済みレコードの「完全削除」アクションクリック

**処理内容**:
1. 確認ダイアログを表示
2. 物理削除を実行
3. 成功通知を表示

**成功時通知**:
- タイトル: タグ完全削除成功
- 本文: タグが完全に削除されました

### 6-タブ切替

**トリガー**: タブのクリック

**処理内容**:
- 全件: 全タグを表示
- アーカイブ済み: ソフトデリート済みレコードのみ表示（onlyTrashed）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | partners_tags | SELECT | タグ情報の取得 |
| 作成 | partners_tags | INSERT | タグレコードの作成 |
| 編集 | partners_tags | UPDATE | タグレコードの更新 |
| 削除 | partners_tags | UPDATE | deleted_atの更新（ソフトデリート） |
| 復元 | partners_tags | UPDATE | deleted_atのNULL更新 |
| 完全削除 | partners_tags | DELETE | 物理削除 |

### テーブル別更新項目詳細

#### partners_tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | - | |
| INSERT | name | フォーム入力値 | 必須、一意 |
| INSERT | color | フォーム入力値 | 16進数カラー |
| INSERT | creator_id | Auth::id() | 自動設定 |
| UPDATE | name | フォーム入力値 | |
| UPDATE | color | フォーム入力値 | |
| UPDATE（削除） | deleted_at | CURRENT_TIMESTAMP | ソフトデリート |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |
| DELETE | - | WHERE id = {id} | 完全削除 |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|---------------|------|---------------|
| 成功 | 作成成功 | タグが作成されました |
| 成功 | 更新成功 | タグが更新されました |
| 成功 | 削除成功 | タグが削除されました |
| 成功 | 復元成功 | タグが復元されました |
| 成功 | 完全削除成功 | タグが完全に削除されました |
| 成功 | 一括削除成功 | タグが削除されました |
| 成功 | 一括復元成功 | タグが復元されました |
| 成功 | 一括完全削除成功 | タグが完全に削除されました |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| タグ名重複 | バリデーションエラーを表示 |
| 外部キー制約違反（完全削除時） | エラー通知を表示 |

## 備考

- ManageRecords クラスを継承
- Configurations クラスターに属する
- ColorPicker は hexColor フォーマットを使用
- タグはパートナーとの多対多リレーション（partners_partner_tag 中間テーブル）
- シンプルなフォーム構成（名前と色のみ）
- タブにレコード件数がバッジ表示される
- タグ色はパートナー一覧画面でバッジの背景色として使用される
