# 画面設計書 71-敬称管理

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおける敬称管理画面の設計仕様を定義します。

### 本画面の処理概要

敬称管理画面は、連絡先（パートナー）に付与する敬称（Mr.、Ms.、Dr.など）を一元管理するための設定画面です。この画面では敬称の追加、編集、削除を行うことができます。

**業務上の目的・背景**：
パートナー（顧客、仕入先、従業員など）に対して適切な敬称を付与することで、ビジネスコミュニケーションにおける礼儀正しさとプロフェッショナリズムを維持します。各国の文化やビジネス慣習に応じた多様な敬称を管理することが可能です。

**画面へのアクセス方法**：
サイドメニューの「連絡先」モジュール → 「設定」クラスター → 「敬称」を選択してアクセスします。

**主要な操作・処理内容**：
1. 敬称一覧の表示・検索
2. 新規敬称の作成（名前と略称の入力）
3. 既存敬称の編集
4. 敬称の削除
5. 複数敬称の一括削除

**画面遷移**：
- 連絡先モジュールの設定クラスター内で独立した管理画面として動作
- パートナー作成・編集画面から敬称選択時に参照される

**権限による表示制御**：
連絡先モジュールへのアクセス権限を持つユーザーのみがこの画面を操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-010 | 敬称管理 | 主機能 | 敬称の作成/編集/削除 |
| FN-CONT-001 | 連絡先一覧 | 遷移先機能 | パートナー作成時の敬称選択 |

## 画面種別

管理（Manage）

## URL/ルーティング

`/contacts/configurations/titles`

## 画面構成

- ヘッダーアクション: 新規作成ボタン
- データテーブル: 敬称一覧表示
- 行アクション: 編集、削除
- 一括アクション: 一括削除

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 最大長 | 入出力 | 説明 |
|--------|--------|----------|------|--------|--------|------|
| 名前 | name | string | 必須 | 255 | 入力 | 敬称の正式名称（例：Mister） |
| 略称 | short_name | string | 必須 | 255 | 入力 | 敬称の略称（例：Mr.） |
| 作成者ID | creator_id | integer | 自動 | - | 非表示 | 作成者のユーザーID |

## 表示項目

| 項目名 | 物理名 | 表示形式 | ソート | 検索 | 説明 |
|--------|--------|----------|--------|------|------|
| 名前 | name | テキスト | - | 可 | 敬称の正式名称 |
| 略称 | short_name | テキスト | - | 可 | 敬称の略称 |
| 作成日時 | created_at | 日時 | 可 | - | レコード作成日時（デフォルト非表示） |
| 更新日時 | updated_at | 日時 | 可 | - | レコード更新日時（デフォルト非表示） |

## イベント仕様

### 1-新規作成ボタン押下

1. 作成モーダルが表示される
2. 名前と略称を入力
3. 保存ボタンで新規レコードをINSERT
4. 成功通知を表示
5. 一覧を更新

### 2-編集ボタン押下

1. 編集モーダルが表示される
2. 既存データを読み込んで表示
3. 変更後、保存ボタンでUPDATE
4. 成功通知を表示
5. 一覧を更新

### 3-削除ボタン押下

1. 確認ダイアログを表示
2. 確認後、レコードをDELETE
3. 成功通知を表示
4. 一覧を更新

### 4-一括削除

1. 複数レコードを選択
2. 一括削除ボタン押下
3. 確認ダイアログを表示
4. 確認後、選択レコードを一括DELETE
5. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | partners_titles | INSERT | 敬称レコードを新規登録 |
| 編集 | partners_titles | UPDATE | 既存敬称レコードを更新 |
| 削除 | partners_titles | DELETE | 敬称レコードを削除 |
| 一括削除 | partners_titles | DELETE | 選択された複数レコードを削除 |

### テーブル別更新項目詳細

#### partners_titles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | short_name | フォーム入力値 | 必須 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |
| UPDATE | name | フォーム入力値 | - |
| UPDATE | short_name | フォーム入力値 | - |
| UPDATE | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 作成成功時 | 敬称が正常に作成されました |
| MSG-002 | 成功 | 更新成功時 | 敬称が正常に更新されました |
| MSG-003 | 成功 | 削除成功時 | 敬称が正常に削除されました |
| MSG-004 | 成功 | 一括削除成功時 | 選択された敬称が正常に削除されました |
| MSG-005 | エラー | バリデーションエラー | 入力内容を確認してください |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| データが見つからない | 404エラー | 指定された敬称が見つかりません |
| 権限不足 | 403エラー | この操作を行う権限がありません |
| 入力値不正 | バリデーションエラー | 必須項目を入力してください |
| 参照整合性エラー | 削除失敗 | この敬称は使用中のため削除できません |

## 備考

- ManageRecordsページタイプを使用した一覧・編集統合画面
- Filament PHPフレームワークの標準的なリソース管理パターンを採用
- TitleResource（親クラス）を継承しており、実装はパートナーモジュールに集約されている
