# 画面設計書 72-業種管理

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおける業種管理画面の設計仕様を定義します。

### 本画面の処理概要

業種管理画面は、パートナー（顧客・仕入先・取引先）の業種を一元管理するための設定画面です。製造業、IT業、小売業などの業種マスタデータを管理し、パートナー情報に紐付けて使用します。

**業務上の目的・背景**：
パートナーを業種別に分類することで、マーケティング分析、セグメント別の販売戦略策定、業種特化のサービス提供などを効率的に行うことができます。また、業種に応じた請求条件や取引条件の設定にも活用されます。

**画面へのアクセス方法**：
サイドメニューの「連絡先」モジュール → 「設定」クラスター → 「業種」を選択してアクセスします。

**主要な操作・処理内容**：
1. 業種一覧の表示・検索・ソート
2. 新規業種の作成
3. 既存業種の編集
4. 業種の論理削除（ソフトデリート）
5. アーカイブされた業種の復元
6. 業種の完全削除
7. 複数業種の一括操作（削除・復元・完全削除）

**画面遷移**：
- 連絡先モジュールの設定クラスター内で独立した管理画面として動作
- 「すべて」タブと「アーカイブ」タブで表示を切り替え
- パートナー作成・編集画面から業種選択時に参照される

**権限による表示制御**：
連絡先モジュールへのアクセス権限を持つユーザーのみがこの画面を操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-011 | 業種管理 | 主機能 | 業種の作成/編集/削除 |
| FN-CONT-001 | 連絡先一覧 | 遷移先機能 | パートナー作成時の業種選択 |

## 画面種別

管理（Manage）

## URL/ルーティング

`/contacts/configurations/industries`

## 画面構成

- タブ: 「すべて」「アーカイブ」
- ヘッダーアクション: 新規作成ボタン
- データテーブル: 業種一覧表示
- 行アクション: 編集、復元（アーカイブ時）、削除、完全削除（アーカイブ時）
- 一括アクション: 一括復元、一括削除、一括完全削除

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 最大長 | 入出力 | 説明 |
|--------|--------|----------|------|--------|--------|------|
| 名前 | name | string | 必須 | 255 | 入力 | 業種の名称（一意） |
| 説明 | description | string | 必須 | 255 | 入力 | 業種の詳細説明（一意） |
| 作成者ID | creator_id | integer | 自動 | - | 非表示 | 作成者のユーザーID |

## 表示項目

| 項目名 | 物理名 | 表示形式 | ソート | 検索 | 説明 |
|--------|--------|----------|--------|------|------|
| 名前 | name | テキスト | 可 | 可 | 業種の名称 |
| 説明 | description | テキスト | 可 | 可 | 業種の詳細説明 |

## イベント仕様

### 1-タブ切り替え（すべて/アーカイブ）

1. タブをクリック
2. 「すべて」：通常のレコードを表示（論理削除されていないもの）
3. 「アーカイブ」：論理削除されたレコードのみ表示
4. 各タブにレコード件数をバッジで表示

### 2-新規作成ボタン押下

1. 作成モーダルが表示される
2. 名前と説明を入力（ともにユニーク制約）
3. 保存ボタンで新規レコードをINSERT
4. creator_idにログインユーザーIDを自動設定
5. 成功通知を表示
6. 一覧を更新

### 3-編集ボタン押下

1. 編集モーダルが表示される（アーカイブ済みの場合は非表示）
2. 既存データを読み込んで表示
3. 変更後、保存ボタンでUPDATE
4. 成功通知を表示
5. 一覧を更新

### 4-削除ボタン押下

1. 確認ダイアログを表示
2. 確認後、deleted_atに日時をセット（ソフトデリート）
3. 成功通知を表示
4. レコードはアーカイブタブに移動

### 5-復元ボタン押下

1. アーカイブタブで表示される
2. deleted_atをnullに更新
3. 成功通知を表示
4. レコードは「すべて」タブに復帰

### 6-完全削除ボタン押下

1. アーカイブタブで表示される
2. 確認ダイアログを表示
3. 確認後、レコードを物理削除
4. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | partners_industries | INSERT | 業種レコードを新規登録 |
| 編集 | partners_industries | UPDATE | 既存業種レコードを更新 |
| 削除 | partners_industries | UPDATE | deleted_atに日時を設定（ソフトデリート） |
| 復元 | partners_industries | UPDATE | deleted_atをnullに更新 |
| 完全削除 | partners_industries | DELETE | レコードを物理削除 |

### テーブル別更新項目詳細

#### partners_industries

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須、ユニーク |
| INSERT | description | フォーム入力値 | 必須、ユニーク |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |
| UPDATE | name | フォーム入力値 | - |
| UPDATE | description | フォーム入力値 | - |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| SOFT DELETE | deleted_at | 現在日時 | ソフトデリート |
| RESTORE | deleted_at | null | 復元処理 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 作成成功時 | 業種が正常に作成されました |
| MSG-002 | 成功 | 更新成功時 | 業種が正常に更新されました |
| MSG-003 | 成功 | 削除成功時 | 業種が正常に削除されました |
| MSG-004 | 成功 | 復元成功時 | 業種が正常に復元されました |
| MSG-005 | 成功 | 完全削除成功時 | 業種が完全に削除されました |
| MSG-006 | エラー | ユニーク制約違反 | 同じ名前の業種が既に存在します |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| データが見つからない | 404エラー | 指定された業種が見つかりません |
| 権限不足 | 403エラー | この操作を行う権限がありません |
| ユニーク制約違反 | バリデーションエラー | 同じ名前（または説明）の業種が既に存在します |
| 参照整合性エラー | 削除失敗 | この業種は使用中のため削除できません |

## 備考

- SoftDeletesトレイトを使用した論理削除機能を実装
- ManageRecordsページタイプを使用した一覧・編集統合画面
- タブ機能により通常レコードとアーカイブレコードを切り替え可能
- 名前と説明にはユニーク制約が設定されており、重複登録を防止
