# 画面設計書 73-銀行管理

## 概要

本ドキュメントは、Aureus ERPシステムの連絡先モジュールにおける銀行管理画面の設計仕様を定義します。

### 本画面の処理概要

銀行管理画面は、システム内で使用する銀行マスタデータを一元管理するための設定画面です。銀行名、銀行コード、連絡先情報、所在地などを登録・管理し、銀行口座登録時の参照マスタとして使用されます。

**業務上の目的・背景**：
取引先や従業員の銀行口座情報を管理する際に、銀行情報をマスタとして統一管理することで、データの整合性を保ち、入力ミスを防止します。また、銀行別の取引分析や支払処理の効率化に貢献します。

**画面へのアクセス方法**：
サイドメニューの「連絡先」モジュール → 「設定」クラスター → 「銀行」を選択してアクセスします。

**主要な操作・処理内容**：
1. 銀行一覧の表示・検索・ソート・グループ化
2. 新規銀行の登録
3. 既存銀行情報の編集
4. 銀行の論理削除（アーカイブ）
5. アーカイブされた銀行の復元
6. 銀行の完全削除
7. 複数銀行の一括操作

**画面遷移**：
- 連絡先モジュールの設定クラスター内で独立した管理画面として動作
- 「すべて」タブと「アーカイブ」タブで表示を切り替え
- 銀行口座登録画面から銀行選択時に参照される

**権限による表示制御**：
連絡先モジュールへのアクセス権限を持つユーザーのみがこの画面を操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-CONT-012 | 銀行管理 | 主機能 | 銀行の作成/編集/削除 |
| FN-CONT-013 | 銀行口座管理 | 遷移先機能 | 銀行口座作成時の銀行選択 |

## 画面種別

管理（Manage）

## URL/ルーティング

`/contacts/configurations/banks`

## 画面構成

- タブ: 「すべて」「アーカイブ」
- ヘッダーアクション: 新規作成ボタン
- データテーブル: 銀行一覧表示（グループ化可能）
- 行アクション: 編集、復元、削除、完全削除
- 一括アクション: 一括復元、一括削除、一括完全削除

## 入出力項目

### 基本情報セクション

| 項目名 | 物理名 | データ型 | 必須 | 最大長 | 入出力 | 説明 |
|--------|--------|----------|------|--------|--------|------|
| 銀行名 | name | string | 必須 | 255 | 入力 | 銀行の正式名称 |
| 銀行コード | code | string | - | 255 | 入力 | 金融機関コード |
| メールアドレス | email | string | - | 255 | 入力 | 銀行の連絡先メール |
| 電話番号 | phone | string | - | 255 | 入力 | 銀行の連絡先電話番号 |

### 住所情報セクション

| 項目名 | 物理名 | データ型 | 必須 | 最大長 | 入出力 | 説明 |
|--------|--------|----------|------|--------|--------|------|
| 国 | country_id | integer | - | - | 入力 | 国（リレーション） |
| 都道府県/州 | state_id | integer | - | - | 入力 | 都道府県/州（国に連動） |
| 住所1 | street1 | string | - | 255 | 入力 | 住所（番地等） |
| 住所2 | street2 | string | - | 255 | 入力 | 住所（建物名等） |
| 市区町村 | city | string | - | 255 | 入力 | 市区町村名 |
| 郵便番号 | zip | string | - | 255 | 入力 | 郵便番号 |
| 作成者ID | creator_id | integer | 自動 | - | 非表示 | 作成者のユーザーID |

## 表示項目

| 項目名 | 物理名 | 表示形式 | ソート | 検索 | 説明 |
|--------|--------|----------|--------|------|------|
| 銀行名 | name | テキスト | 可 | 可 | 銀行の正式名称 |
| 銀行コード | code | テキスト | 可 | 可 | 金融機関コード |
| 国 | country.name | テキスト | 可 | - | 所在国名 |
| 削除日時 | deleted_at | 日時 | 可 | - | 論理削除日時（デフォルト非表示） |
| 作成日時 | created_at | 日時 | 可 | - | レコード作成日時（デフォルト非表示） |
| 更新日時 | updated_at | 日時 | 可 | - | レコード更新日時（デフォルト非表示） |

## イベント仕様

### 1-タブ切り替え（すべて/アーカイブ）

1. タブをクリック
2. 「すべて」：通常のレコードを表示
3. 「アーカイブ」：論理削除されたレコードのみ表示
4. 各タブにレコード件数をバッジで表示

### 2-新規作成ボタン押下

1. 作成モーダルが表示される（2セクション構成）
2. 基本情報と住所情報を入力
3. 国を選択すると、都道府県/州の選択肢が連動して変更
4. 保存ボタンで新規レコードをINSERT
5. 成功通知を表示

### 3-編集ボタン押下

1. 編集モーダルが表示される（アーカイブ済みの場合は非表示）
2. 既存データを読み込んで表示
3. 変更後、保存ボタンでUPDATE
4. 成功通知を表示

### 4-削除ボタン押下

1. 確認ダイアログを表示
2. 確認後、ソフトデリート実行
3. 成功通知を表示

### 5-復元ボタン押下

1. アーカイブタブで表示される
2. レコードを復元
3. 成功通知を表示

### 6-完全削除ボタン押下

1. アーカイブタブで表示される
2. 確認ダイアログを表示
3. 確認後、物理削除を実行
4. 成功通知を表示

### 7-グループ化

1. 国別または作成日別でグループ化可能
2. グループ化時、各グループは折りたたみ可能

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | banks | INSERT | 銀行レコードを新規登録 |
| 編集 | banks | UPDATE | 既存銀行レコードを更新 |
| 削除 | banks | UPDATE | deleted_atに日時を設定 |
| 復元 | banks | UPDATE | deleted_atをnullに更新 |
| 完全削除 | banks | DELETE | レコードを物理削除 |

### テーブル別更新項目詳細

#### banks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | code | フォーム入力値 | 任意 |
| INSERT | email | フォーム入力値 | 任意 |
| INSERT | phone | フォーム入力値 | 任意 |
| INSERT | country_id | 選択した国のID | 任意 |
| INSERT | state_id | 選択した州/県のID | 任意 |
| INSERT | street1 | フォーム入力値 | 任意 |
| INSERT | street2 | フォーム入力値 | 任意 |
| INSERT | city | フォーム入力値 | 任意 |
| INSERT | zip | フォーム入力値 | 任意 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |
| SOFT DELETE | deleted_at | 現在日時 | ソフトデリート |
| RESTORE | deleted_at | null | 復元処理 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 作成成功時 | 銀行が正常に作成されました |
| MSG-002 | 成功 | 更新成功時 | 銀行が正常に更新されました |
| MSG-003 | 成功 | 削除成功時 | 銀行が正常に削除されました |
| MSG-004 | 成功 | 復元成功時 | 銀行が正常に復元されました |
| MSG-005 | 成功 | 完全削除成功時 | 銀行が完全に削除されました |
| MSG-006 | エラー | バリデーションエラー | 必須項目を入力してください |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| データが見つからない | 404エラー | 指定された銀行が見つかりません |
| 権限不足 | 403エラー | この操作を行う権限がありません |
| 入力値不正 | バリデーションエラー | 必須項目を入力してください |
| 参照整合性エラー | 削除失敗 | この銀行は銀行口座で使用中のため削除できません |

## 備考

- SoftDeletesトレイトを使用した論理削除機能を実装
- フォームは「基本情報」と「住所情報」の2セクションに分割（各2カラム表示）
- 国と都道府県/州はカスケード選択（国を選択すると州の選択肢が絞り込まれる）
- グループ化機能により、国別・作成日別での一覧表示が可能
- BankResourceはSupportモジュールのBankモデルを使用
