# 画面設計書 74-従業員一覧

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける従業員一覧画面の設計仕様を定義します。

### 本画面の処理概要

従業員一覧画面は、組織に所属する従業員情報を一覧表示・検索・フィルタリングするための画面です。カード形式のグリッドレイアウトで従業員情報を視覚的に表示し、詳細画面・編集画面への導線を提供します。

**業務上の目的・背景**：
人事管理における従業員データの閲覧・検索を効率化し、部署別・スキル別・役職別など多角的な視点から従業員を把握できるようにします。組織図の把握、人員配置の検討、連絡先の確認など、日常的な人事業務を支援します。

**画面へのアクセス方法**：
サイドメニューの「従業員」モジュール → 「従業員」を選択してアクセスします。

**主要な操作・処理内容**：
1. 従業員のカード形式一覧表示
2. 多様な条件でのフィルタリング・検索
3. グループ化表示（部署別、マネージャー別、コーチ別等）
4. 従業員の新規作成、詳細表示、編集、削除
5. 論理削除された従業員の復元
6. 複数従業員の一括削除

**画面遷移**：
- 新規作成 → 従業員作成画面
- 詳細表示 → 従業員詳細画面
- 編集 → 従業員編集画面
- テーブルビューを保存した「アーカイブ」ビューで削除済み従業員を表示可能

**権限による表示制御**：
従業員モジュールへのアクセス権限を持つユーザーのみがこの画面を操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-001 | 従業員管理 | 主機能 | 従業員の一覧表示・検索・削除 |
| FN-EMP-002 | 従業員作成 | 遷移先機能 | 新規従業員の作成 |
| FN-EMP-003 | 従業員詳細 | 遷移先機能 | 従業員詳細の表示 |
| FN-EMP-004 | 従業員編集 | 遷移先機能 | 従業員情報の編集 |

## 画面種別

一覧（List）

## URL/ルーティング

`/employees/employees`

## 画面構成

- ヘッダーアクション: 新規作成ボタン
- カードグリッド: 従業員カード一覧（2列〜4列レスポンシブ）
- フィルター: 高度なフィルタリング機能（スキル、履歴書、タイムゾーン、QueryBuilder）
- グループ化: 複数の条件でグループ化可能
- ページネーション: 18, 36, 72, 全件表示

## 表示項目（カード形式）

| 項目名 | 物理名 | 表示形式 | 表示条件 | 説明 |
|--------|--------|----------|---------|------|
| アバター | partner.avatar | 画像 | 常時 | 従業員の顔写真 |
| 氏名 | name | テキスト（太字） | 常時 | 従業員名 |
| 役職 | job_title | テキスト+アイコン | 値がある場合 | 役職名 |
| メールアドレス | work_email | テキスト+アイコン | 値がある場合 | 業務メールアドレス |
| 電話番号 | work_phone | テキスト+アイコン | 値がある場合 | 業務電話番号 |
| タグ | categories.name | バッジ | タグがある場合 | 従業員カテゴリタグ |

## フィルター項目

### セレクトフィルター

| 項目名 | 物理名 | フィルター種別 | 説明 |
|--------|--------|--------------|------|
| スキル | skills | リレーション | スキルでフィルタ |
| 履歴書 | resumes | リレーション | 履歴書種別でフィルタ |
| タイムゾーン | time_zone | セレクト | タイムゾーンでフィルタ |

### QueryBuilderフィルター

以下の項目でクエリビルダーによる詳細フィルタリングが可能：

- テキスト: 役職, 業務メール, 携帯電話, 業務電話, 緊急連絡先名, 緊急連絡先電話, プライベート電話, プライベートメール, 車のナンバー, 婚姻状況, 配偶者名, 学歴, 専攻, 学校名, 身分証明書ID, SSN, SIN, パスポートID, 性別, ビザ番号, 就労許可証番号, 言語, 追加メモ, ノート, バーコード
- 日付: 生年月日, 配偶者誕生日, ビザ有効期限, 就労許可証有効期限, 退職日, 作成日時, 更新日時
- 数値: 子供の数, 通勤距離
- リレーション: 会社, 作成者, カレンダー, 部署, 職種, パートナー, 休暇承認者, 勤怠管理者, 勤務地, マネージャー, コーチ, 州/県, 国, 出生国, 銀行口座, 退職理由, 雇用形態, タグ

## グループ化項目

| グループ名 | 物理名 | 説明 |
|-----------|--------|------|
| 氏名 | name | 氏名でグループ化 |
| 会社 | company.name | 会社でグループ化 |
| マネージャー | parent.name | マネージャーでグループ化 |
| コーチ | coach.name | コーチでグループ化 |
| 部署 | department.complete_name | 部署でグループ化 |
| 雇用形態 | employmentType.name | 雇用形態でグループ化 |
| タグ | categories.name | タグでグループ化 |
| 退職理由 | departureReason.name | 退職理由でグループ化 |
| 州/県（プライベート） | privateState.name | プライベート住所の州でグループ化 |
| 国（プライベート） | privateCountry.name | プライベート住所の国でグループ化 |
| 国 | country.name | 国籍でグループ化 |
| 州 | state.name | 州でグループ化 |
| 作成日 | created_at | 作成日でグループ化 |
| 更新日 | updated_at | 更新日でグループ化 |

## イベント仕様

### 1-新規作成ボタン押下

1. 従業員作成画面へ遷移
2. フォームに必要事項を入力
3. 保存後、従業員詳細画面へリダイレクト

### 2-詳細表示ボタン押下

1. 選択した従業員の詳細画面へ遷移
2. 全ての従業員情報をInfolist形式で表示

### 3-編集ボタン押下

1. 選択した従業員の編集画面へ遷移
2. フォームで情報を編集
3. 保存後、従業員詳細画面へリダイレクト

### 4-削除ボタン押下

1. 確認ダイアログを表示
2. 確認後、論理削除（ソフトデリート）を実行
3. 成功通知を表示

### 5-復元ボタン押下

1. アーカイブビューで表示
2. 論理削除を取り消し
3. 成功通知を表示

### 6-一括削除

1. 複数の従業員カードを選択
2. 一括削除ボタンを押下
3. 確認後、選択従業員を論理削除
4. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | employees_employees | UPDATE | deleted_atに日時を設定 |
| 復元 | employees_employees | UPDATE | deleted_atをnullに更新 |
| 一括削除 | employees_employees | UPDATE | 複数レコードのdeleted_atに日時を設定 |
| 完全削除 | employees_employees | DELETE | レコードを物理削除 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 削除成功時 | 従業員が正常に削除されました |
| MSG-002 | 成功 | 復元成功時 | 従業員が正常に復元されました |
| MSG-003 | 成功 | 一括削除成功時 | 選択された従業員が正常に削除されました |
| MSG-004 | エラー | 削除失敗時 | 削除中にエラーが発生しました |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| データが見つからない | 404エラー | 指定された従業員が見つかりません |
| 権限不足 | 403エラー | この操作を行う権限がありません |
| 参照整合性エラー | 削除失敗 | この従業員は他のデータで参照されているため削除できません |
| データベースエラー | 例外キャッチ | 削除中にエラーが発生しました |

## 備考

- ListRecordsページタイプを使用
- HasTableViewsトレイトによりテーブルビューの保存・切り替えが可能
- カードグリッドレイアウト（md: 2列、xl: 4列）
- SoftDeletesによる論理削除を採用
- グローバル検索対応（name, department.name, work_email, work_phone）
- ページネーションはセッションに保持
- ソートはデフォルトで氏名順
