# 画面設計書 75-従業員作成

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける従業員作成画面の設計仕様を定義します。

### 本画面の処理概要

従業員作成画面は、新規従業員の情報を登録するための入力フォーム画面です。基本情報、勤務情報、個人情報、設定情報など包括的な従業員データを3つのタブに分けて入力できます。

**業務上の目的・背景**：
新入社員の入社処理、中途採用者の登録など、人事部門による従業員データの初期登録を効率的に行います。入力項目は人事管理に必要な情報を網羅しており、後続の勤怠管理、給与計算、組織管理などの業務に連携します。

**画面へのアクセス方法**：
1. サイドメニューの「従業員」モジュール → 「従業員」 → 一覧画面の「新規作成」ボタン
2. 直接URL: `/employees/employees/create`

**主要な操作・処理内容**：
1. 基本情報の入力（氏名、役職、連絡先、部署、マネージャー等）
2. 勤務情報の入力（勤務地、勤務時間、承認者等）
3. 個人情報の入力（住所、家族構成、学歴、国籍、就労許可等）
4. 設定情報の入力（有効/無効フラグ、関連ユーザー、退職情報等）
5. アバター画像のアップロード

**画面遷移**：
- 保存成功後 → 作成した従業員の詳細画面へ自動遷移
- キャンセル → 従業員一覧画面へ戻る

**権限による表示制御**：
従業員モジュールへの書き込み権限を持つユーザーのみがこの画面を操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-002 | 従業員作成 | 主機能 | 従業員の新規登録 |
| FN-EMP-001 | 従業員一覧 | 遷移元機能 | 一覧からの遷移 |
| FN-EMP-003 | 従業員詳細 | 遷移先機能 | 作成後の遷移先 |

## 画面種別

作成（Create）

## URL/ルーティング

`/employees/employees/create`

## 画面構成

- ヘッダーセクション: 基本情報（氏名、役職、アバター）
- 連絡先・所属セクション: 2列グリッドでの入力項目
- タブセクション:
  - 勤務情報タブ（Work Information）
  - 個人情報タブ（Private Information）
  - 設定タブ（Settings）

## 入出力項目

### ヘッダーセクション

| 項目名 | 物理名 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| 氏名 | name | string | 必須 | 255 | 従業員の氏名 |
| 役職名 | job_title | string | - | 255 | 役職・肩書き |
| アバター | avatar | file | - | - | プロフィール画像 |

### 連絡先・所属セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 業務メール | work_email | email | - | 業務用メールアドレス |
| 部署 | department_id | select | - | 所属部署（リレーション） |
| 携帯電話 | mobile_phone | tel | - | 携帯電話番号 |
| 職種 | job_id | select | - | 職種（リレーション） |
| 業務電話 | work_phone | tel | - | 業務用電話番号 |
| マネージャー | parent_id | select | - | 上司（自己参照） |
| 従業員タグ | categories | multi-select | - | カテゴリタグ |
| コーチ | coach_id | select | - | コーチ（自己参照） |

### 勤務情報タブ

#### 場所セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 勤務先住所 | address_id | select | - | 会社住所（リレーション） |
| 勤務地 | work_location_id | select | - | 勤務地（リレーション） |

#### 承認者セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 休暇承認者 | leave_manager_id | select | - | 休暇申請の承認者（ユーザー） |
| 勤怠管理者 | attendance_manager_id | select | - | 勤怠の承認者（ユーザー） |

#### スケジュールセクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 勤務時間 | calendar_id | select | - | 勤務カレンダー |
| タイムゾーン | time_zone | select | - | タイムゾーン |

#### 組織詳細セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 会社 | company_id | select | - | 所属会社（リレーション） |
| 色 | color | color | - | 表示色（16進数） |

### 個人情報タブ

#### 連絡先セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 住所1 | private_street1 | string | - | プライベート住所1 |
| 住所2 | private_street2 | string | - | プライベート住所2 |
| 市区町村 | private_city | string | - | 市区町村 |
| 郵便番号 | private_zip | string | - | 郵便番号 |
| 国 | private_country_id | select | - | 国（リレーション） |
| 都道府県/州 | private_state_id | select | - | 都道府県/州（国に連動） |
| プライベート電話 | private_phone | tel | - | 個人電話番号 |
| 銀行口座 | bank_account_id | select | - | 銀行口座（リレーション） |
| プライベートメール | private_email | email | - | 個人メールアドレス |
| 車のナンバー | private_car_plate | string | - | 自家用車ナンバー |
| 通勤距離 | distance_home_work | number | - | 通勤距離 |
| 通勤距離(km) | km_home_work | number | - | 通勤距離（km） |
| 距離単位 | distance_home_work_unit | select | - | 距離単位 |

#### 緊急連絡先セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 緊急連絡先名 | emergency_contact | string | - | 緊急連絡先の名前 |
| 緊急連絡先電話 | emergency_phone | tel | - | 緊急連絡先の電話番号 |

#### 家族状況セクション

| 項目名 | 物理名 | データ型 | 必須 | 条件付き必須 | 説明 |
|--------|--------|----------|------|------------|------|
| 婚姻状況 | marital | select | - | - | 婚姻状況（独身/既婚等） |
| 配偶者名 | spouse_complete_name | string | - | 既婚時必須 | 配偶者のフルネーム |
| 配偶者誕生日 | spouse_birthdate | date | - | 既婚時表示 | 配偶者の生年月日 |
| 子供の数 | children | number | - | 既婚時表示 | 子供の人数 |

#### 学歴セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 学歴レベル | certificate | select | - | 学歴（学士/修士/博士等） |
| 専攻 | study_field | string | - | 専攻分野 |
| 学校名 | study_school | string | - | 出身校 |

#### 国籍セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 国籍 | country_id | select | - | 国籍（リレーション） |
| 州 | state_id | select | - | 州（国に連動、条件付き必須） |
| 身分証明書ID | identification_id | string | - | 身分証明書番号 |
| SSN | ssnid | string | - | 社会保障番号 |
| SIN | sinid | string | - | 社会保険番号 |
| パスポートID | passport_id | string | - | パスポート番号 |
| 性別 | gender | select | - | 性別 |
| 生年月日 | birthday | date | - | 生年月日（現在日以前） |
| 出生国 | country_of_birth | select | - | 出生国（リレーション） |

#### 就労許可セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| ビザ番号 | visa_no | string | - | ビザ番号 |
| 就労許可証番号 | permit_no | string | - | 就労許可証番号 |
| ビザ有効期限 | visa_expire | date | - | ビザの有効期限 |
| 就労許可証有効期限 | work_permit_expiration_date | date | - | 就労許可証の有効期限 |
| 就労許可証ファイル | work_permit | file | - | 就労許可証のアップロード |

### 設定タブ

#### 雇用状況セクション

| 項目名 | 物理名 | データ型 | 必須 | デフォルト | 説明 |
|--------|--------|----------|------|----------|------|
| 有効従業員 | is_active | toggle | - | true | 有効/無効フラグ |
| フレキシブル勤務 | is_flexible | toggle | - | false | フレキシブル勤務可否 |
| 完全フレキシブル | is_fully_flexible | toggle | - | false | 完全フレキシブル可否 |
| 就労許可アクティビティ | work_permit_scheduled_activity | toggle | - | false | 就労許可関連のスケジュールアクティビティ |
| 関連ユーザー | user_id | select | - | - | システムユーザー（リレーション） |
| 退職理由 | departure_reason_id | select | - | - | 退職理由（リレーション） |
| 退職日 | departure_date | date | - | - | 退職日（退職理由選択時必須） |
| 退職説明 | departure_description | textarea | - | - | 退職理由の詳細説明 |

#### 追加情報セクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 主要言語 | lang | string | - | 主要使用言語 |
| 追加メモ | additional_note | textarea | - | 追加のメモ |
| ノート | notes | textarea | - | その他ノート |

#### 勤怠・POSセクション

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| バッジID | barcode | string | - | バッジ用バーコード（自動生成可） |
| PIN | pin | string | - | 勤怠打刻用PIN |

## イベント仕様

### 1-フォーム送信

1. 入力内容のバリデーション
2. 従業員レコードをINSERT
3. creator_idにログインユーザーIDを自動設定
4. 関連するPartnerレコードを自動作成（従業員名・メール・電話等を同期）
5. 成功通知を表示
6. 作成した従業員の詳細画面へリダイレクト

### 2-部署選択

1. 部署セレクトボックスで選択
2. 論理削除された部署は「(Deleted)」ラベルで表示され、選択不可

### 3-国選択（住所）

1. 国を選択
2. 都道府県/州の選択肢が選択した国に連動して更新
3. 国に「州必須」設定がある場合、州フィールドが必須に

### 4-婚姻状況変更

1. 婚姻状況を「独身」以外に変更
2. 配偶者名、配偶者誕生日、子供の数フィールドが表示
3. 配偶者名が必須に

### 5-退職理由選択

1. 退職理由を選択
2. 退職日、退職説明フィールドが表示・必須に

### 6-バーコード自動生成

1. バーコードフィールド横の生成ボタンをクリック
2. 8桁のランダムな16進数バーコードを生成

### 7-関連ユーザー作成

1. ユーザー選択のインラインフォームから新規作成
2. 氏名と業務メールが自動入力される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 従業員作成 | employees_employees | INSERT | 従業員レコードを新規登録 |
| 従業員作成 | partners | INSERT | 連携するパートナーレコードを自動作成 |
| 従業員作成 | employees_employee_categories | INSERT | タグ関連付けを登録 |

### テーブル別更新項目詳細

#### employees_employees

| 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----------------|-----------------|------|
| name | フォーム入力値 | 必須 |
| job_title | フォーム入力値 | - |
| work_email | フォーム入力値 | - |
| mobile_phone | フォーム入力値 | - |
| work_phone | フォーム入力値 | - |
| department_id | 選択した部署ID | - |
| job_id | 選択した職種ID | - |
| parent_id | 選択したマネージャーID | - |
| coach_id | 選択したコーチID | - |
| company_id | 選択した会社ID | - |
| creator_id | ログインユーザーID | 自動設定 |
| partner_id | 作成されたパートナーID | 自動関連付け |
| （その他全フィールド） | フォーム入力値 | - |

#### partners（自動作成）

| 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----------------|-----------------|------|
| account_type | 'individual' | 固定値 |
| sub_type | 'employee' | 固定値 |
| name | 従業員名 | 同期 |
| email | work_email または private_email | 同期 |
| job_title | 従業員の役職 | 同期 |
| phone | work_phone | 同期 |
| mobile | mobile_phone | 同期 |
| color | 従業員の色 | 同期 |
| company_id | 従業員の会社ID | 同期 |
| user_id | 従業員の関連ユーザーID | 同期 |
| creator_id | ログインユーザーID | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 作成成功時 | 従業員が正常に作成されました |
| MSG-002 | エラー | バリデーションエラー | 入力内容を確認してください |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| 権限不足 | 403エラー | この操作を行う権限がありません |
| 入力値不正 | バリデーションエラー | 必須項目を入力してください |
| 重複エラー | 作成失敗 | 同じメールアドレスの従業員が既に存在します |
| データベースエラー | 例外キャッチ | 作成中にエラーが発生しました |

## 備考

- CreateRecordページタイプを使用
- 保存後は自動的に詳細画面へリダイレクト（getRedirectUrl）
- 従業員保存時にPartnerレコードが自動作成される（Modelのbootメソッド）
- タブ状態はURLクエリパラメータに保持される（persistTabInQueryString）
- フォームレイアウトは3列グリッド（lg: 3）
- 各フィールドにはヒントアイコンやアクションボタンが設定されている
