# 画面設計書 76-従業員編集

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける従業員編集画面の設計仕様を定義します。

### 本画面の処理概要

従業員編集画面は、既存の従業員情報を更新するための入力フォーム画面です。従業員作成画面と同じフォーム構成を持ち、既存データの読み込み・編集・保存を行います。

**業務上の目的・背景**：
従業員の異動、昇進、連絡先変更、退職処理など、従業員情報の変更が発生した際に迅速かつ正確に情報を更新します。変更履歴はChatterアクティビティとして記録され、監査証跡を残します。

**画面へのアクセス方法**：
1. 従業員一覧画面 → 対象従業員の「編集」ボタン
2. 従業員詳細画面 → サブナビゲーションの「編集」リンク
3. 直接URL: `/employees/employees/{record}/edit`

**主要な操作・処理内容**：
1. 既存従業員データの読み込み・表示
2. 各種情報の編集（基本情報、勤務情報、個人情報、設定）
3. Chatterアクション（メッセージ、アクティビティ、フォロワー管理）
4. 従業員の削除

**画面遷移**：
- 保存成功後 → 従業員詳細画面へ自動遷移
- 削除後 → 従業員一覧画面へ遷移
- キャンセル → 従業員詳細画面へ戻る

**権限による表示制御**：
従業員モジュールへの書き込み権限を持つユーザーのみがこの画面を操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-004 | 従業員編集 | 主機能 | 従業員情報の編集 |
| FN-EMP-001 | 従業員一覧 | 遷移元機能 | 一覧からの遷移 |
| FN-EMP-003 | 従業員詳細 | 遷移元/遷移先機能 | 詳細からの遷移・保存後の遷移先 |

## 画面種別

編集（Edit）

## URL/ルーティング

`/employees/employees/{record}/edit`

## 画面構成

- サブナビゲーション: 詳細/編集/履歴書/スキルの切り替え
- ヘッダーアクション: Chatterアクション、削除ボタン
- ヘッダーセクション: 基本情報（氏名、役職、アバター）
- 連絡先・所属セクション: 2列グリッドでの入力項目
- タブセクション:
  - 勤務情報タブ（Work Information）
  - 個人情報タブ（Private Information）
  - 設定タブ（Settings）

## 入出力項目

従業員作成画面（No.75）と同一のフォーム構成を持ちます。詳細は従業員作成画面の設計書を参照してください。

### データ読み込み時の特殊処理

既存データ読み込み時に以下の処理が実行されます：

| 処理 | 説明 |
|------|------|
| パートナー情報のマージ | 関連するPartnerレコードの情報をフォームにマージ |
| アバター表示 | partner.avatarから既存画像を表示 |

## イベント仕様

### 1-フォーム読み込み

1. 従業員レコードを取得
2. 関連するPartnerレコードの情報をマージ（mutateFormDataBeforeFill）
3. フォームに既存データを表示

### 2-フォーム送信

1. 入力内容のバリデーション
2. creator_idをログインユーザーIDで更新
3. 従業員レコードをUPDATE
4. 関連するPartnerレコードを自動更新（updateOrCreate）
5. 成功通知を表示
6. 従業員詳細画面へリダイレクト

### 3-Chatterアクション押下

1. Chatterパネルが開く
2. メッセージ送信、アクティビティ登録、フォロワー管理が可能
3. アクティビティプランは「employees」プラグインに関連するプランが表示

### 4-削除ボタン押下

1. 確認ダイアログを表示
2. 確認後、従業員レコードを論理削除
3. 成功通知を表示
4. 従業員一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 従業員更新 | employees_employees | UPDATE | 従業員レコードを更新 |
| 従業員更新 | partners | UPDATE | 連携するパートナーレコードを自動更新 |
| 従業員更新 | employees_employee_categories | DELETE/INSERT | タグ関連付けを再設定 |
| 従業員削除 | employees_employees | UPDATE | deleted_atに日時を設定 |

### テーブル別更新項目詳細

#### employees_employees

| 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----------------|-----------------|------|
| 全フィールド | フォーム入力値 | 従業員作成画面と同様 |
| creator_id | ログインユーザーID | 更新時に上書き |
| updated_at | 現在日時 | 自動設定 |

#### partners（自動更新）

| 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----------------|-----------------|------|
| name | 従業員名 | 同期 |
| email | work_email または private_email | 同期 |
| job_title | 従業員の役職 | 同期 |
| phone | work_phone | 同期 |
| mobile | mobile_phone | 同期 |
| color | 従業員の色 | 同期 |
| company_id | 従業員の会社ID | 同期 |
| user_id | 従業員の関連ユーザーID | 同期 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 更新成功時 | 従業員が正常に更新されました |
| MSG-002 | 成功 | 削除成功時 | 従業員が正常に削除されました |
| MSG-003 | エラー | バリデーションエラー | 入力内容を確認してください |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| データが見つからない | 404エラー | 指定された従業員が見つかりません |
| 権限不足 | 403エラー | この操作を行う権限がありません |
| 入力値不正 | バリデーションエラー | 必須項目を入力してください |
| 楽観的ロック競合 | 更新失敗 | 他のユーザーが同時に更新しました |

## 備考

- EditRecordページタイプを使用
- サブナビゲーションポジションはTop（SubNavigationPosition::Top）
- 保存後は自動的に詳細画面へリダイレクト（getRedirectUrl）
- mutateFormDataBeforeFillでパートナー情報をフォームにマージ
- mutateFormDataBeforeSaveでcreator_idを更新
- Chatterトレイト（HasChatter）により変更履歴・アクティビティ管理を提供
- アクティビティプランはActivityPlanモデルから取得（plugin='employees'）
