# 画面設計書 77-従業員詳細

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける従業員詳細画面の設計仕様を定義します。

### 本画面の処理概要

従業員詳細画面は、従業員の全情報を閲覧するための読み取り専用画面です。Infolist形式で構造化された情報を表示し、関連する履歴書やスキル情報へのナビゲーションを提供します。

**業務上の目的・背景**：
従業員情報の確認・参照を目的とした画面です。人事担当者、マネージャー、同僚など様々なユーザーが従業員情報を閲覧する際に使用します。編集権限がないユーザーでも情報を参照できます。

**画面へのアクセス方法**：
1. 従業員一覧画面 → 対象従業員の「詳細」ボタン
2. 従業員カードをクリック
3. 直接URL: `/employees/employees/{record}`

**主要な操作・処理内容**：
1. 従業員の基本情報表示
2. 勤務情報・個人情報・設定情報のタブ切り替え表示
3. Chatterアクション（メッセージ、アクティビティ、フォロワー管理）
4. 従業員の削除
5. サブナビゲーションによる関連画面への遷移

**画面遷移**：
- サブナビゲーション「編集」 → 従業員編集画面
- サブナビゲーション「履歴書」 → 履歴書管理画面
- サブナビゲーション「スキル」 → スキル管理画面
- 削除後 → 従業員一覧画面

**権限による表示制御**：
従業員モジュールへの読み取り権限を持つユーザーがこの画面を閲覧できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-003 | 従業員詳細 | 主機能 | 従業員情報の表示 |
| FN-EMP-001 | 従業員一覧 | 遷移元機能 | 一覧からの遷移 |
| FN-EMP-004 | 従業員編集 | 遷移先機能 | 編集画面への遷移 |
| FN-EMP-005 | 履歴書管理 | 遷移先機能 | 履歴書画面への遷移 |
| FN-EMP-006 | スキル管理 | 遷移先機能 | スキル画面への遷移 |

## 画面種別

詳細（View）

## URL/ルーティング

`/employees/employees/{record}`

## 画面構成

- サブナビゲーション: 詳細/編集/履歴書/スキルの切り替え
- ヘッダーアクション: Chatterアクション、削除ボタン
- ヘッダーセクション: 基本情報（氏名、役職、アバター）
- 連絡先・所属セクション: 2列グリッドでの情報表示
- タブセクション:
  - 勤務情報タブ（Work Information）
  - 個人情報タブ（Private Information）
  - 設定タブ（Settings）

## 表示項目

### ヘッダーセクション

| 項目名 | 物理名 | 表示形式 | 説明 |
|--------|--------|----------|------|
| 氏名 | name | テキスト（太字・大） | 従業員の氏名 |
| 役職名 | job_title | テキスト | 役職・肩書き |
| アバター | partner.avatar | 画像（円形） | プロフィール画像 |

### 連絡先・所属セクション

| 項目名 | 物理名 | 表示形式 | 説明 |
|--------|--------|----------|------|
| 業務メール | work_email | テキスト+アイコン（リンク） | クリックでメール送信 |
| 部署 | department.complete_name | テキスト | 所属部署（完全パス表示） |
| 携帯電話 | mobile_phone | テキスト+アイコン（リンク） | クリックで電話発信 |
| 職種 | job.name | テキスト | 職種名 |
| 業務電話 | work_phone | テキスト+アイコン（リンク） | クリックで電話発信 |
| マネージャー | parent.name | テキスト | 上司名 |
| 従業員タグ | categories.name | バッジ（色付き） | カテゴリタグ |
| コーチ | coach.name | テキスト | コーチ名 |

### 勤務情報タブ

| 項目名 | 物理名 | 表示形式 | 説明 |
|--------|--------|----------|------|
| 勤務先住所 | companyAddress.name | テキスト+アイコン | 会社住所 |
| 勤務地 | workLocation.name | テキスト+アイコン | 勤務地 |
| 休暇承認者 | leaveManager.name | テキスト | 休暇申請の承認者 |
| 勤怠管理者 | attendanceManager.name | テキスト | 勤怠の承認者 |
| 勤務時間 | calendar.name | テキスト | 勤務カレンダー |
| タイムゾーン | time_zone | テキスト | タイムゾーン |
| 会社 | company.name | テキスト+アイコン | 所属会社 |
| 色 | color | カラー表示 | 表示色 |

### 個人情報タブ

| 項目名 | 物理名 | 表示形式 | 説明 |
|--------|--------|----------|------|
| 住所 | private_street1, private_street2, private_city, private_zip | テキスト | プライベート住所 |
| 国 | privateCountry.name | テキスト | 国 |
| 都道府県/州 | privateState.name | テキスト | 都道府県/州 |
| プライベート電話 | private_phone | テキスト+アイコン（リンク） | 個人電話番号 |
| 銀行口座 | bankAccount.account_number | テキスト | 銀行口座 |
| プライベートメール | private_email | テキスト+アイコン（リンク） | 個人メールアドレス |
| 車のナンバー | private_car_plate | テキスト | 自家用車ナンバー |
| 通勤距離 | distance_home_work | テキスト | 通勤距離 |
| 緊急連絡先名 | emergency_contact | テキスト | 緊急連絡先の名前 |
| 緊急連絡先電話 | emergency_phone | テキスト+アイコン（リンク） | 緊急連絡先の電話番号 |
| 婚姻状況 | marital | テキスト | 婚姻状況 |
| 配偶者名 | spouse_complete_name | テキスト | 配偶者名 |
| 配偶者誕生日 | spouse_birthdate | 日付 | 配偶者の生年月日 |
| 子供の数 | children | 数値 | 子供の人数 |
| 学歴レベル | certificate | テキスト | 学歴 |
| 専攻 | study_field | テキスト | 専攻分野 |
| 学校名 | study_school | テキスト | 出身校 |
| 国籍 | country.name | テキスト | 国籍 |
| 州 | state.name | テキスト | 州 |
| 身分証明書ID | identification_id | テキスト | 身分証明書番号 |
| パスポートID | passport_id | テキスト | パスポート番号 |
| 性別 | gender | テキスト | 性別 |
| 生年月日 | birthday | 日付 | 生年月日 |
| 出生国 | countryOfBirth.name | テキスト | 出生国 |
| ビザ番号 | visa_no | テキスト | ビザ番号 |
| 就労許可証番号 | permit_no | テキスト | 就労許可証番号 |
| ビザ有効期限 | visa_expire | 日付 | ビザの有効期限 |
| 就労許可証有効期限 | work_permit_expiration_date | 日付 | 就労許可証の有効期限 |

### 設定タブ

| 項目名 | 物理名 | 表示形式 | 説明 |
|--------|--------|----------|------|
| 有効従業員 | is_active | アイコン | 有効/無効フラグ |
| フレキシブル勤務 | is_flexible | アイコン | フレキシブル勤務可否 |
| 完全フレキシブル | is_fully_flexible | アイコン | 完全フレキシブル可否 |
| 関連ユーザー | user.name | テキスト | システムユーザー |
| 退職理由 | departureReason.name | テキスト | 退職理由 |
| 退職日 | departure_date | 日付 | 退職日 |
| 退職説明 | departure_description | テキスト | 退職理由の詳細説明 |
| 主要言語 | lang | テキスト | 主要使用言語 |
| 追加メモ | additional_note | テキスト | 追加のメモ |
| ノート | notes | テキスト | その他ノート |
| バッジID | barcode | テキスト | バッジ用バーコード |
| PIN | pin | テキスト | 勤怠打刻用PIN |

## イベント仕様

### 1-画面表示

1. 従業員レコードを取得
2. 関連するPartnerレコードの情報をマージ（mutateFormDataBeforeFill）
3. Infolist形式で情報を表示

### 2-Chatterアクション押下

1. Chatterパネルが開く
2. メッセージ送信、アクティビティ登録、フォロワー管理が可能
3. アクティビティプランは「employees」プラグインに関連するプランが表示

### 3-削除ボタン押下

1. 確認ダイアログを表示
2. 確認後、従業員レコードを論理削除
3. 成功通知を表示
4. 従業員一覧画面へリダイレクト

### 4-サブナビゲーション遷移

1. サブナビゲーションの各リンクをクリック
2. 対応する画面（詳細/編集/履歴書/スキル）へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | employees_employees | UPDATE | deleted_atに日時を設定 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 削除成功時 | 従業員が正常に削除されました |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| データが見つからない | 404エラー | 指定された従業員が見つかりません |
| 権限不足 | 403エラー | この操作を行う権限がありません |

## 備考

- ViewRecordページタイプを使用
- サブナビゲーションポジションはTop
- mutateFormDataBeforeFillでパートナー情報をInfolistにマージ
- Chatterトレイトにより変更履歴・アクティビティを閲覧可能
- 電話番号・メールアドレスはクリック可能なリンク形式で表示
- タグはカラーパレットを使用したバッジ形式で表示
- 空の値はプレースホルダー「—」で表示
