# 画面設計書 78-履歴書管理

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける履歴書管理画面の設計仕様を定義します。

### 本画面の処理概要

履歴書管理画面は、従業員の職歴・学歴・資格などの経歴情報を管理するための画面です。従業員詳細画面のサブナビゲーションからアクセスし、関連レコードとして履歴書情報の追加・編集・削除を行います。

**業務上の目的・背景**：
従業員のキャリア情報を体系的に管理し、人材配置の検討、スキルマッピング、後継者計画などの人事施策に活用します。職歴、学歴、資格、プロジェクト経験などを種別ごとに分類して管理できます。

**画面へのアクセス方法**：
1. 従業員詳細画面 → サブナビゲーションの「履歴書」リンク
2. 直接URL: `/employees/employees/{record}/resumes`

**主要な操作・処理内容**：
1. 履歴書一覧の表示・検索・フィルタリング
2. 新規履歴書エントリの追加
3. 既存履歴書エントリの編集
4. 履歴書エントリの削除
5. 履歴書種別でのグループ化表示

**画面遷移**：
- サブナビゲーションから従業員詳細/編集/スキル画面へ遷移可能
- 新規作成・編集はモーダルダイアログで表示

**権限による表示制御**：
従業員モジュールへのアクセス権限を持つユーザーがこの画面を操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-005 | 履歴書管理 | 主機能 | 履歴書エントリの追加/編集/削除 |
| FN-EMP-003 | 従業員詳細 | 遷移元機能 | サブナビゲーションからの遷移 |

## 画面種別

関連レコード管理（ManageRelatedRecords）

## URL/ルーティング

`/employees/employees/{record}/resumes`

## 画面構成

- サブナビゲーション: 詳細/編集/履歴書/スキルの切り替え
- ヘッダーアクション: 履歴書追加ボタン
- データテーブル: 履歴書一覧表示
- グループ化: 履歴書種別、表示タイプでグループ化可能
- フィルター: 種別、開始日、作成日でフィルタ
- 行アクション: 詳細表示、編集、削除
- 一括アクション: 一括削除

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| タイトル | name | string | 必須 | 履歴書エントリのタイトル |
| 種別 | type | select | - | 履歴書の種別（リレーション） |
| 開始日 | start_date | date | 必須 | 期間の開始日 |
| 終了日 | end_date | date | - | 期間の終了日 |
| 表示タイプ | display_type | select | 必須 | 表示分類（ResumeDisplayType Enum） |
| 説明 | description | textarea | - | 詳細説明 |
| 作成者ID | creator_id | integer | 自動 | 作成者のユーザーID |
| ユーザーID | user_id | integer | 自動 | 関連ユーザーのID |

## 表示項目

| 項目名 | 物理名 | 表示形式 | ソート | 検索 | 説明 |
|--------|--------|----------|--------|------|------|
| タイトル | name | テキスト | 可 | 可 | 履歴書エントリのタイトル |
| 開始日 | start_date | 日付 | 可 | - | 期間の開始日 |
| 終了日 | end_date | 日付 | 可 | - | 期間の終了日 |
| 表示タイプ | display_type | テキスト | 可 | - | 表示分類 |
| 説明 | description | テキスト（50文字制限） | - | 可 | 詳細説明 |
| 作成者 | createdBy.name | テキスト | 可 | - | 作成者名 |
| 作成日時 | created_at | 日付 | 可 | - | レコード作成日時（デフォルト非表示） |
| 更新日時 | updated_at | 日付 | 可 | - | レコード更新日時（デフォルト非表示） |

## フィルター項目

| フィルター名 | 物理名 | フィルター種別 | 説明 |
|-------------|--------|--------------|------|
| 種別 | type_id | セレクト（リレーション） | 履歴書種別でフィルタ |
| 開始日 | start_date | 日付範囲 | 開始日の期間指定 |
| 作成日 | created_at | 日付範囲 | 作成日の期間指定 |

## グループ化項目

| グループ名 | 物理名 | 説明 |
|-----------|--------|------|
| 履歴書種別 | resumeType.name | 種別でグループ化 |
| 表示タイプ | display_type | 表示タイプでグループ化 |

## イベント仕様

### 1-履歴書追加ボタン押下

1. 作成モーダルが表示される
2. 必須項目（タイトル、開始日、表示タイプ）を入力
3. 保存ボタンで新規レコードをINSERT
4. creator_id、user_idにログインユーザーIDを自動設定
5. 成功通知を表示
6. 一覧を更新

### 2-種別のインライン作成

1. 種別選択で「新規作成」を選択
2. 種別作成モーダルが表示
3. 種別名を入力して保存
4. 作成した種別が自動選択される

### 3-詳細表示ボタン押下

1. 詳細モーダルが表示される
2. Infolist形式で情報を表示

### 4-編集ボタン押下

1. 編集モーダルが表示される
2. 既存データを読み込んで表示
3. 変更後、保存ボタンでUPDATE
4. 成功通知を表示

### 5-削除ボタン押下

1. 確認ダイアログを表示
2. 確認後、レコードをDELETE
3. 成功通知を表示
4. 一覧を更新

### 6-一括削除

1. 複数レコードを選択
2. 一括削除ボタンを押下
3. 確認後、選択レコードを一括DELETE
4. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 履歴書追加 | employees_resumes | INSERT | 履歴書レコードを新規登録 |
| 履歴書編集 | employees_resumes | UPDATE | 履歴書レコードを更新 |
| 履歴書削除 | employees_resumes | DELETE | 履歴書レコードを削除 |
| 種別作成 | employees_resume_types | INSERT | 履歴書種別を新規登録 |

### テーブル別更新項目詳細

#### employees_resumes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | employee_id | 親従業員のID | 自動設定 |
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | type_id | 選択した種別ID | - |
| INSERT | start_date | フォーム入力値 | 必須 |
| INSERT | end_date | フォーム入力値 | - |
| INSERT | display_type | フォーム入力値 | 必須 |
| INSERT | description | フォーム入力値 | - |
| INSERT | creator_id | ログインユーザーID | 自動設定 |
| INSERT | user_id | ログインユーザーID | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 作成成功時 | 履歴書が正常に作成されました |
| MSG-002 | 成功 | 更新成功時 | 履歴書が正常に更新されました |
| MSG-003 | 成功 | 削除成功時 | 履歴書が正常に削除されました |
| MSG-004 | 成功 | 一括削除成功時 | 選択された履歴書が正常に削除されました |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| データが見つからない | 404エラー | 指定された履歴書が見つかりません |
| 権限不足 | 403エラー | この操作を行う権限がありません |
| 入力値不正 | バリデーションエラー | 必須項目を入力してください |

## 備考

- ManageRelatedRecordsページタイプを使用（関連レコード管理）
- EmployeeResumeRelationトレイトでフォーム・テーブル・Infolist定義を提供
- リレーション名は「resumes」
- ナビゲーションアイコンは「heroicon-o-clipboard-document-list」
- 表示タイプはResumeDisplayType Enumで定義
- 履歴書種別はresume_typesテーブルで管理され、インライン作成が可能
- 開始日フィールドは日付範囲フィルターで「from」「to」指定可能
