# 画面設計書 79-スキル管理

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおけるスキル管理画面の設計仕様を定義します。

### 本画面の処理概要

スキル管理画面は、従業員が保有するスキル・能力を管理するための画面です。スキルタイプ、スキル、スキルレベルの3段階構造で従業員のスキルを登録・管理し、スキルレベルを視覚的なプログレスバーで表示します。

**業務上の目的・背景**：
従業員のスキルセットを体系的に管理し、プロジェクトへの適切な人材配置、スキルギャップ分析、研修計画の策定などに活用します。スキルレベルを数値化することで、組織全体のスキル分布を可視化できます。

**画面へのアクセス方法**：
1. 従業員詳細画面 → サブナビゲーションの「スキル」リンク
2. 直接URL: `/employees/employees/{record}/skills`

**主要な操作・処理内容**：
1. スキル一覧の表示
2. 新規スキルの追加（スキルタイプ→スキル→スキルレベルの選択）
3. 既存スキルの編集
4. スキルの削除
5. スキルタイプでのグループ化表示

**画面遷移**：
- サブナビゲーションから従業員詳細/編集/履歴書画面へ遷移可能
- 新規作成・編集はモーダルダイアログで表示

**権限による表示制御**：
従業員モジュールへのアクセス権限を持つユーザーがこの画面を操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-006 | スキル管理 | 主機能 | スキルの追加/編集/削除 |
| FN-EMP-003 | 従業員詳細 | 遷移元機能 | サブナビゲーションからの遷移 |

## 画面種別

関連レコード管理（ManageRelatedRecords）

## URL/ルーティング

`/employees/employees/{record}/skills`

## 画面構成

- サブナビゲーション: 詳細/編集/履歴書/スキルの切り替え
- ヘッダーアクション: スキル追加ボタン
- データテーブル: スキル一覧表示
- グループ化: スキルタイプでグループ化可能
- 行アクション: 詳細表示、編集、削除
- 一括アクション: 一括削除

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 説明 |
|--------|--------|----------|------|------|
| スキルタイプ | skill_type_id | radio | 必須 | スキルの大分類（ラジオボタン） |
| スキル | skill_id | select | 必須 | 具体的なスキル（スキルタイプに連動） |
| スキルレベル | skill_level_id | select | 必須 | 習熟度レベル（スキルタイプに連動） |
| 作成者ID | creator_id | integer | 自動 | 作成者のユーザーID |

## 表示項目

| 項目名 | 物理名 | 表示形式 | ソート | 説明 |
|--------|--------|----------|--------|------|
| スキルタイプ | skillType.name | テキスト | 可 | スキルの大分類 |
| スキル | skill.name | テキスト | 可 | 具体的なスキル名 |
| スキルレベル | skillLevel.name | バッジ（色付き） | - | 習熟度レベル名 |
| レベル(%) | skillLevel.level | プログレスバー | - | 習熟度パーセンテージ |
| 作成者 | creator.name | テキスト | 可 | 作成者名 |
| ユーザー | user.name | テキスト | 可 | 関連ユーザー（デフォルト非表示） |
| 作成日時 | created_at | 日付 | 可 | レコード作成日時（デフォルト非表示） |

## グループ化項目

| グループ名 | 物理名 | 説明 |
|-----------|--------|------|
| スキルタイプ | skillType.name | スキルタイプでグループ化 |

## イベント仕様

### 1-スキル追加ボタン押下

1. 作成モーダルが表示される
2. スキルタイプをラジオボタンで選択（デフォルト：最初のスキルタイプ）
3. スキルタイプに応じたスキル選択肢が表示される
4. スキルを選択すると、対応するスキルレベル選択肢が表示される
5. 保存ボタンで新規レコードをINSERT
6. creator_idにログインユーザーIDを自動設定
7. 成功通知を表示
8. 一覧を更新

### 2-スキルタイプ変更（フォーム内）

1. スキルタイプを変更
2. スキルの選択肢がリセットされる（null）
3. スキルレベルの選択肢がリセットされる（null）
4. 新しいスキルタイプに対応するスキル・レベルが選択可能になる

### 3-スキル変更（フォーム内）

1. スキルを変更
2. スキルレベルの選択肢がリセットされる（null）

### 4-詳細表示ボタン押下

1. 詳細モーダルが表示される
2. Infolist形式で情報を表示
3. スキルレベルはプログレスバーで表示

### 5-編集ボタン押下

1. 編集モーダルが表示される
2. 既存データを読み込んで表示
3. 変更後、保存ボタンでUPDATE
4. 成功通知を表示

### 6-削除ボタン押下

1. 確認ダイアログを表示
2. 確認後、レコードをDELETE
3. 成功通知を表示
4. 一覧を更新

### 7-一括削除

1. 複数レコードを選択
2. 一括削除ボタンを押下
3. 確認後、選択レコードを一括DELETE
4. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| スキル追加 | employees_skills | INSERT | スキルレコードを新規登録 |
| スキル編集 | employees_skills | UPDATE | スキルレコードを更新 |
| スキル削除 | employees_skills | DELETE | スキルレコードを削除 |

### テーブル別更新項目詳細

#### employees_skills

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | employee_id | 親従業員のID | 自動設定 |
| INSERT | skill_type_id | 選択したスキルタイプID | 必須 |
| INSERT | skill_id | 選択したスキルID | 必須 |
| INSERT | skill_level_id | 選択したスキルレベルID | 必須 |
| INSERT | creator_id | ログインユーザーID | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 作成成功時 | スキルが正常に追加されました |
| MSG-002 | 成功 | 更新成功時 | スキルが正常に更新されました |
| MSG-003 | 成功 | 削除成功時 | スキルが正常に削除されました |
| MSG-004 | 成功 | 一括削除成功時 | 選択されたスキルが正常に削除されました |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| データが見つからない | 404エラー | 指定されたスキルが見つかりません |
| 権限不足 | 403エラー | この操作を行う権限がありません |
| 入力値不正 | バリデーションエラー | 必須項目を選択してください |

## プログレスバーの色分け仕様

| レベル範囲 | 色 | 説明 |
|-----------|-----|------|
| 100% | success（緑） | 完全習得 |
| 50%〜79% | warning（黄） | 中級レベル |
| 80%〜99% | info（青） | 上級レベル |
| 0%〜19% | danger（赤） | 初級レベル |
| 20%〜49% | info（青） | 基礎レベル |

## 備考

- ManageRelatedRecordsページタイプを使用（関連レコード管理）
- EmployeeSkillRelationトレイトでフォーム・テーブル・Infolist定義を提供
- リレーション名は「skills」
- ナビゲーションアイコンは「heroicon-o-bolt」
- スキルタイプはラジオボタン形式で選択
- スキルとスキルレベルはスキルタイプに連動するカスケード選択
- スキルレベルのバッジ色はスキルタイプの設定色を使用
- プログレスバーはカスタムテーブルカラム（CustomTables\Columns\ProgressBarEntry）を使用
- Infolistでもプログレスバー表示（CustomTables\Infolists\ProgressBarEntry）
