# 画面設計書 8-請求書作成

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける仕入先請求書作成画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、仕入先から受け取った請求書を新規登録するためのフォーム画面です。仕入先情報、請求日、明細行（商品・サービス）、支払条件などを入力し、仕入先請求書（Bill）レコードを作成します。

**業務上の目的・背景**：仕入先からの請求書を正確にシステムに登録することは、買掛金管理と支払処理の基盤となります。本画面により、経理担当者は請求書の詳細情報を入力し、適切な税計算と合計金額の自動算出を行いながら、効率的に請求書データを登録できます。

**画面へのアクセス方法**：請求書一覧画面のヘッダーにある「新規作成」ボタン（+アイコン）をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 仕入先（vendor）の選択
2. 請求日（invoice_date）、会計日（date）の入力
3. 請求書参照番号（reference）の入力
4. 支払参照（payment_reference）の入力
5. 支払先銀行口座（partner_bank_id）の選択
6. 支払条件または支払期日の設定
7. 請求明細行（products）の追加・編集
8. その他情報（インコタームズ、支払方法、会社、通貨等）の設定
9. 利用規約・備考（narration）の入力
10. 保存ボタンによるデータ登録

**画面遷移**：
- 本画面から遷移可能：請求書詳細画面（保存成功時）
- 本画面への遷移元：請求書一覧画面

**権限による表示制御**：仕入先請求書の作成権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-006 | 仕入請求書作成 | 主機能 | 新規仕入請求書の作成 |
| FN-ACC-005 | 仕入請求書一覧 | 遷移元機能 | 一覧画面からの遷移 |

## 画面種別

登録

## URL/ルーティング

`/accounts/bills/create`

## 画面構成

- ステータスステッパー：請求書のステータス表示（Draft等）
- 一般情報セクション：仕入先、日付、参照番号等
- タブセクション
  - 請求明細タブ：商品・サービスの明細行リピーター、合計サマリー
  - その他情報タブ：インコタームズ、支払方法、会社、通貨設定
  - 利用規約タブ：備考・条件のリッチテキストエディタ

## 入出力項目

### 一般情報セクション

| No | 項目名 | 物理名 | 型 | 必須 | 初期値 | 説明 | 入力形式 |
|----|--------|--------|-----|------|--------|------|---------|
| 1 | ステータス | state | enum | - | DRAFT | 請求書ステータス | ProgressStepper（無効） |
| 2 | 仕入先 | partner_id | integer | - | なし | 仕入先パートナー | セレクトボックス（sub_type=supplier） |
| 3 | 請求日 | invoice_date | date | - | 現在日 | 請求書の日付 | 日付ピッカー |
| 4 | 請求書参照 | reference | string | - | なし | 仕入先請求書番号 | テキスト入力 |
| 5 | 会計日 | date | date | - | 現在日 | 会計上の日付 | 日付ピッカー |
| 6 | 支払参照 | payment_reference | string | - | なし | 支払時の参照番号 | テキスト入力 |
| 7 | 支払先銀行 | partner_bank_id | integer | - | なし | 送金先銀行口座 | セレクトボックス |
| 8 | 支払期日 | invoice_date_due | date | 条件付き | 現在日 | 支払期限 | 日付ピッカー（支払条件未設定時） |
| 9 | 支払条件 | invoice_payment_term_id | integer | 条件付き | なし | 支払条件 | セレクトボックス |

### 請求明細タブ

| No | 項目名 | 物理名 | 型 | 必須 | 初期値 | 説明 | 入力形式 |
|----|--------|--------|-----|------|--------|------|---------|
| 10 | 商品 | product_id | integer | ○ | なし | 商品 | セレクトボックス |
| 11 | 数量 | quantity | decimal | ○ | 1 | 数量 | 数値入力 |
| 12 | 単位 | uom_id | integer | 条件付き | 商品の単位 | 単位 | セレクトボックス（UOM有効時） |
| 13 | 税 | taxes | array | - | 商品のデフォルト税 | 適用税 | 複数選択（仕入税） |
| 14 | 割引率 | discount | decimal | - | 0 | 割引率（%） | 数値入力 |
| 15 | 単価 | price_unit | decimal | ○ | 商品原価 | 単価 | 数値入力 |
| 16 | 小計 | price_subtotal | decimal | - | 自動計算 | 税抜小計 | 数値表示（自動） |

### その他情報タブ

| No | 項目名 | 物理名 | 型 | 必須 | 初期値 | 説明 | 入力形式 |
|----|--------|--------|-----|------|--------|------|---------|
| 17 | インコタームズ | invoice_incoterm_id | integer | - | なし | 貿易条件 | セレクトボックス |
| 18 | インコタームズ場所 | incoterm_location | string | - | なし | 貿易条件の場所 | テキスト入力 |
| 19 | 支払方法 | preferred_payment_method_line_id | integer | - | なし | 優先支払方法 | セレクトボックス |
| 20 | 自動転記 | auto_post | boolean | - | false | 自動転記フラグ | トグルスイッチ |
| 21 | 確認済み | checked | boolean | - | false | 確認済みフラグ | トグルスイッチ |
| 22 | 会社 | company_id | integer | - | ログインユーザーの会社 | 所属会社 | セレクトボックス |
| 23 | 通貨 | currency_id | integer | ○ | 会社のデフォルト通貨 | 使用通貨 | セレクトボックス |

### 利用規約タブ

| No | 項目名 | 物理名 | 型 | 必須 | 初期値 | 説明 | 入力形式 |
|----|--------|--------|-----|------|--------|------|---------|
| 24 | 備考 | narration | text | - | なし | 備考・利用規約 | リッチテキストエディタ |

## 表示項目

### 請求サマリー（Livewireコンポーネント）

| No | 項目名 | 説明 |
|----|--------|------|
| 1 | 税抜合計 | 全明細行の税抜小計合計 |
| 2 | 税額合計 | 全明細行の税額合計 |
| 3 | 税込合計 | 税抜合計 + 税額合計 |

## イベント仕様

### 1-仕入先選択

仕入先を選択すると、以下のデータが自動設定されます：
- 支払先銀行口座：仕入先の最初の銀行口座
- 支払方法：仕入先の優先支払方法
- 支払条件：仕入先のデフォルト支払条件

### 2-商品選択

明細行で商品を選択すると、以下のデータが自動設定されます：
- 単位：商品のデフォルト単位
- 単価：商品原価（cost）または販売価格（price）を単位で換算
- 税：商品のデフォルト仕入税

### 3-数量・単価・割引変更

数量、単価、割引率を変更すると、小計が自動再計算されます。税を考慮した計算が行われます。

### 4-会社選択

会社を変更すると、通貨が該当会社のデフォルト通貨に自動更新されます。

### 5-保存ボタン押下

フォームのバリデーションを実行し、成功した場合はデータベースにレコードを作成します。作成後、Account::computeAccountMove()で会計計算が実行され、詳細画面へ自動遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_moves | INSERT | 請求書レコードを作成 |
| 保存ボタン押下 | accounts_move_lines | INSERT | 明細行レコードを作成 |
| 保存ボタン押下 | accounts_move_line_taxes | INSERT | 明細行と税の関連を作成 |

### テーブル別更新項目詳細

#### accounts_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | move_type | IN_INVOICE | 仕入先請求書タイプ |
| INSERT | state | DRAFT | 初期ステータス |
| INSERT | date | 現在日時 | 自動設定 |
| INSERT | partner_id | フォーム選択値 | |
| INSERT | invoice_date | フォーム入力値 | |
| INSERT | invoice_date_due | フォーム入力値または支払条件から計算 | |
| INSERT | currency_id | フォーム選択値 | |
| INSERT | company_id | フォーム選択値 | |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 請求書が作成されました | 保存成功時 |
| MSG-002 | エラー | 必須項目を入力してください | バリデーションエラー時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 必須項目未入力 | フォームエラー表示 | 必須項目を入力してください |
| 数値範囲エラー | フォームエラー表示 | 有効な値を入力してください |
| データベースエラー | エラー通知表示 | データの保存に失敗しました |

## 備考

- 本画面はFilament PHPのCreateRecordを継承して実装されています
- HasRepeaterColumnManagerトレイトを使用して明細行テーブルの列管理機能を実装
- 保存成功後は自動的に詳細画面（ViewBill）へリダイレクトされます
- move_typeはIN_INVOICE（仕入先請求書）が自動設定されます
- 保存後にAccount::computeAccountMove()で会計計算（仕訳生成等）が実行されます
- 明細行の税はTypeTaxUse::PURCHASE（仕入税）のみ選択可能です
- UOM（単位）設定が有効な場合のみ、単位選択欄が表示されます
- サブナビゲーションはクラスター設定から生成されます
