# 画面設計書 80-部署一覧

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける部署一覧画面の設計仕様を定義します。

### 本画面の処理概要

部署一覧画面は、組織の部署構造を一覧表示・管理するための画面です。カード形式のグリッドレイアウトで部署情報を視覚的に表示し、部署の新規作成、詳細表示、編集、削除を行うことができます。

**業務上の目的・背景**：
組織の部署構造を可視化し、部署の追加・変更・削除を管理します。階層的な部署構造をサポートし、親部署・子部署の関係を管理できます。部署ごとの責任者（マネージャー）の設定や所属会社の紐付けも行います。

**画面へのアクセス方法**：
サイドメニューの「従業員」モジュール → 「部署」を選択してアクセスします。

**主要な操作・処理内容**：
1. 部署のカード形式一覧表示
2. 多様な条件でのフィルタリング・検索
3. グループ化表示（名前別、会社別、マネージャー別等）
4. 部署の新規作成、詳細表示、編集、削除
5. 論理削除された部署の復元・完全削除
6. 複数部署の一括削除

**画面遷移**：
- 新規作成 → 部署作成画面
- 詳細表示 → 部署詳細画面
- 編集 → 部署編集画面
- 「Archived」ビューで削除済み部署を表示可能

**権限による表示制御**：
従業員モジュールへのアクセス権限を持つユーザーのみがこの画面を操作できます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-007 | 部署管理 | 主機能 | 部署の一覧表示・検索・削除 |
| FN-EMP-008 | 部署作成 | 遷移先機能 | 新規部署の作成 |
| FN-EMP-009 | 部署詳細 | 遷移先機能 | 部署詳細の表示 |
| FN-EMP-010 | 部署編集 | 遷移先機能 | 部署情報の編集 |

## 画面種別

一覧（List）

## URL/ルーティング

`/employees/departments`

## 画面構成

- ヘッダーアクション: 新規作成ボタン
- カードグリッド: 部署カード一覧（2列〜4列レスポンシブ）
- フィルター: 高度なフィルタリング機能（QueryBuilder）
- グループ化: 複数の条件でグループ化可能
- プリセットビュー: 「Archived」ビューでアーカイブ済み部署を表示

## 表示項目（カード形式）

| 項目名 | 物理名 | 表示形式 | 表示条件 | 説明 |
|--------|--------|----------|---------|------|
| マネージャーアバター | manager.partner.avatar | 画像（円形） | 常時 | マネージャーのプロフィール画像 |
| 部署名 | name | テキスト（太字） | 常時 | 部署の名称 |
| マネージャー名 | manager.name | テキスト+アイコン | マネージャーがいる場合 | 部署責任者名 |
| 会社名 | company.name | テキスト+アイコン | 会社が設定されている場合 | 所属会社名 |

## フィルター項目（QueryBuilder）

| 項目名 | 物理名 | フィルター種別 | 説明 |
|--------|--------|--------------|------|
| 部署名 | name | テキスト | 部署名で検索 |
| マネージャー | manager | リレーション | マネージャーでフィルタ |
| 会社 | company | リレーション | 会社でフィルタ |
| 作成日 | created_at | 日付 | 作成日で検索 |
| 更新日 | updated_at | 日付 | 更新日で検索 |

## グループ化項目

| グループ名 | 物理名 | 説明 |
|-----------|--------|------|
| 部署名 | name | 部署名でグループ化 |
| 会社 | company.name | 会社でグループ化 |
| マネージャー | manager.name | マネージャーでグループ化 |
| 作成日 | created_at | 作成日でグループ化 |
| 更新日 | updated_at | 更新日でグループ化 |

## プリセットビュー

| ビュー名 | 物理名 | 説明 |
|---------|--------|------|
| Archived | archived | 論理削除された部署のみ表示 |

## イベント仕様

### 1-新規作成ボタン押下

1. 部署作成画面へ遷移
2. フォームに必要事項を入力
3. 保存後、部署詳細画面へリダイレクト

### 2-詳細表示ボタン押下

1. 選択した部署の詳細画面へ遷移
2. 全ての部署情報をInfolist形式で表示
3. 部署階層をツリー形式で表示

### 3-編集ボタン押下

1. 選択した部署の編集画面へ遷移
2. フォームで情報を編集
3. 保存後、部署詳細画面へリダイレクト

### 4-削除ボタン押下

1. 確認ダイアログを表示
2. 確認後、論理削除（ソフトデリート）を実行
3. 成功通知を表示

### 5-復元ボタン押下

1. Archivedビューで表示
2. 論理削除を取り消し
3. 成功通知を表示

### 6-完全削除ボタン押下

1. Archivedビューで表示
2. 確認ダイアログを表示
3. 確認後、物理削除を実行
4. 成功通知を表示

### 7-一括削除

1. 複数の部署カードを選択
2. 一括削除ボタンを押下
3. 確認後、選択部署を論理削除
4. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | employees_departments | UPDATE | deleted_atに日時を設定 |
| 復元 | employees_departments | UPDATE | deleted_atをnullに更新 |
| 完全削除 | employees_departments | DELETE | レコードを物理削除 |
| 一括削除 | employees_departments | UPDATE | 複数レコードのdeleted_atに日時を設定 |

## メッセージ仕様

| メッセージID | 種別 | 条件 | メッセージ内容 |
|-------------|------|------|---------------|
| MSG-001 | 成功 | 削除成功時 | 部署が正常に削除されました |
| MSG-002 | 成功 | 復元成功時 | 部署が正常に復元されました |
| MSG-003 | 成功 | 完全削除成功時 | 部署が完全に削除されました |
| MSG-004 | 成功 | 一括削除成功時 | 選択された部署が正常に削除されました |
| MSG-005 | 成功 | 一括復元成功時 | 選択された部署が正常に復元されました |

## 例外処理

| 例外条件 | 処理内容 | ユーザー表示 |
|---------|---------|-------------|
| データが見つからない | 404エラー | 指定された部署が見つかりません |
| 権限不足 | 403エラー | この操作を行う権限がありません |
| 循環参照検出 | 作成/更新失敗 | 部署階層に循環参照が検出されました |
| 参照整合性エラー | 削除失敗 | この部署は従業員が所属しているため削除できません |

## 備考

- ListRecordsページタイプを使用
- HasTableViewsトレイトによりテーブルビューの保存・切り替えが可能
- カードグリッドレイアウト（md: 2列、xl: 4列）
- SoftDeletesによる論理削除を採用
- グローバル検索対応（name, manager.name, company.name）
- サブナビゲーションポジションはTop
- 部署作成・更新時に循環参照チェックを実行（validateNoRecursion）
- complete_nameは親部署からの完全パスを自動生成
- parent_pathは階層パスを自動管理
- master_department_idはルート部署のIDを自動設定
- 詳細画面では部署階層ツリーを視覚的に表示（buildHierarchyTree）
