# 画面設計書 81-部署作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける部署作成画面の設計仕様を定義します。従業員モジュールの一部として、新規部署を登録するためのフォーム画面です。

### 本画面の処理概要

**業務上の目的・背景**：
組織構造を管理するために、新しい部署を登録する機能が必要です。部署は従業員の所属先として機能し、階層構造を持つことで組織のレポートラインや責任範囲を明確にします。人事管理、権限管理、レポート作成において部署情報は基盤となるマスターデータです。

**画面へのアクセス方法**：
1. メインナビゲーションから「従業員」モジュールを選択
2. サイドメニューから「部署」を選択して部署一覧画面に遷移
3. 画面右上の「新規作成」ボタンをクリック

**主要な操作・処理内容**：
1. 部署名の入力（必須項目）
2. 親部署の選択（階層構造を形成する場合）
3. 部署マネージャーの選択
4. 所属会社の選択
5. 表示色の設定
6. カスタムフィールドの入力（設定されている場合）
7. 保存ボタンで部署を作成

**画面遷移**：
- 遷移元：部署一覧画面（ListDepartments）
- 遷移先：部署詳細画面（ViewDepartment）- 作成成功後に自動遷移

**権限による表示制御**：
- 部署作成権限を持つユーザーのみがこの画面にアクセス可能
- 会社選択肢は、ユーザーがアクセス可能な会社のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-006 | 部門作成 | 主機能 | 新規部署レコードの作成 |
| FN-EMP-005 | 部門一覧 | 遷移元機能 | 一覧からの遷移 |
| FN-EMP-008 | 部門表示 | 遷移先機能 | 作成後の詳細表示 |

## 画面種別

登録画面（CreateRecord）

## URL/ルーティング

`/employees/departments/create`

## 画面構成

- ヘッダー：画面タイトル「部署作成」
- メインコンテンツ：
  - セクション「General」
    - 部署名入力フィールド
    - 親部署選択フィールド
    - マネージャー選択フィールド
    - 会社選択フィールド
    - 色選択フィールド
  - セクション「Additional」（カスタムフィールドが設定されている場合のみ表示）
    - カスタムフィールド群
- フッター：
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 作成者ID | creator_id | integer | ○ | - | ログインユーザーIDが自動設定（Hidden） |
| 部署名 | name | string | ○ | 255 | 部署の名称 |
| 親部署 | parent_id | integer | - | - | 親部署のID（階層構造用） |
| マネージャー | manager_id | integer | - | - | 部署責任者の従業員ID |
| 会社 | company_id | integer | - | - | 所属会社のID |
| 色 | color | string | - | - | 表示色（HEX形式） |

## 表示項目

該当なし（登録画面のため）

## イベント仕様

### 01-保存ボタン押下

1. 入力バリデーションを実行
   - 部署名が入力されているか確認
   - 部署名の最大長（255文字）チェック
2. 親部署が選択されている場合、循環参照チェックを実行
3. バリデーション成功時：
   - 部署レコードを作成
   - complete_name（完全名）を自動生成（親部署名/部署名の形式）
   - parent_path（親パス）を自動設定
   - master_department_id（最上位部署ID）を自動設定
   - 成功通知を表示
   - 部署詳細画面へリダイレクト
4. バリデーション失敗時：
   - エラーメッセージを表示
   - 画面に留まる

### 02-キャンセルボタン押下

1. 入力内容を破棄
2. 部署一覧画面へ遷移

### 03-親部署選択

1. 親部署を検索・選択可能
2. 削除済み（ソフトデリート）の部署は「(Deleted)」表示で無効化
3. 選択すると階層構造が更新される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | employees_departments | INSERT | 新規部署レコードの作成 |

### テーブル別更新項目詳細

#### employees_departments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | parent_id | フォーム選択値 | NULL許可 |
| INSERT | manager_id | フォーム選択値 | NULL許可 |
| INSERT | company_id | フォーム選択値 | NULL許可 |
| INSERT | color | フォーム入力値 | NULL許可 |
| INSERT | creator_id | Auth::id() | ログインユーザーID |
| INSERT | complete_name | 自動生成（親部署名/部署名） | Model Bootで設定 |
| INSERT | parent_path | 自動生成（/親ID/...） | Model Bootで設定 |
| INSERT | master_department_id | 自動生成（最上位親ID） | Model Bootで設定 |
| INSERT | created_at | CURRENT_TIMESTAMP | 自動設定 |
| INSERT | updated_at | CURRENT_TIMESTAMP | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | 本文 | 表示条件 |
|-------------|------|---------|------|----------|
| MSG-001 | 成功 | 部署作成完了 | 部署が正常に作成されました | 保存成功時 |
| MSG-002 | エラー | 循環参照エラー | 部署の階層構造に循環参照が検出されました | 親部署が自己参照時 |
| MSG-003 | エラー | バリデーションエラー | 必須項目を入力してください | 必須項目未入力時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| 循環参照エラー | 親部署の選択で循環構造が発生 | InvalidArgumentException発生、エラーメッセージ表示 |
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 作成権限なし | 403エラー画面表示 |
| データベースエラー | DB接続失敗等 | エラーメッセージ表示、ログ記録 |

## 備考

- 部署の階層構造は無制限の深さをサポート
- complete_nameは親部署から子部署への完全パス名（例：「営業部 / 東日本営業部 / 東京支店」）
- 削除済み親部署は選択不可（UI上で無効化）
- Chatter（コメント機能）は詳細画面・編集画面でのみ利用可能
- カスタムフィールドはField Traitで動的に追加可能
