# 画面設計書 82-部署編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける部署編集画面の設計仕様を定義します。従業員モジュールの一部として、既存部署の情報を変更するためのフォーム画面です。

### 本画面の処理概要

**業務上の目的・背景**：
組織変更や人事異動に伴い、部署の情報を更新する必要があります。部署名の変更、マネージャーの交代、組織階層の変更など、組織構造の維持・管理に不可欠な機能です。適切な部署情報の維持は、従業員管理、権限設定、レポート生成の正確性に直結します。

**画面へのアクセス方法**：
1. 部署一覧画面から対象部署の編集アイコンをクリック
2. 部署詳細画面のヘッダーにある「編集」ボタンをクリック
3. サブナビゲーションから「編集」タブを選択

**主要な操作・処理内容**：
1. 部署名の変更
2. 親部署の変更（階層構造の変更）
3. 部署マネージャーの変更
4. 所属会社の変更
5. 表示色の変更
6. カスタムフィールドの編集
7. Chatter（コメント機能）でのコミュニケーション
8. 部署の削除

**画面遷移**：
- 遷移元：部署詳細画面（ViewDepartment）、部署一覧画面（ListDepartments）
- 遷移先：部署詳細画面（ViewDepartment）- 保存成功後

**権限による表示制御**：
- 部署編集権限を持つユーザーのみがこの画面にアクセス可能
- 削除権限を持つユーザーのみが削除ボタンを使用可能
- 会社選択肢は、ユーザーがアクセス可能な会社のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-007 | 部門編集 | 主機能 | 部署レコードの更新 |
| FN-EMP-008 | 部門表示 | 遷移元/遷移先機能 | 詳細画面との遷移 |
| FN-EMP-005 | 部門一覧 | 遷移元機能 | 一覧からの遷移 |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

`/employees/departments/{record}/edit`

## 画面構成

- ヘッダー：
  - 画面タイトル（部署名）
  - アクションボタン：Chatter、表示、削除
- サブナビゲーション：
  - 詳細タブ
  - 編集タブ（アクティブ）
  - 従業員タブ
- メインコンテンツ：
  - セクション「General」
    - 部署名入力フィールド
    - 親部署選択フィールド
    - マネージャー選択フィールド
    - 会社選択フィールド
    - 色選択フィールド
  - セクション「Additional」（カスタムフィールドが設定されている場合のみ表示）
- フッター：
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 作成者ID | creator_id | integer | ○ | - | 変更不可（Hidden） |
| 部署名 | name | string | ○ | 255 | 部署の名称 |
| 親部署 | parent_id | integer | - | - | 親部署のID |
| マネージャー | manager_id | integer | - | - | 部署責任者の従業員ID |
| 会社 | company_id | integer | - | - | 所属会社のID |
| 色 | color | string | - | - | 表示色（HEX形式） |

## 表示項目

該当なし（編集画面のため、入力項目と同一）

## イベント仕様

### 01-保存ボタン押下

1. 入力バリデーションを実行
2. 親部署変更時、循環参照チェックを実行
3. バリデーション成功時：
   - 部署レコードを更新
   - complete_name、parent_path、master_department_idを再計算
   - 成功通知を表示
   - 部署詳細画面へリダイレクト
4. バリデーション失敗時：
   - エラーメッセージを表示
   - 画面に留まる
5. データベース更新エラー時：
   - updateFailedフラグを設定
   - エラー通知を表示
   - リダイレクトしない

### 02-削除ボタン押下（ヘッダーアクション）

1. 確認ダイアログを表示
2. 確認後、部署レコードを論理削除（SoftDelete）
3. 成功通知を表示
4. 部署一覧画面へリダイレクト

### 03-表示ボタン押下（ヘッダーアクション）

1. 部署詳細画面へ遷移

### 04-Chatterボタン押下（ヘッダーアクション）

1. Chatterサイドパネルを開く
2. コメント、アクティビティ、フォロワー機能を利用可能

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | employees_departments | UPDATE | 部署レコードの更新 |
| 削除ボタン押下 | employees_departments | UPDATE | deleted_at設定（論理削除） |

### テーブル別更新項目詳細

#### employees_departments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | parent_id | フォーム選択値 | NULL許可 |
| UPDATE | manager_id | フォーム選択値 | NULL許可 |
| UPDATE | company_id | フォーム選択値 | NULL許可 |
| UPDATE | color | フォーム入力値 | NULL許可 |
| UPDATE | complete_name | 自動再生成 | Model Bootで設定 |
| UPDATE | parent_path | 自動再生成 | Model Bootで設定 |
| UPDATE | master_department_id | 自動再生成 | Model Bootで設定 |
| UPDATE | updated_at | CURRENT_TIMESTAMP | 自動設定 |
| DELETE | deleted_at | CURRENT_TIMESTAMP | 論理削除時 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | 本文 | 表示条件 |
|-------------|------|---------|------|----------|
| MSG-001 | 成功 | 更新完了 | 部署が正常に更新されました | 保存成功時 |
| MSG-002 | エラー | 更新エラー | （例外メッセージ） | 更新失敗時 |
| MSG-003 | 成功 | 削除完了 | 部署が削除されました | 削除成功時 |
| MSG-004 | エラー | 循環参照エラー | 部署の階層構造に循環参照が検出されました | 親部署が自己参照時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| 循環参照エラー | 親部署の選択で循環構造が発生 | エラーメッセージ表示、updateFailedフラグ設定 |
| レコード不存在 | URLの部署IDが存在しない | 404エラー画面表示 |
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 編集権限なし | 403エラー画面表示 |
| データベースエラー | DB接続失敗等 | エラーメッセージ表示、ログ記録 |

## 備考

- 編集画面ではupdateFailedフラグにより、エラー時のリダイレクト制御を実装
- Chatter機能により、部署に関するコメントやアクティビティを記録可能
- サブナビゲーションで詳細・編集・従業員管理画面を素早く切り替え可能
- 親部署変更時は子部署のcomplete_name、parent_pathも連動して更新される（要確認）
- 削除は論理削除（SoftDelete）であり、後から復元可能
