# 画面設計書 83-部署詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける部署詳細画面の設計仕様を定義します。従業員モジュールの一部として、部署の詳細情報を表示する読み取り専用画面です。

### 本画面の処理概要

**業務上の目的・背景**：
部署の情報を確認するための画面です。部署名、マネージャー、所属会社、組織階層などの情報を一目で把握できます。人事担当者や管理者が組織構造を確認したり、従業員の所属情報を参照する際に使用します。

**画面へのアクセス方法**：
1. 部署一覧画面から対象部署の行をクリック
2. 部署一覧画面から対象部署の「表示」アイコンをクリック
3. 部署作成・編集完了後の自動遷移

**主要な操作・処理内容**：
1. 部署情報の閲覧（部署名、マネージャー、会社、色）
2. 組織階層ツリーの表示（親部署がある場合）
3. 編集画面への遷移
4. 部署の削除
5. Chatter（コメント機能）でのコミュニケーション
6. サブナビゲーションでの関連画面切替

**画面遷移**：
- 遷移元：部署一覧画面（ListDepartments）、部署作成画面（CreateDepartment）、部署編集画面（EditDepartment）
- 遷移先：部署編集画面（EditDepartment）、部署従業員管理画面（ManageEmployee）

**権限による表示制御**：
- 部署閲覧権限を持つユーザーがアクセス可能
- 編集権限がある場合のみ編集ボタンが有効
- 削除権限がある場合のみ削除ボタンが有効

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-008 | 部門表示 | 主機能 | 部署詳細情報の表示 |
| FN-EMP-007 | 部門編集 | 遷移先機能 | 編集画面への遷移 |
| FN-EMP-005 | 部門一覧 | 遷移元機能 | 一覧からの遷移 |

## 画面種別

詳細画面（ViewRecord）

## URL/ルーティング

`/employees/departments/{record}`

## 画面構成

- ヘッダー：
  - 画面タイトル（部署名）
  - アクションボタン：Chatter、編集、削除
- サブナビゲーション：
  - 詳細タブ（アクティブ）
  - 編集タブ
  - 従業員タブ
- メインコンテンツ：
  - セクション「General」
    - 部署名（アイコン付き）
    - マネージャー名（アイコン付き）
    - 会社名（アイコン付き）
    - 色（カラー表示）
  - フィールドセット「組織階層」（親部署がある場合のみ表示）
    - 階層ツリー表示（HTMLフォーマット）

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

| 項目名 | 項目ID | 表示形式 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 部署名 | name | テキスト | heroicon-o-building-office-2 | 部署の名称 |
| マネージャー | manager.name | テキスト | heroicon-o-user | 部署責任者の従業員名 |
| 会社名 | company.name | テキスト | heroicon-o-building-office | 所属会社の名称 |
| 色 | color | カラー表示 | - | 表示色 |
| 組織階層 | hierarchy | HTMLツリー | - | 親部署から子部署までの階層構造 |

## イベント仕様

### 01-編集ボタン押下（ヘッダーアクション）

1. 部署編集画面へ遷移
2. 現在の部署レコードを編集モードで開く

### 02-削除ボタン押下（ヘッダーアクション）

1. 確認ダイアログを表示
2. 確認後、部署レコードを論理削除
3. 成功通知を表示
4. 部署一覧画面へリダイレクト

### 03-Chatterボタン押下（ヘッダーアクション）

1. Chatterサイドパネルを開く
2. コメント、アクティビティ、フォロワー機能を利用可能

### 04-サブナビゲーション選択

1. 選択したタブに対応する画面へ遷移
   - 編集：EditDepartment画面
   - 従業員：ManageEmployee画面

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | employees_departments | UPDATE | deleted_at設定（論理削除） |

### テーブル別更新項目詳細

#### employees_departments（削除時のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | deleted_at | CURRENT_TIMESTAMP | 論理削除 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | 本文 | 表示条件 |
|-------------|------|---------|------|----------|
| MSG-001 | 成功 | 削除完了 | 部署が削除されました | 削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| レコード不存在 | URLの部署IDが存在しない | 404エラー画面表示 |
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 閲覧権限なし | 403エラー画面表示 |

## 備考

- 組織階層ツリーは親部署が設定されている場合のみ表示
- 階層ツリーは最上位の親から現在の部署を含む全ての子部署を表示
- 現在表示中の部署はハイライト表示（太字・色付き）
- 各部署ノードにはメンバー数とマネージャー名も表示
- 階層構造はインデント付きのツリー形式（└── 記号使用）
- InfolistのColorEntryでHEXカラーを視覚的に表示
- サブナビゲーションはページ上部に配置（SubNavigationPosition::Top）
