# 画面設計書 84-部署従業員管理

## 概要

本ドキュメントは、Aureus ERPシステムにおける部署従業員管理画面の設計仕様を定義します。従業員モジュールの一部として、特定の部署に所属する従業員を一覧表示・管理するための関連レコード管理画面です。

### 本画面の処理概要

**業務上の目的・背景**：
部署に所属する従業員を一元的に管理するための画面です。人事担当者が特定部署のメンバーを確認したり、新規従業員を追加したりする際に使用します。部署単位での人員配置状況の把握や、組織変更時のメンバー確認に役立ちます。

**画面へのアクセス方法**：
1. 部署詳細画面からサブナビゲーションの「従業員」タブをクリック
2. 部署編集画面からサブナビゲーションの「従業員」タブをクリック

**主要な操作・処理内容**：
1. 部署所属従業員の一覧表示
2. 従業員情報の検索・フィルタリング
3. 新規従業員の作成（従業員作成画面への遷移）
4. 従業員詳細の表示（従業員詳細画面への遷移）
5. 従業員情報の編集（従業員編集画面への遷移）

**画面遷移**：
- 遷移元：部署詳細画面（ViewDepartment）、部署編集画面（EditDepartment）
- 遷移先：従業員作成画面（CreateEmployee）、従業員詳細画面（ViewEmployee）、従業員編集画面（EditEmployee）

**権限による表示制御**：
- 部署閲覧権限を持つユーザーがアクセス可能
- 従業員作成権限がある場合のみ新規作成ボタンが表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-008 | 部門表示 | 親機能 | 部署コンテキストでの表示 |
| FN-EMP-001 | 従業員一覧 | 補助機能 | 従業員一覧表示（部署フィルタ適用） |
| FN-EMP-002 | 従業員作成 | 遷移先機能 | 新規従業員作成 |
| FN-EMP-004 | 従業員表示 | 遷移先機能 | 従業員詳細表示 |
| FN-EMP-003 | 従業員編集 | 遷移先機能 | 従業員編集 |

## 画面種別

関連レコード管理画面（ManageRelatedRecords）

## URL/ルーティング

`/employees/departments/{record}/employees`

## 画面構成

- ヘッダー：
  - 画面タイトル（部署名）
  - 親リソースへの戻りリンク
- サブナビゲーション：
  - 詳細タブ
  - 編集タブ
  - 従業員タブ（アクティブ）
- ナビゲーションアイコン：heroicon-o-users
- テーブルヘッダー：
  - 新規作成ボタン
- メインコンテンツ：
  - 従業員一覧テーブル（EmployeeResourceのテーブル定義を再利用）
  - 検索フィルター
  - ページネーション
- 行アクション：
  - 表示ボタン
  - 編集ボタン

## 入出力項目

該当なし（関連レコード管理画面のため、入力はテーブルアクション経由）

## 表示項目

EmployeeResourceのテーブル定義を再利用するため、従業員一覧と同様の項目が表示されます：

| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 従業員名 | name | テキスト | 従業員の氏名 |
| 従業員番号 | employee_number | テキスト | 従業員コード |
| 職位 | jobPosition.name | テキスト | 職位名 |
| マネージャー | manager.name | テキスト | 直属上司名 |
| 勤務地 | workLocation.name | テキスト | 勤務地 |
| 雇用形態 | employmentType.name | テキスト | 雇用形態 |
| 入社日 | hire_date | 日付 | 入社日 |
| ステータス | status | バッジ | 在籍状況 |

## イベント仕様

### 01-新規作成ボタン押下（ヘッダーアクション）

1. 従業員作成画面（EmployeeResource::getUrl('create')）へ遷移
2. 新しいタブでは開かない（openUrlInNewTab: false）

### 02-表示アイコン押下（行アクション）

1. 従業員詳細画面（EmployeeResource::getUrl('view')）へ遷移
2. 対象の従業員レコードを表示

### 03-編集アイコン押下（行アクション）

1. 従業員編集画面（EmployeeResource::getUrl('edit')）へ遷移
2. 対象の従業員レコードを編集モードで開く

### 04-サブナビゲーション選択

1. 選択したタブに対応する画面へ遷移
   - 詳細：ViewDepartment画面
   - 編集：EditDepartment画面

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| （この画面では直接更新なし） | - | - | 遷移先画面で更新 |

この画面自体はデータベースを直接更新しません。従業員の作成・編集は遷移先の従業員リソース画面で行われます。

## メッセージ仕様

該当なし（この画面では通知メッセージなし）

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| レコード不存在 | URLの部署IDが存在しない | 404エラー画面表示 |
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 閲覧権限なし | 403エラー画面表示 |

## 備考

- DepartmentEmployeeトレイトを使用してテーブル定義を実装
- EmployeeResourceのtable()メソッドを再利用し、一貫したUI/UXを提供
- リレーション名は'employees'（Department::employees()）
- 行アクションは従業員リソースのURLを生成し、新規タブでは開かない設定
- 従業員一覧と同じテーブル構造・機能を使用するため、検索・フィルター・ソート機能も利用可能
- 部署のコンテキスト内で従業員を管理するため、自動的に部署フィルターが適用される
