# 画面設計書 85-スキルタイプ一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおけるスキルタイプ一覧画面の設計仕様を定義します。従業員モジュールの設定機能として、従業員に設定可能なスキルのカテゴリ（スキルタイプ）を管理する画面です。

### 本画面の処理概要

**業務上の目的・背景**：
従業員のスキルを体系的に管理するために、スキルのカテゴリ（タイプ）を定義します。例えば「プログラミング言語」「語学」「資格」などのスキルタイプを作成し、その配下に具体的なスキル（Java、英語、TOEIC等）を紐づけることで、従業員のスキルマトリクスを構築できます。

**画面へのアクセス方法**：
1. メインナビゲーションから「従業員」モジュールを選択
2. 設定（Configurations）クラスターを選択
3. サイドメニューから「スキルタイプ」を選択

**主要な操作・処理内容**：
1. スキルタイプの一覧表示
2. スキルタイプの検索・フィルタリング・ソート・グループ化
3. 新規スキルタイプの作成（モーダルフォーム）
4. スキルタイプの編集・詳細表示への遷移
5. スキルタイプの削除（論理削除）・復元・完全削除
6. タブ切替（全件/アーカイブ済み）

**画面遷移**：
- 遷移元：設定クラスターのナビゲーション
- 遷移先：スキルタイプ編集画面（EditSkillType）、スキルタイプ詳細画面（ViewSkillType）

**権限による表示制御**：
- スキルタイプ閲覧権限を持つユーザーがアクセス可能
- 作成・編集・削除権限に応じてアクションボタンの表示/非表示が制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-010 | スキルタイプ管理 | 主機能 | スキルタイプのCRUD操作 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

`/employees/configurations/skill-types`

## 画面構成

- ヘッダー：
  - 画面タイトル「スキルタイプ」
  - 新規作成ボタン（モーダル起動）
- タブナビゲーション：
  - 「すべて」タブ（件数バッジ付き）
  - 「アーカイブ済み」タブ（件数バッジ付き）
- フィルターエリア：
  - ステータスフィルター（三項選択）
  - クエリビルダーフィルター
- メインコンテンツ：
  - データテーブル
  - カラムトグル機能
  - グループ化機能
  - ページネーション
- 行アクション：
  - 表示
  - 編集
  - 削除
  - 復元（アーカイブタブのみ）
- 一括アクション：
  - 復元
  - 削除
  - 完全削除

## 入出力項目

### 新規作成モーダル入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 名前 | name | string | ○ | 255 | スキルタイプ名（ユニーク） |
| 作成者ID | creator_id | integer | ○ | - | 自動設定（Hidden） |
| 色 | color | string | - | - | 表示色（選択リスト） |
| ステータス | is_active | boolean | - | - | 有効/無効（デフォルト：有効） |

## 表示項目

| 項目名 | 項目ID | 表示形式 | ソート | 検索 | トグル |
|--------|--------|----------|--------|------|--------|
| ID | id | テキスト | ○ | ○ | 非表示（デフォルト） |
| 名前 | name | テキスト | ○ | ○ | - |
| 色 | color | カラーバッジ | ○ | - | - |
| スキル | skills.name | バッジ（複数） | - | ○ | - |
| レベル | skillLevels.name | バッジ（グレー） | - | ○ | - |
| ステータス | is_active | アイコン（○/×） | ○ | - | - |
| 作成者 | createdBy.name | テキスト | ○ | - | 非表示（デフォルト） |
| 作成日時 | created_at | 日時 | ○ | - | 非表示（デフォルト） |
| 更新日時 | updated_at | 日時 | ○ | - | 非表示（デフォルト） |

## イベント仕様

### 01-新規作成ボタン押下

1. 作成モーダルを表示
2. フォーム入力後、保存で新規レコード作成
3. 作成成功後、スキルタイプ編集画面へリダイレクト
4. 成功通知を表示

### 02-行アクション：表示

1. スキルタイプ詳細画面へ遷移

### 03-行アクション：編集

1. スキルタイプ編集画面へ遷移

### 04-行アクション：削除

1. 確認ダイアログを表示
2. 論理削除（deleted_at設定）
3. 成功通知を表示
4. 「アーカイブ済み」タブに移動

### 05-行アクション：復元

1. アーカイブ済みタブで表示
2. deleted_atをnullに設定
3. 成功通知を表示
4. 「すべて」タブに復帰

### 06-タブ切替

1. 「すべて」：全件表示（論理削除除く）
2. 「アーカイブ済み」：論理削除済みのみ表示（onlyTrashed）

### 07-一括アクション

1. 選択したレコードに対して復元/削除/完全削除を実行
2. 成功通知を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | employees_skill_types | INSERT | スキルタイプ作成 |
| 削除 | employees_skill_types | UPDATE | deleted_at設定 |
| 復元 | employees_skill_types | UPDATE | deleted_at=null |
| 完全削除 | employees_skill_types | DELETE | 物理削除 |

### テーブル別更新項目詳細

#### employees_skill_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | ユニーク制約 |
| INSERT | color | フォーム選択値 | NULL許可 |
| INSERT | is_active | フォーム入力値 | デフォルト：true |
| INSERT | creator_id | Auth::user()->id | ログインユーザー |
| INSERT | created_at | CURRENT_TIMESTAMP | 自動設定 |
| UPDATE | deleted_at | CURRENT_TIMESTAMP | 論理削除時 |
| UPDATE | deleted_at | null | 復元時 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | 本文 | 表示条件 |
|-------------|------|---------|------|----------|
| MSG-001 | 成功 | 作成完了 | スキルタイプが作成されました | 新規作成成功時 |
| MSG-002 | 成功 | 削除完了 | スキルタイプが削除されました | 削除成功時 |
| MSG-003 | 成功 | 復元完了 | スキルタイプが復元されました | 復元成功時 |
| MSG-004 | 成功 | 完全削除完了 | スキルタイプが完全に削除されました | 完全削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ユニーク制約違反 | 同名スキルタイプが存在 | バリデーションエラー表示 |
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 閲覧権限なし | 403エラー画面表示 |

## 備考

- 色の選択肢はColors Enumから取得（Tailwind CSSカラーパレット）
- スキルタイプ配下のスキル・スキルレベルはバッジで表示
- スキルの色はスキルタイプの色を継承
- スキルレベルはグレーのバッジで表示
- カラム表示/非表示はカラムトグル機能で切り替え可能（2カラムレイアウト）
- グループ化機能で名前、色、作成者、ステータス、作成日、更新日でグループ可能
- クエリビルダーフィルターで詳細な絞り込みが可能
