# 画面設計書 86-スキルタイプ編集

## 概要

本ドキュメントは、Aureus ERPシステムにおけるスキルタイプ編集画面の設計仕様を定義します。従業員モジュールの設定機能として、既存のスキルタイプ情報を変更するためのフォーム画面です。

### 本画面の処理概要

**業務上の目的・背景**：
スキルタイプの名称変更、色の変更、有効/無効ステータスの切り替えなど、スキルタイプの属性を更新する必要がある場合に使用します。また、関連するスキルやスキルレベルの管理もこの画面から行えます。

**画面へのアクセス方法**：
1. スキルタイプ一覧画面で対象行の「編集」アイコンをクリック
2. スキルタイプ詳細画面のヘッダーから「編集」ボタンをクリック
3. スキルタイプ新規作成成功後の自動リダイレクト

**主要な操作・処理内容**：
1. スキルタイプ名の変更
2. 表示色の変更
3. 有効/無効ステータスの切り替え
4. 関連スキルの管理（RelationManager）
5. 関連スキルレベルの管理（RelationManager）
6. スキルタイプの削除

**画面遷移**：
- 遷移元：スキルタイプ一覧画面（ListSkillTypes）、スキルタイプ詳細画面（ViewSkillType）
- 遷移先：スキルタイプ詳細画面（ViewSkillType）- 保存成功後

**権限による表示制御**：
- スキルタイプ編集権限を持つユーザーがアクセス可能
- 削除権限がある場合のみ削除ボタンが表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-010 | スキルタイプ管理 | 主機能 | スキルタイプの更新・削除 |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

`/employees/configurations/skill-types/{record}/edit`

## 画面構成

- ヘッダー：
  - 画面タイトル（スキルタイプ名）
  - アクションボタン：表示、削除
- サブナビゲーション：
  - Configurationsクラスター内の他リソースへのナビゲーション
- メインコンテンツ：
  - セクション（2カラムレイアウト）
    - 名前入力フィールド
    - 作成者ID（Hidden）
    - 色選択フィールド
    - ステータストグル
  - リレーションマネージャー：スキル一覧
  - リレーションマネージャー：スキルレベル一覧
- フッター：
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 名前 | name | string | ○ | 255 | スキルタイプ名（ユニーク） |
| 作成者ID | creator_id | integer | ○ | - | 変更不可（Hidden） |
| 色 | color | string | - | - | 表示色（選択リスト） |
| ステータス | is_active | boolean | - | - | 有効/無効 |

## 表示項目

リレーションマネージャーでスキルとスキルレベルを表示：

### スキル一覧（SkillsRelationManager）
| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 名前 | name | テキスト | スキル名 |
| 作成日 | created_at | 日時 | 作成日時 |

### スキルレベル一覧（SkillLevelRelationManager）
| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 名前 | name | テキスト | レベル名 |
| レベル | level | 数値 | 習熟度レベル |
| 作成日 | created_at | 日時 | 作成日時 |

## イベント仕様

### 01-保存ボタン押下

1. 入力バリデーションを実行
   - 名前の必須チェック
   - 名前のユニークチェック
2. バリデーション成功時：
   - スキルタイプレコードを更新
   - 成功通知を表示
   - スキルタイプ詳細画面へリダイレクト
3. バリデーション失敗時：
   - エラーメッセージを表示
   - 画面に留まる

### 02-表示ボタン押下（ヘッダーアクション）

1. スキルタイプ詳細画面へ遷移

### 03-削除ボタン押下（ヘッダーアクション）

1. 確認ダイアログを表示
2. 確認後、スキルタイプを論理削除
3. 成功通知を表示
4. スキルタイプ一覧画面へリダイレクト

### 04-スキル追加（RelationManager）

1. スキル作成モーダルを表示
2. スキル名を入力
3. 保存でスキルレコードを作成（skill_type_idを自動設定）

### 05-スキルレベル追加（RelationManager）

1. スキルレベル作成モーダルを表示
2. レベル名とレベル値を入力
3. 保存でスキルレベルレコードを作成（skill_type_idを自動設定）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | employees_skill_types | UPDATE | スキルタイプ更新 |
| 削除ボタン押下 | employees_skill_types | UPDATE | deleted_at設定 |
| スキル追加 | employees_skills | INSERT | スキル作成 |
| スキルレベル追加 | employees_skill_levels | INSERT | スキルレベル作成 |

### テーブル別更新項目詳細

#### employees_skill_types

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | ユニーク制約 |
| UPDATE | color | フォーム選択値 | NULL許可 |
| UPDATE | is_active | フォーム入力値 | - |
| UPDATE | updated_at | CURRENT_TIMESTAMP | 自動設定 |
| DELETE | deleted_at | CURRENT_TIMESTAMP | 論理削除時 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | 本文 | 表示条件 |
|-------------|------|---------|------|----------|
| MSG-001 | 成功 | 更新完了 | スキルタイプが更新されました | 保存成功時 |
| MSG-002 | 成功 | 削除完了 | スキルタイプが削除されました | 削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| ユニーク制約違反 | 同名スキルタイプが存在 | バリデーションエラー表示 |
| レコード不存在 | URLのスキルタイプIDが存在しない | 404エラー画面表示 |
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 編集権限なし | 403エラー画面表示 |

## 備考

- getSubNavigation()でConfigurationsクラスター内の他リソースへのナビゲーションを提供
- リレーションマネージャーでスキルとスキルレベルをインライン管理
- SkillsRelationManager：従業員が持つ具体的なスキルを管理
- SkillLevelRelationManager：スキルの習熟度レベルを管理（初級、中級、上級など）
- スキルの色はスキルタイプの色を継承して表示
- 削除は論理削除であり、復元可能
