# 画面設計書 87-スキルタイプ詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおけるスキルタイプ詳細画面の設計仕様を定義します。従業員モジュールの設定機能として、スキルタイプの詳細情報を表示する読み取り専用画面です。

### 本画面の処理概要

**業務上の目的・背景**：
スキルタイプの情報を確認するための画面です。スキルタイプ名、色、有効ステータスを一目で確認でき、関連するスキルやスキルレベルの一覧も表示されます。人事担当者がスキル体系を確認したり、従業員のスキル評価時に参照する際に使用します。

**画面へのアクセス方法**：
1. スキルタイプ一覧画面で対象行の「表示」アイコンをクリック
2. スキルタイプ編集画面のヘッダーから「表示」ボタンをクリック
3. スキルタイプ編集完了後の自動リダイレクト

**主要な操作・処理内容**：
1. スキルタイプ情報の閲覧（名前、色、ステータス）
2. 関連スキル一覧の表示（リレーションマネージャー）
3. 関連スキルレベル一覧の表示（リレーションマネージャー）
4. 編集画面への遷移
5. スキルタイプの削除

**画面遷移**：
- 遷移元：スキルタイプ一覧画面（ListSkillTypes）、スキルタイプ編集画面（EditSkillType）
- 遷移先：スキルタイプ編集画面（EditSkillType）

**権限による表示制御**：
- スキルタイプ閲覧権限を持つユーザーがアクセス可能
- 編集権限がある場合のみ編集ボタンが有効
- 削除権限がある場合のみ削除ボタンが有効

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-010 | スキルタイプ管理 | 主機能 | スキルタイプ詳細の表示・削除 |

## 画面種別

詳細画面（ViewRecord）

## URL/ルーティング

`/employees/configurations/skill-types/{record}`

## 画面構成

- ヘッダー：
  - 画面タイトル（スキルタイプ名）
  - アクションボタン：編集、削除
- サブナビゲーション：
  - Configurationsクラスター内の他リソースへのナビゲーション
- メインコンテンツ：
  - セクション（3カラムレイアウト）
    - 名前表示
    - 色表示（カラーバッジ）
    - ステータス表示（アイコン）
  - リレーションマネージャー：スキル一覧
  - リレーションマネージャー：スキルレベル一覧

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

### 基本情報

| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 名前 | name | テキスト | スキルタイプ名 |
| 色 | color | カラーバッジ（HTML） | 表示色（円形バッジ） |
| ステータス | is_active | アイコン（○/×） | 有効/無効 |

### スキル一覧（SkillsRelationManager）
| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 名前 | name | テキスト | スキル名 |
| 作成日 | created_at | 日時 | 作成日時 |

### スキルレベル一覧（SkillLevelRelationManager）
| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| 名前 | name | テキスト | レベル名 |
| レベル | level | 数値 | 習熟度レベル |
| 作成日 | created_at | 日時 | 作成日時 |

## イベント仕様

### 01-編集ボタン押下（ヘッダーアクション）

1. スキルタイプ編集画面へ遷移
2. 現在のスキルタイプレコードを編集モードで開く

### 02-削除ボタン押下（ヘッダーアクション）

1. 確認ダイアログを表示
2. 確認後、スキルタイプを論理削除
3. 成功通知を表示
4. スキルタイプ一覧画面へリダイレクト

### 03-サブナビゲーション選択

1. Configurationsクラスター内の選択されたリソース画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | employees_skill_types | UPDATE | deleted_at設定（論理削除） |

### テーブル別更新項目詳細

#### employees_skill_types（削除時のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | deleted_at | CURRENT_TIMESTAMP | 論理削除 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | 本文 | 表示条件 |
|-------------|------|---------|------|----------|
| MSG-001 | 成功 | 削除完了 | スキルタイプが削除されました | 削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| レコード不存在 | URLのスキルタイプIDが存在しない | 404エラー画面表示 |
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 閲覧権限なし | 403エラー画面表示 |

## 備考

- Infolistでスキルタイプの基本情報を表示
- 色はHTMLでカラーサークルとして表示（formatStateUsing使用）
- is_activeはIconEntryでブール値をアイコン表示
- 3カラムレイアウトでコンパクトに情報表示
- getSubNavigation()でConfigurationsクラスター内の他リソースへのナビゲーションを提供
- リレーションマネージャーでスキルとスキルレベルを閲覧・管理可能
- 詳細画面でもリレーションマネージャーからスキル・スキルレベルの追加・編集が可能
