# 画面設計書 88-アクティビティプラン一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおけるアクティビティプラン一覧画面の設計仕様を定義します。従業員モジュールの設定機能として、従業員に関連するアクティビティプラン（タスク・活動計画）を管理する画面です。

### 本画面の処理概要

**業務上の目的・背景**：
アクティビティプランは、従業員の入社時、異動時、退職時などの特定のイベントに対して実行すべきタスクや活動を事前に定義したテンプレートです。例えば「新入社員オンボーディング」プランには、「PCセットアップ」「社内システム登録」「部署紹介」などのアクティビティが含まれます。これにより、人事業務の標準化と効率化を実現します。

**画面へのアクセス方法**：
1. メインナビゲーションから「従業員」モジュールを選択
2. 設定（Configurations）クラスターを選択
3. サイドメニューから「アクティビティプラン」を選択

**主要な操作・処理内容**：
1. アクティビティプランの一覧表示
2. アクティビティプランの検索・フィルタリング・ソート・グループ化
3. 新規アクティビティプランの作成（モーダルフォーム）
4. アクティビティプランの編集・詳細表示への遷移
5. アクティビティプランの削除（論理削除）・復元・完全削除
6. タブ切替（全件/アーカイブ済み）

**画面遷移**：
- 遷移元：設定クラスターのナビゲーション
- 遷移先：アクティビティプラン編集画面（EditActivityPlan）、アクティビティプラン詳細画面（ViewActivityPlan）

**権限による表示制御**：
- アクティビティプラン閲覧権限を持つユーザーがアクセス可能
- 作成・編集・削除権限に応じてアクションボタンの表示/非表示が制御

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-016 | 活動プラン管理 | 主機能 | アクティビティプランのCRUD操作 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

`/employees/configurations/activity-plans`

## 画面構成

- ヘッダー：
  - 画面タイトル「アクティビティプラン」
  - 新規作成ボタン（モーダル起動）
- タブナビゲーション：
  - 「すべて」タブ（件数バッジ付き）
  - 「アーカイブ済み」タブ（件数バッジ付き）
- フィルターエリア：
  - ステータスフィルター（三項選択）
  - クエリビルダーフィルター
- メインコンテンツ：
  - データテーブル（カラム並べ替え可能）
  - カラムマネージャー（2カラム）
  - グループ化機能
  - ページネーション
- 行アクション：
  - 表示（アーカイブ時は非表示）
  - 編集（アーカイブ時は非表示）
  - 削除
  - 復元（アーカイブ時のみ）
  - 完全削除（アーカイブ時のみ）
- 一括アクション：
  - 復元
  - 削除
  - 完全削除

## 入出力項目

### 新規作成モーダル入力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 名前 | name | string | ○ | 255 | アクティビティプラン名 |
| 部署 | department_id | integer | - | - | 対象部署 |
| 会社 | company_id | integer | - | - | 対象会社 |
| ステータス | is_active | boolean | - | - | 有効/無効（デフォルト：有効） |
| プラグイン | plugin | string | ○ | - | 自動設定（'employees'） |
| 作成者ID | creator_id | integer | ○ | - | 自動設定（Auth::user()->id） |

## 表示項目

| 項目名 | 項目ID | 表示形式 | ソート | 検索 | トグル |
|--------|--------|----------|--------|------|--------|
| 名前 | name | テキスト | - | ○ | - |
| 部署 | department.name | テキスト | ○ | - | - |
| マネージャー | department.manager.name | テキスト | ○ | - | - |
| 会社 | company.name | テキスト | ○ | - | - |
| ステータス | is_active | アイコン（○/×） | ○ | - | - |
| 作成者 | createdBy.name | テキスト | ○ | - | 非表示（デフォルト） |
| 作成日時 | created_at | 日時 | ○ | - | 非表示（デフォルト） |
| 更新日時 | updated_at | 日時 | ○ | - | 非表示（デフォルト） |

## イベント仕様

### 01-新規作成ボタン押下

1. 作成モーダルを表示
2. フォーム入力を受け付け
3. 保存時にmutateDataUsingでplugin='employees'、creator_id、company_idを自動設定
4. 保存でアクティビティプランレコード作成
5. 成功通知を表示

### 02-行アクション：表示

1. アクティビティプラン詳細画面へ遷移
2. 論理削除済みレコードでは非表示

### 03-行アクション：編集

1. アクティビティプラン編集画面へ遷移
2. 論理削除済みレコードでは非表示

### 04-行アクション：削除

1. 確認ダイアログを表示
2. 論理削除（deleted_at設定）
3. 成功通知を表示

### 05-行アクション：復元

1. deleted_atをnullに設定
2. 成功通知を表示
3. 「すべて」タブに復帰

### 06-行アクション：完全削除

1. 確認ダイアログを表示
2. 物理削除（レコード完全削除）
3. 成功通知を表示

### 07-タブ切替

1. 「すべて」：plugin='employees'かつ論理削除除く
2. 「アーカイブ済み」：plugin='employees'かつ論理削除済みのみ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | activity_plans | INSERT | プラン作成 |
| 削除 | activity_plans | UPDATE | deleted_at設定 |
| 復元 | activity_plans | UPDATE | deleted_at=null |
| 完全削除 | activity_plans | DELETE | 物理削除 |

### テーブル別更新項目詳細

#### activity_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | department_id | フォーム選択値 | NULL許可 |
| INSERT | company_id | フォーム選択値またはユーザーデフォルト会社 | - |
| INSERT | is_active | フォーム入力値 | デフォルト：true |
| INSERT | plugin | 'employees' | 自動設定 |
| INSERT | creator_id | Auth::user()->id | 自動設定 |
| INSERT | created_at | CURRENT_TIMESTAMP | 自動設定 |
| UPDATE | deleted_at | CURRENT_TIMESTAMP | 論理削除時 |
| UPDATE | deleted_at | null | 復元時 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | 本文 | 表示条件 |
|-------------|------|---------|------|----------|
| MSG-001 | 成功 | 作成完了 | アクティビティプランが作成されました | 新規作成成功時 |
| MSG-002 | 成功 | 削除完了 | アクティビティプランが削除されました | 削除成功時 |
| MSG-003 | 成功 | 復元完了 | アクティビティプランが復元されました | 復元成功時 |
| MSG-004 | 成功 | 完全削除完了 | アクティビティプランが完全に削除されました | 完全削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 閲覧権限なし | 403エラー画面表示 |

## 備考

- modifyQueryUsingでplugin='employees'のレコードのみ表示
- 複数のプラグイン（employees、recruitments、sales等）で共通のActivityPlanテーブルを使用
- pluginカラムでプラグインごとのデータを分離
- 部署選択時にDepartmentResourceのフォームを再利用（createOptionForm/editOptionForm）
- 会社選択時にCompanyResourceのフォームを再利用
- 削除済み会社は「(Deleted)」表示で選択不可
- reorderableColumnsでカラムの並べ替えが可能
- columnManagerColumns(2)で2カラムのカラム管理UI
