# 画面設計書 89-アクティビティプラン編集

## 概要

本ドキュメントは、Aureus ERPシステムにおけるアクティビティプラン編集画面の設計仕様を定義します。従業員モジュールの設定機能として、既存のアクティビティプラン情報を変更するためのフォーム画面です。

### 本画面の処理概要

**業務上の目的・背景**：
アクティビティプランの名称変更、対象部署・会社の変更、有効/無効ステータスの切り替えなど、プランの属性を更新する必要がある場合に使用します。また、プランに含まれるアクティビティテンプレート（具体的なタスク定義）の管理もこの画面から行えます。

**画面へのアクセス方法**：
1. アクティビティプラン一覧画面で対象行の「編集」アイコンをクリック
2. アクティビティプラン詳細画面のヘッダーから「編集」ボタンをクリック

**主要な操作・処理内容**：
1. プラン名の変更
2. 対象部署の変更
3. 対象会社の変更
4. 有効/無効ステータスの切り替え
5. アクティビティテンプレートの管理（RelationManager）
6. プランの削除

**画面遷移**：
- 遷移元：アクティビティプラン一覧画面（ListActivityPlans）、アクティビティプラン詳細画面（ViewActivityPlan）
- 遷移先：アクティビティプラン詳細画面（ViewActivityPlan）- 保存成功後

**権限による表示制御**：
- アクティビティプラン編集権限を持つユーザーがアクセス可能
- 削除権限がある場合のみ削除ボタンが表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-016 | 活動プラン管理 | 主機能 | アクティビティプランの更新・削除 |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

`/employees/configurations/activity-plans/{record}/edit`

## 画面構成

- ヘッダー：
  - 画面タイトル（プラン名）
  - アクションボタン：表示、削除
- サブナビゲーション：
  - Configurationsクラスター内の他リソースへのナビゲーション
- メインコンテンツ：
  - セクション「General」（2カラムレイアウト）
    - 名前入力フィールド
    - 部署選択フィールド
    - 会社選択フィールド
    - ステータストグル
  - リレーションマネージャー：アクティビティテンプレート一覧
- フッター：
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 型 | 必須 | 最大長 | 説明 |
|--------|--------|-----|------|--------|------|
| 名前 | name | string | ○ | 255 | アクティビティプラン名 |
| 部署 | department_id | integer | - | - | 対象部署 |
| 会社 | company_id | integer | - | - | 対象会社 |
| ステータス | is_active | boolean | - | - | 有効/無効 |

## 表示項目

### アクティビティテンプレート一覧（ActivityTemplateRelationManager）
| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| アクティビティタイプ | activityType.name | テキスト | アクティビティの種類 |
| サマリー | summary | テキスト | タスクの概要 |
| 担当者タイプ | responsible_type | テキスト | 誰が担当するか |
| 期限 | due_days | 数値 | 何日後が期限か |

## イベント仕様

### 01-保存ボタン押下

1. 入力バリデーションを実行
   - 名前の必須チェック
2. バリデーション成功時：
   - アクティビティプランレコードを更新
   - 成功通知を表示
   - アクティビティプラン詳細画面へリダイレクト
3. バリデーション失敗時：
   - エラーメッセージを表示
   - 画面に留まる

### 02-表示ボタン押下（ヘッダーアクション）

1. アクティビティプラン詳細画面へ遷移

### 03-削除ボタン押下（ヘッダーアクション）

1. 確認ダイアログを表示
2. 確認後、アクティビティプランを論理削除
3. 成功通知を表示
4. アクティビティプラン一覧画面へリダイレクト

### 04-アクティビティテンプレート追加（RelationManager）

1. テンプレート作成モーダルを表示
2. アクティビティタイプ、サマリー、担当者、期限などを入力
3. 保存でテンプレートレコードを作成（plan_idを自動設定）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | activity_plans | UPDATE | プラン更新 |
| 削除ボタン押下 | activity_plans | UPDATE | deleted_at設定 |
| テンプレート追加 | activity_plan_templates | INSERT | テンプレート作成 |

### テーブル別更新項目詳細

#### activity_plans

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | department_id | フォーム選択値 | NULL許可 |
| UPDATE | company_id | フォーム選択値 | NULL許可 |
| UPDATE | is_active | フォーム入力値 | - |
| UPDATE | updated_at | CURRENT_TIMESTAMP | 自動設定 |
| DELETE | deleted_at | CURRENT_TIMESTAMP | 論理削除時 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | 本文 | 表示条件 |
|-------------|------|---------|------|----------|
| MSG-001 | 成功 | 更新完了 | アクティビティプランが更新されました | 保存成功時 |
| MSG-002 | 成功 | 削除完了 | アクティビティプランが削除されました | 削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| レコード不存在 | URLのプランIDが存在しない | 404エラー画面表示 |
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 編集権限なし | 403エラー画面表示 |

## 備考

- getSubNavigation()でConfigurationsクラスター内の他リソースへのナビゲーションを提供
- ActivityTemplateRelationManagerでアクティビティテンプレートをインライン管理
- アクティビティテンプレートには以下を定義可能：
  - アクティビティタイプ（メール送信、ミーティング、タスクなど）
  - サマリー（タスクの概要）
  - 担当者タイプ（マネージャー、HR担当者など）
  - 期限（プラン発動から何日後）
- 部署選択時にDepartmentResourceのフォームを再利用
- 会社選択時にCompanyResourceのフォームを再利用
- 削除済み会社は「(Deleted)」表示で選択不可
- 削除は論理削除であり、復元可能
