# 画面設計書 9-請求書編集

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける仕入先請求書編集画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、既存の仕入先請求書を編集するためのフォーム画面です。請求書の各項目を変更し、データベースのレコードを更新します。また、ステータスに応じた各種アクション（確認、支払登録、キャンセル等）を実行できます。

**業務上の目的・背景**：仕入先請求書の登録後、内容の訂正や追加情報の入力が必要になることがあります。本画面により、請求書情報の修正、明細行の追加・削除、支払処理の開始など、請求書ライフサイクル全体の管理が可能となります。

**画面へのアクセス方法**：請求書一覧画面の行アクションから「編集」を選択、または請求書詳細画面のヘッダーにある「編集」ボタンをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 既存の請求書情報の確認・修正
2. 請求明細行の追加・編集・削除
3. 支払情報の更新
4. 各種アクション実行（確認、支払、キャンセル、下書きに戻す等）
5. チャット/コメント機能
6. クレジットノートの作成
7. 削除操作

**画面遷移**：
- 本画面から遷移可能：請求書詳細画面（保存成功時）、クレジットノート作成画面
- 本画面への遷移元：請求書一覧画面、請求書詳細画面

**権限による表示制御**：仕入先請求書の編集権限を持つユーザーのみアクセス可能です。各アクションは請求書のステータスに応じて表示/非表示が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-007 | 仕入請求書編集 | 主機能 | 既存仕入請求書の編集 |
| FN-ACC-005 | 仕入請求書一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-ACC-008 | 仕入請求書表示 | 遷移先機能 | 保存後の詳細画面 |

## 画面種別

編集

## URL/ルーティング

`/accounts/bills/{record}/edit`

## 画面構成

- ステータスステッパー：請求書のステータス表示
- ヘッダーアクション：チャット、支払、確認、キャンセル、下書きに戻す、確認済み設定、クレジットノート作成、削除
- 一般情報セクション：支払状態バッジ、仕入先、日付、参照番号等
- タブセクション
  - 請求明細タブ：商品・サービスの明細行リピーター、合計サマリー
  - その他情報タブ：インコタームズ、支払方法、会社、通貨設定
  - 利用規約タブ：備考・条件のリッチテキストエディタ

## 入出力項目

### 一般情報セクション

| No | 項目名 | 物理名 | 型 | 必須 | 編集可否 | 説明 |
|----|--------|--------|-----|------|---------|------|
| 1 | ステータス | state | enum | - | 不可 | 請求書ステータス（ProgressStepper） |
| 2 | 仕入先 | partner_id | integer | - | 条件付き | POSTED/CANCEL時は編集不可 |
| 3 | 請求日 | invoice_date | date | - | 条件付き | POSTED/CANCEL時は編集不可 |
| 4 | 請求書参照 | reference | string | - | 条件付き | POSTED/CANCEL時は編集不可 |
| 5 | 会計日 | date | date | - | 条件付き | POSTED/CANCEL時は編集不可 |
| 6 | 支払参照 | payment_reference | string | - | 条件付き | POSTED/CANCEL時は編集不可 |
| 7 | 支払先銀行 | partner_bank_id | integer | - | 条件付き | POSTED/CANCEL時は編集不可 |
| 8 | 支払期日 | invoice_date_due | date | 条件付き | 可 | 支払条件未設定時のみ表示 |
| 9 | 支払条件 | invoice_payment_term_id | integer | 条件付き | 可 | |

### 請求明細タブ

作成画面と同様の項目。ただし、POSTED/CANCEL状態では編集不可。

### その他情報タブ

作成画面と同様の項目。ただし、auto_postはPOSTED/CANCEL状態では編集不可。

### 利用規約タブ

作成画面と同様。

## 表示項目

### 支払状態バッジ

| 値 | 表示色 | アイコン | 条件 |
|----|-------|---------|------|
| PAID | 緑 | チェック | 支払完了時 |
| REVERSED | - | - | 反転時 |

## イベント仕様

### 1-チャットアクション（ChatterAction）

チャット/コメント機能を呼び出し、請求書に関するコミュニケーションを記録します。

### 2-支払アクション（PayAction）

請求書に対する支払を登録するダイアログを表示します。

### 3-確認アクション（ConfirmAction）

下書き状態の請求書を確認済み（POSTED）状態に変更します。仕訳が生成されます。

### 4-キャンセルアクション（CancelAction）

請求書をキャンセル状態に変更します。

### 5-下書きに戻すアクション（ResetToDraftAction）

キャンセル済みまたは確認済みの請求書を下書き状態に戻します。

### 6-確認済み設定アクション（SetAsCheckedAction）

請求書を確認済みとしてマークします。

### 7-印刷・送信アクション（PrintAndSendAction）

請求書を印刷または送信します。

### 8-クレジットノート作成（CreditNoteAction）

この請求書に対するクレジットノート（貸方票）を作成します。

### 9-削除アクション

請求書を削除します。確認ダイアログ表示後に実行されます。

### 10-保存ボタン押下

フォームのバリデーションを実行し、成功した場合はデータベースのレコードを更新します。更新後、Account::computeAccountMove()で会計計算が再実行され、詳細画面へ自動遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_moves | UPDATE | 請求書レコードを更新 |
| 保存ボタン押下 | accounts_move_lines | SYNC | 明細行レコードを同期 |
| 確認アクション | accounts_moves | UPDATE | state = POSTED |
| キャンセルアクション | accounts_moves | UPDATE | state = CANCEL |
| 削除アクション | accounts_moves | DELETE | 請求書レコードを削除 |

### テーブル別更新項目詳細

#### accounts_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | partner_id | フォーム選択値または既存値 | |
| UPDATE | invoice_date | フォーム入力値または既存値 | |
| UPDATE | name | フォーム入力値または既存値 | |
| UPDATE | auto_post | フォーム入力値または既存値 | |
| UPDATE | invoice_currency_rate | フォーム入力値または1.0 | |
| UPDATE | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 請求書が更新されました | 保存成功時 |
| MSG-002 | 成功 | 請求書が確認されました | 確認アクション成功時 |
| MSG-003 | 成功 | 請求書がキャンセルされました | キャンセル成功時 |
| MSG-004 | 成功 | 請求書が削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 必須項目未入力 | フォームエラー表示 | 必須項目を入力してください |
| レコード未存在 | 404エラー表示 | 指定されたデータが見つかりません |
| ステータス不整合 | エラー通知表示 | この操作は現在のステータスでは実行できません |
| データベースエラー | エラー通知表示 | データの保存に失敗しました |

## 備考

- 本画面はFilament PHPのEditRecordを継承して実装されています
- HasRecordNavigationTabsトレイトでタブナビゲーションを実装
- HasRepeaterColumnManagerトレイトで明細行の列管理機能を実装
- 保存成功後は自動的に詳細画面（ViewBill）へリダイレクトされます
- フォーム構成はBillResource::form()を使用
- 編集画面固有のアクションとしてChatterAction、PayAction、ConfirmAction等がヘッダーに配置
- POSTED（確認済み）またはCANCEL状態では、多くの項目が編集不可になります
- 保存時にpartner_id, invoice_date, name, auto_postが未設定の場合、既存値を維持
- 保存後にAccount::computeAccountMove()で会計計算が再実行されます
