# 画面設計書 90-アクティビティプラン詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおけるアクティビティプラン詳細画面の設計仕様を定義します。従業員モジュールの設定機能として、アクティビティプランの詳細情報を表示する読み取り専用画面です。

### 本画面の処理概要

**業務上の目的・背景**：
アクティビティプランの情報を確認するための画面です。プラン名、対象部署・会社、有効ステータスを一目で確認でき、関連するアクティビティテンプレート（具体的なタスク定義）の一覧も表示されます。人事担当者がプランの内容を確認したり、プラン適用前のレビュー時に使用します。

**画面へのアクセス方法**：
1. アクティビティプラン一覧画面で対象行の「表示」アイコンをクリック
2. アクティビティプラン編集画面のヘッダーから「表示」ボタンをクリック
3. アクティビティプラン編集完了後の自動リダイレクト

**主要な操作・処理内容**：
1. プラン情報の閲覧（名前、部署、マネージャー、会社、ステータス）
2. 関連アクティビティテンプレート一覧の表示（リレーションマネージャー）
3. 編集画面への遷移
4. プランの削除

**画面遷移**：
- 遷移元：アクティビティプラン一覧画面（ListActivityPlans）、アクティビティプラン編集画面（EditActivityPlan）
- 遷移先：アクティビティプラン編集画面（EditActivityPlan）

**権限による表示制御**：
- アクティビティプラン閲覧権限を持つユーザーがアクセス可能
- 編集権限がある場合のみ編集ボタンが有効
- 削除権限がある場合のみ削除ボタンが有効

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-016 | 活動プラン管理 | 主機能 | アクティビティプラン詳細の表示・削除 |

## 画面種別

詳細画面（ViewRecord）

## URL/ルーティング

`/employees/configurations/activity-plans/{record}`

## 画面構成

- ヘッダー：
  - 画面タイトル（プラン名）
  - アクションボタン：編集、削除
- サブナビゲーション：
  - Configurationsクラスター内の他リソースへのナビゲーション
- メインコンテンツ：
  - セクション「General」（2カラムレイアウト）
    - 名前表示（アイコン付き）
    - 部署名表示（アイコン付き）
    - マネージャー名表示（アイコン付き）
    - 会社名表示（アイコン付き）
    - ステータス表示（アイコン）
  - リレーションマネージャー：アクティビティテンプレート一覧

## 入出力項目

該当なし（詳細表示画面のため入力項目なし）

## 表示項目

### 基本情報

| 項目名 | 項目ID | 表示形式 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 名前 | name | テキスト | heroicon-o-briefcase | プラン名 |
| 部署 | department.name | テキスト | heroicon-o-building-office-2 | 対象部署名 |
| マネージャー | department.manager.name | テキスト | heroicon-o-user | 部署マネージャー名 |
| 会社 | company.name | テキスト | heroicon-o-building-office | 対象会社名 |
| ステータス | is_active | アイコン（○/×） | - | 有効/無効 |

### アクティビティテンプレート一覧（ActivityTemplateRelationManager）
| 項目名 | 項目ID | 表示形式 | 説明 |
|--------|--------|----------|------|
| アクティビティタイプ | activityType.name | テキスト | アクティビティの種類 |
| サマリー | summary | テキスト | タスクの概要 |
| 担当者タイプ | responsible_type | テキスト | 誰が担当するか |
| 期限 | due_days | 数値 | 何日後が期限か |

## イベント仕様

### 01-編集ボタン押下（ヘッダーアクション）

1. アクティビティプラン編集画面へ遷移
2. 現在のプランレコードを編集モードで開く

### 02-削除ボタン押下（ヘッダーアクション）

1. 確認ダイアログを表示
2. 確認後、プランを論理削除
3. 成功通知を表示
4. アクティビティプラン一覧画面へリダイレクト

### 03-サブナビゲーション選択

1. Configurationsクラスター内の選択されたリソース画面へ遷移

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | activity_plans | UPDATE | deleted_at設定（論理削除） |

### テーブル別更新項目詳細

#### activity_plans（削除時のみ）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | deleted_at | CURRENT_TIMESTAMP | 論理削除 |

## メッセージ仕様

| メッセージID | 種別 | タイトル | 本文 | 表示条件 |
|-------------|------|---------|------|----------|
| MSG-001 | 成功 | 削除完了 | アクティビティプランが削除されました | 削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処 |
|---------|---------|------|
| レコード不存在 | URLのプランIDが存在しない | 404エラー画面表示 |
| 認証エラー | セッション切れ | ログイン画面へリダイレクト |
| 権限エラー | 閲覧権限なし | 403エラー画面表示 |

## 備考

- Infolistでプランの基本情報を表示
- 各項目にアイコンを付与して視認性を向上
- placeholder('—')で値がない場合のデフォルト表示を設定
- is_activeはIconEntryでブール値をアイコン表示
- 2カラムレイアウトでコンパクトに情報表示
- getSubNavigation()でConfigurationsクラスター内の他リソースへのナビゲーションを提供
- ActivityTemplateRelationManagerでアクティビティテンプレートを閲覧・管理可能
- 詳細画面でもリレーションマネージャーからテンプレートの追加・編集が可能
- 部署マネージャーはdepartment.manager.nameでネストされたリレーションを参照
