# 画面設計書 91-職位一覧

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「職位一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は従業員に割り当てられる職位（Job Position）を一覧表示し、管理するための画面である。

**業務上の目的・背景**：組織内の職位構造を管理し、採用計画や人員配置の基礎データとして活用する。各職位には部署、会社、雇用形態などが紐づけられ、採用目標人数や現在の従業員数を把握できる。これにより人事部門が組織全体の職位構成を俯瞰し、適切な人員計画を立案することが可能となる。

**画面へのアクセス方法**：メインメニューから「従業員」モジュール → 「設定」クラスター → 「職位」を選択してアクセスする。

**主要な操作・処理内容**：
1. 職位データの一覧表示（ID、職位名、部署、会社、ステータスなど）
2. 職位の検索・フィルタリング（部署別、雇用形態別、会社別、ステータス別）
3. 職位のグルーピング表示（職位別、会社別、部署別、雇用形態別など）
4. 新規職位の作成（ヘッダーアクション）
5. 個別職位の表示・編集・削除・復元
6. 複数職位の一括削除・強制削除・復元
7. カスタムビュー（マイ部署、アーカイブ済み）の切り替え

**画面遷移**：
- 本画面から遷移可能：職位作成画面、職位詳細画面、職位編集画面
- 本画面に遷移してくる画面：従業員モジュール設定メニュー、職位詳細画面、職位編集画面

**権限による表示制御**：認証済みユーザーのみアクセス可能。マイ部署ビューではログインユーザーの所属部署に紐づく職位のみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-009 | 職位管理 | 主機能 | 職位の一覧表示、検索、フィルタ、CRUD操作 |

## 画面種別

一覧

## URL/ルーティング

`/employees/configurations/job-positions`

## 画面構成

- ヘッダー部：画面タイトル、新規作成ボタン
- プリセットビュータブ：マイ部署、アーカイブ済み
- テーブル部：職位一覧テーブル（カラム切替、グルーピング、ソート対応）
- フィルタ部：部署、雇用形態、会社、ステータスなどによるフィルタ
- アクション部：行アクション（表示・編集・削除・復元）、一括アクション（削除・強制削除・復元）

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|----------|
| 1 | ID | 数値 | 職位の一意識別子 | デフォルト非表示 |
| 2 | 職位名 | テキスト | 職位の名称 | 常に表示 |
| 3 | 部署名 | テキスト | 所属部署名（リレーション） | 常に表示 |
| 4 | 会社名 | テキスト | 所属会社名（リレーション） | 常に表示 |
| 5 | 予定従業員数 | 数値 | 採用目標人数 | デフォルト非表示 |
| 6 | 現従業員数 | 数値 | 現在の従業員数 | デフォルト非表示 |
| 7 | ステータス | ブール | 有効/無効 | 常に表示 |
| 8 | 作成者 | テキスト | 作成したユーザー名 | デフォルト非表示 |
| 9 | 作成日時 | 日時 | レコード作成日時 | デフォルト非表示 |
| 10 | 更新日時 | 日時 | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「作成」ボタンを押下すると、職位作成画面（/employees/configurations/job-positions/create）に遷移する。

### 2-行クリック（表示）

テーブル行の表示アクションをクリックすると、該当職位の詳細画面に遷移する。

### 3-編集アクション

テーブル行の編集アクションをクリックすると、該当職位の編集画面に遷移する。

### 4-削除アクション

テーブル行の削除アクションをクリックすると、確認後に論理削除が実行される。成功時に通知メッセージが表示される。

### 5-復元アクション

アーカイブ済みビューで復元アクションをクリックすると、論理削除されたレコードが復元される。

### 6-一括削除

テーブル上部の一括アクションから複数選択したレコードを一括で論理削除する。

### 7-強制削除

テーブル上部の一括アクションから複数選択したレコードを完全に削除（物理削除）する。

### 8-ドラッグ並び替え

テーブル行をドラッグして並び替えることで、sortカラムの値が更新される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | employees_job_positions | SELECT | 職位データの取得 |
| 削除 | employees_job_positions | UPDATE | deleted_atカラムを更新（論理削除） |
| 復元 | employees_job_positions | UPDATE | deleted_atカラムをNULLに更新 |
| 強制削除 | employees_job_positions | DELETE | レコードの物理削除 |
| 並び替え | employees_job_positions | UPDATE | sortカラムを更新 |

### テーブル別更新項目詳細

#### employees_job_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在日時 | 論理削除 |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |
| UPDATE（並び替え） | sort | 新しい順序値 | ドラッグ操作時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 職位を削除しました | 削除成功時 |
| MSG-002 | 成功 | 職位を復元しました | 復元成功時 |
| MSG-003 | 成功 | 職位を一括削除しました | 一括削除成功時 |
| MSG-004 | 成功 | 職位を強制削除しました | 強制削除成功時 |
| MSG-005 | 成功 | 職位を一括復元しました | 一括復元成功時 |
| MSG-006 | 成功 | 職位を作成しました | 新規作成成功時（空状態から） |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| データなし | 空状態表示と新規作成ボタンを表示 |
| 削除失敗 | エラー通知を表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのListRecordsページとして実装されている
- HasTableViewsトレイトを使用してプリセットビュー（マイ部署、アーカイブ済み）を提供
- テーブルは並び替え可能（reorderable）でsortカラムによる降順がデフォルト
- SoftDeletesによる論理削除に対応
