# 画面設計書 92-職位作成

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「職位作成」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は新規職位（Job Position）を登録するための入力フォーム画面である。

**業務上の目的・背景**：組織内に新しい職位を追加する際に使用される画面である。職位は従業員の役職や役割を定義するマスタデータであり、採用計画や組織構造の基盤となる。部署、会社、雇用形態との紐付けにより、組織横断的な人事管理を可能にする。

**画面へのアクセス方法**：職位一覧画面のヘッダー「作成」ボタンをクリック、または職位一覧画面の空状態からの作成ボタンをクリックしてアクセスする。

**主要な操作・処理内容**：
1. 職位基本情報の入力（職位名、部署、会社）
2. 職務記述の入力（職務内容、必要要件）
3. 人員計画情報の入力（採用目標人数、雇用形態、ステータス）
4. 関連マスタの新規作成（部署、会社をモーダルで作成可能）
5. フォーム送信による職位データの保存

**画面遷移**：
- 本画面から遷移可能：職位詳細画面（作成完了後）、職位一覧画面（キャンセル時）
- 本画面に遷移してくる画面：職位一覧画面

**権限による表示制御**：認証済みユーザーのみアクセス可能。作成時に現在のログインユーザーがcreator_idに自動設定される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-009 | 職位管理 | 主機能 | 新規職位データの作成 |

## 画面種別

登録

## URL/ルーティング

`/employees/configurations/job-positions/create`

## 画面構成

- ヘッダー部：画面タイトル
- フォーム部（3カラムレイアウト）：
  - 左側2カラム：雇用情報セクション、職務記述セクション
  - 右側1カラム：人員計画セクション
- サブナビゲーション：Configurationsクラスター内のナビゲーション

## 入出力項目

| No | 項目名 | データ型 | 必須 | 最大長 | 説明 | 備考 |
|----|--------|----------|------|--------|------|------|
| 1 | 職位名 | テキスト | ○ | 255 | 職位のタイトル | ヒントアイコン付き |
| 2 | 部署 | 選択 | - | - | 所属部署 | 検索可能、新規作成可能 |
| 3 | 会社 | 選択 | - | - | 所属会社 | 検索可能、新規作成可能 |
| 4 | 職務内容 | リッチテキスト | - | - | 職務の詳細説明 | RichEditor |
| 5 | 必要要件 | リッチテキスト | - | - | 必要なスキル・資格 | RichEditor |
| 6 | 採用目標人数 | 数値 | - | - | 採用予定人数 | 0-99999999999、デフォルト0 |
| 7 | 雇用形態 | 選択 | - | - | 正社員、契約社員等 | 検索可能 |
| 8 | ステータス | トグル | - | - | 有効/無効 | Toggle |

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|----------|
| 1 | 現従業員数 | 数値 | 現在の従業員数（読み取り専用） | 常に表示（無効状態） |
| 2 | 予定従業員数 | 数値 | 予定従業員数（読み取り専用） | 常に表示（無効状態） |

## イベント仕様

### 1-フォーム送信（保存）

フォームの保存ボタンを押下すると以下の処理が実行される：
1. バリデーションチェック（必須項目、最大長など）
2. creator_idに現在のログインユーザーIDを設定
3. employees_job_positionsテーブルへINSERT
4. 成功通知の表示
5. 職位詳細画面へ遷移

### 2-部署選択時の連動

部署を選択すると、その部署に紐づく会社が自動的に会社フィールドに設定される（会社フィールドが未設定の場合）。

### 3-部署新規作成

部署選択フィールドの新規作成オプションをクリックすると、モーダルで部署作成フォームが表示される。

### 4-会社新規作成

会社選択フィールドの新規作成オプションをクリックすると、モーダルで会社作成フォームが表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | employees_job_positions | INSERT | 新規職位データの登録 |
| 部署作成（オプション） | employees_departments | INSERT | 新規部署データの登録 |
| 会社作成（オプション） | companies | INSERT | 新規会社データの登録 |

### テーブル別更新項目詳細

#### employees_job_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | department_id | 選択された部署ID | |
| INSERT | company_id | 選択された会社ID | |
| INSERT | description | フォーム入力値 | HTML形式 |
| INSERT | requirements | フォーム入力値 | HTML形式 |
| INSERT | no_of_recruitment | フォーム入力値 | デフォルト0 |
| INSERT | employment_type_id | 選択された雇用形態ID | |
| INSERT | is_active | フォーム入力値 | boolean |
| INSERT | creator_id | 現在のログインユーザーID | 自動設定 |
| INSERT | sort | 自動採番 | SortableTrait |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 職位を作成しました | 作成成功時 |
| MSG-002 | エラー | 入力内容に誤りがあります | バリデーションエラー時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| バリデーションエラー | 各フィールドにエラーメッセージを表示 |
| 保存失敗 | エラー通知を表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのCreateRecordページとして実装されている
- 作成完了後は自動的に詳細画面（ViewJobPosition）へリダイレクトされる
- 部署選択時の会社自動設定はafterStateUpdatedで実装されている
- 関連マスタ（部署・会社）の新規作成はcreateOptionFormとcreateOptionActionで実装されている
