# 画面設計書 93-職位編集

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「職位編集」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は既存の職位（Job Position）データを編集するためのフォーム画面である。

**業務上の目的・背景**：登録済みの職位情報を修正・更新する際に使用される画面である。組織変更や人員計画の見直しに伴い、職位の所属部署、採用目標人数、ステータスなどを変更する必要がある。本画面により、既存の職位マスタを最新の状態に維持することができる。

**画面へのアクセス方法**：職位一覧画面の行アクションから「編集」を選択、または職位詳細画面のヘッダーから「編集」ボタンをクリックしてアクセスする。

**主要な操作・処理内容**：
1. 既存職位データの表示・確認
2. 職位基本情報の編集（職位名、部署、会社）
3. 職務記述の編集（職務内容、必要要件）
4. 人員計画情報の編集（採用目標人数、雇用形態、ステータス）
5. フォーム送信による職位データの更新
6. 職位の削除

**画面遷移**：
- 本画面から遷移可能：職位詳細画面（保存完了後）、職位一覧画面（削除後）
- 本画面に遷移してくる画面：職位一覧画面、職位詳細画面

**権限による表示制御**：認証済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-009 | 職位管理 | 主機能 | 既存職位データの編集・削除 |

## 画面種別

編集

## URL/ルーティング

`/employees/configurations/job-positions/{record}/edit`

## 画面構成

- ヘッダー部：画面タイトル、表示ボタン、削除ボタン
- フォーム部（3カラムレイアウト）：
  - 左側2カラム：雇用情報セクション、職務記述セクション
  - 右側1カラム：人員計画セクション
- サブナビゲーション：Configurationsクラスター内のナビゲーション

## 入出力項目

| No | 項目名 | データ型 | 必須 | 最大長 | 説明 | 備考 |
|----|--------|----------|------|--------|------|------|
| 1 | 職位名 | テキスト | ○ | 255 | 職位のタイトル | ヒントアイコン付き |
| 2 | 部署 | 選択 | - | - | 所属部署 | 検索可能、新規作成可能 |
| 3 | 会社 | 選択 | - | - | 所属会社 | 検索可能、新規作成可能 |
| 4 | 職務内容 | リッチテキスト | - | - | 職務の詳細説明 | RichEditor |
| 5 | 必要要件 | リッチテキスト | - | - | 必要なスキル・資格 | RichEditor |
| 6 | 採用目標人数 | 数値 | - | - | 採用予定人数 | 0-99999999999 |
| 7 | 雇用形態 | 選択 | - | - | 正社員、契約社員等 | 検索可能 |
| 8 | ステータス | トグル | - | - | 有効/無効 | Toggle |

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|----------|
| 1 | 現従業員数 | 数値 | 現在の従業員数（読み取り専用） | 常に表示（無効状態） |
| 2 | 予定従業員数 | 数値 | 予定従業員数（読み取り専用） | 常に表示（無効状態） |

## イベント仕様

### 1-フォーム送信（保存）

フォームの保存ボタンを押下すると以下の処理が実行される：
1. バリデーションチェック（必須項目、最大長など）
2. employees_job_positionsテーブルへUPDATE
3. 成功通知の表示
4. 職位詳細画面へ遷移

### 2-表示ボタン押下

ヘッダーの表示ボタンを押下すると、該当職位の詳細画面に遷移する。

### 3-削除ボタン押下

ヘッダーの削除ボタンを押下すると以下の処理が実行される：
1. 確認ダイアログの表示
2. 確認後、論理削除（deleted_atに現在日時を設定）
3. 成功通知の表示
4. 職位一覧画面へ遷移

### 4-部署選択時の連動

部署を選択すると、その部署に紐づく会社が自動的に会社フィールドに設定される（会社フィールドが未設定の場合）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存 | employees_job_positions | UPDATE | 職位データの更新 |
| 削除 | employees_job_positions | UPDATE | deleted_atカラムを更新（論理削除） |

### テーブル別更新項目詳細

#### employees_job_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | department_id | 選択された部署ID | |
| UPDATE | company_id | 選択された会社ID | |
| UPDATE | description | フォーム入力値 | HTML形式 |
| UPDATE | requirements | フォーム入力値 | HTML形式 |
| UPDATE | no_of_recruitment | フォーム入力値 | |
| UPDATE | employment_type_id | 選択された雇用形態ID | |
| UPDATE | is_active | フォーム入力値 | boolean |
| UPDATE | updated_at | 現在日時 | 自動設定 |
| UPDATE（削除） | deleted_at | 現在日時 | 論理削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | 職位を更新しました | 保存成功時 |
| MSG-002 | 成功 | 職位を削除しました | 削除成功時 |
| MSG-003 | エラー | 入力内容に誤りがあります | バリデーションエラー時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| レコードなし | 404エラーを表示 |
| バリデーションエラー | 各フィールドにエラーメッセージを表示 |
| 保存失敗 | エラー通知を表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのEditRecordページとして実装されている
- 保存完了後は自動的に詳細画面（ViewJobPosition）へリダイレクトされる
- ヘッダーにはViewActionとDeleteActionが配置されている
- フォーム定義は職位作成画面と共通（JobPositionResource::form()）
