# 画面設計書 94-職位詳細

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「職位詳細」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は既存の職位（Job Position）データの詳細情報を表示するための読み取り専用画面である。

**業務上の目的・背景**：登録済みの職位情報を確認・閲覧する際に使用される画面である。職位の基本情報、職務内容、人員計画情報を一覧で確認でき、人事担当者や管理者が職位の詳細を把握するために活用される。編集画面へのアクセスポイントとしても機能する。

**画面へのアクセス方法**：職位一覧画面の行アクションから「表示」を選択、職位作成画面での作成完了後、または職位編集画面での保存完了後にアクセスする。

**主要な操作・処理内容**：
1. 職位基本情報の表示（職位名、部署、会社）
2. 職務記述の表示（職務内容、必要要件）- HTML形式で整形表示
3. 人員計画情報の表示（予定従業員数、現従業員数、採用目標人数、雇用形態、ステータス）
4. 編集画面への遷移

**画面遷移**：
- 本画面から遷移可能：職位編集画面
- 本画面に遷移してくる画面：職位一覧画面、職位作成画面、職位編集画面

**権限による表示制御**：認証済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-009 | 職位管理 | 主機能 | 職位データの詳細表示 |

## 画面種別

詳細

## URL/ルーティング

`/employees/configurations/job-positions/{record}`

## 画面構成

- ヘッダー部：画面タイトル、編集ボタン
- 詳細表示部（3カラムレイアウト）：
  - 左側2カラム：雇用情報セクション、職務記述セクション
  - 右側1カラム：人員計画セクション
- サブナビゲーション：Configurationsクラスター内のナビゲーション

## 入出力項目

該当なし（読み取り専用画面のため）

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|----------|
| 1 | 職位名 | テキスト | 職位のタイトル | 常に表示 |
| 2 | 部署名 | テキスト | 所属部署名 | 常に表示 |
| 3 | 会社名 | テキスト | 所属会社名 | 常に表示 |
| 4 | 職務内容 | HTML | 職務の詳細説明 | 常に表示 |
| 5 | 必要要件 | HTML | 必要なスキル・資格 | 常に表示 |
| 6 | 予定従業員数 | 数値 | 採用予定を含む合計人数 | 常に表示 |
| 7 | 現従業員数 | 数値 | 現在の従業員数 | 常に表示 |
| 8 | 採用目標人数 | 数値 | 採用予定人数 | 常に表示 |
| 9 | 雇用形態 | テキスト | 正社員、契約社員等 | 常に表示 |
| 10 | ステータス | アイコン | 有効/無効 | 常に表示 |

## イベント仕様

### 1-編集ボタン押下

ヘッダーの編集ボタンを押下すると、該当職位の編集画面に遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 詳細表示 | employees_job_positions | SELECT | 職位データの取得 |
| 詳細表示 | employees_departments | SELECT | 部署データの取得（リレーション） |
| 詳細表示 | companies | SELECT | 会社データの取得（リレーション） |
| 詳細表示 | employees_employment_types | SELECT | 雇用形態データの取得（リレーション） |

### テーブル別更新項目詳細

該当なし（読み取り専用画面のため）

## メッセージ仕様

該当なし（読み取り専用画面のため）

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| レコードなし | 404エラーを表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのViewRecordページとして実装されている
- infolist()メソッドで表示項目が定義されている
- 職務内容と必要要件はHTML形式で表示される（html()メソッド使用）
- 各項目にはアイコンが設定されている（heroicon）
- 値がない場合は「—」プレースホルダが表示される
- レイアウトは3カラム構成：左2カラムに雇用情報・職務記述、右1カラムに人員計画情報
