# 画面設計書 95-カレンダー一覧

## 概要

本ドキュメントは、Aureus ERPシステムの従業員モジュールにおける「カレンダー一覧」画面の設計仕様を定義するものである。

### 本画面の処理概要

本画面は勤務カレンダー（Work Schedule）を一覧表示し、管理するための画面である。

**業務上の目的・背景**：組織内で使用される勤務カレンダー（勤務スケジュール）を管理する。勤務カレンダーは従業員の標準勤務時間、タイムゾーン、フレックスタイム設定などを定義し、勤怠管理や休暇計算の基盤となるマスタデータである。複数の勤務パターン（通常勤務、フレックス、2週間交代制など）を会社ごとに設定できる。

**画面へのアクセス方法**：メインメニューから「従業員」モジュール → 「設定」クラスター → 「カレンダー」を選択してアクセスする。

**主要な操作・処理内容**：
1. カレンダーデータの一覧表示（スケジュール名、タイムゾーン、会社、フレックス有無、ステータスなど）
2. カレンダーの検索・フィルタリング（会社別、ステータス別、フレックス有無、2週間カレンダー有無）
3. カレンダーのグルーピング表示（名前別、タイムゾーン別、ステータス別など）
4. 新規カレンダーの作成（ヘッダーアクション）
5. 個別カレンダーの表示・編集・削除・復元・強制削除
6. 複数カレンダーの一括削除・復元・強制削除
7. タブによるフィルタ（全件、アーカイブ済み）

**画面遷移**：
- 本画面から遷移可能：カレンダー作成画面、カレンダー詳細画面、カレンダー編集画面
- 本画面に遷移してくる画面：従業員モジュール設定メニュー、カレンダー詳細画面、カレンダー編集画面

**権限による表示制御**：認証済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-EMP-015 | カレンダー管理 | 主機能 | カレンダーの一覧表示、検索、フィルタ、CRUD操作 |

## 画面種別

一覧

## URL/ルーティング

`/employees/configurations/calendars`

## 画面構成

- ヘッダー部：画面タイトル、新規作成ボタン
- タブ部：全件タブ（件数表示）、アーカイブ済みタブ（件数表示）
- テーブル部：カレンダー一覧テーブル（カラム切替、グルーピング、ソート、並び替え対応）
- フィルタ部：会社、ステータス、2週間カレンダー、フレックスタイムなどによるフィルタ
- アクション部：行アクション（表示・編集・削除・復元・強制削除）、一括アクション（削除・復元・強制削除）

## 入出力項目

該当なし（一覧画面のため）

## 表示項目

| No | 項目名 | データ型 | 説明 | 表示条件 |
|----|--------|----------|------|----------|
| 1 | ID | 数値 | カレンダーの一意識別子 | デフォルト非表示 |
| 2 | スケジュール名 | テキスト | カレンダーの名称 | 常に表示 |
| 3 | タイムゾーン | テキスト | 適用タイムゾーン | 常に表示 |
| 4 | 会社名 | テキスト | 所属会社名（リレーション） | 常に表示 |
| 5 | フレックスタイム | ブール | フレックス勤務の有無 | 常に表示 |
| 6 | ステータス | ブール | 有効/無効 | 常に表示 |
| 7 | 1日あたり時間 | 数値 | 1日の標準勤務時間 | デフォルト非表示 |
| 8 | 作成者 | テキスト | 作成したユーザー名 | デフォルト非表示 |
| 9 | 作成日時 | 日時 | レコード作成日時 | デフォルト非表示 |
| 10 | 更新日時 | 日時 | レコード更新日時 | デフォルト非表示 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの「作成」ボタンを押下すると、カレンダー作成画面に遷移する。成功時に通知メッセージが表示される。

### 2-タブ切り替え

「全件」タブと「アーカイブ済み」タブを切り替えることで、表示されるデータがフィルタリングされる。各タブには該当するレコード数がバッジで表示される。

### 3-行クリック（表示）

テーブル行の表示アクションをクリックすると、該当カレンダーの詳細画面に遷移する。

### 4-編集アクション

テーブル行の編集アクションをクリックすると、該当カレンダーの編集画面に遷移する。

### 5-削除アクション

テーブル行の削除アクションをクリックすると、確認後に論理削除が実行される。成功時に通知メッセージが表示される。

### 6-復元アクション

アーカイブ済みタブで復元アクションをクリックすると、論理削除されたレコードが復元される。

### 7-強制削除アクション

テーブル行の強制削除アクションをクリックすると、レコードが完全に削除（物理削除）される。

### 8-一括アクション

テーブル上部の一括アクションから複数選択したレコードに対して一括削除・一括復元・一括強制削除を実行できる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | employees_calendars | SELECT | カレンダーデータの取得 |
| 削除 | employees_calendars | UPDATE | deleted_atカラムを更新（論理削除） |
| 復元 | employees_calendars | UPDATE | deleted_atカラムをNULLに更新 |
| 強制削除 | employees_calendars | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### employees_calendars

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | 現在日時 | 論理削除 |
| UPDATE（復元） | deleted_at | NULL | 復元処理 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| MSG-001 | 成功 | カレンダーを作成しました | 新規作成成功時 |
| MSG-002 | 成功 | カレンダーを削除しました | 削除成功時 |
| MSG-003 | 成功 | カレンダーを復元しました | 復元成功時 |
| MSG-004 | 成功 | カレンダーを強制削除しました | 強制削除成功時 |
| MSG-005 | 成功 | カレンダーを一括削除しました | 一括削除成功時 |
| MSG-006 | 成功 | カレンダーを一括復元しました | 一括復元成功時 |
| MSG-007 | 成功 | カレンダーを一括強制削除しました | 一括強制削除成功時 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| データなし | 空状態表示と新規作成ボタンを表示 |
| 削除失敗 | エラー通知を表示 |
| 権限不足 | アクセス拒否 |

## 備考

- 本画面はFilament PHPのListRecordsページとして実装されている
- SoftDeletesによる論理削除に対応
- タブ機能（getTabs）で全件とアーカイブ済みを切り替え可能
- テーブルカラムはドラッグで並び替え可能（reorderableColumns）
- ActionGroupで行アクションがグループ化されている
- QueryBuilderフィルタによる高度な検索が可能
